# Web検索での用例探しガイド

中国語の実用例を効果的に見つけるための検索戦略。

---

## Web検索を使う目的

1. **実際の使用例を見つける**: ネイティブスピーカーの自然な表現、文脈付きの用例
2. **使用頻度を確認する**: よく使われる表現か、現代でも使われているか
3. **自然さを検証する**: 提案した表現が実際に使われているか
4. **バリエーションを発見する**: 似た表現、地域差、文脈による違い

---

## 検索キーワードの作り方

### 基本パターン

#### パターン1: 完全一致検索
```
"[表現]"
```

例: `"有点儿意思"` `"挺好的"` `"搞定了"`

**用途**: 正確にその表現を使っている例を探す

#### パターン2: サイト指定検索
```
"[表現]" site:[サイトドメイン]
```

例:
- `"有点儿意思" site:weibo.com`
- `"挺好的" site:bilibili.com`

**用途**: 特定のプラットフォームでの使用例を探す

#### パターン3: 文脈付き検索
```
"[表現]" + [文脈キーワード]
```

例: `"有点儿意思" 电影` `"挺好的" 味道`

**用途**: 特定の文脈での使用例を探す

#### パターン4: 使用場面の検索
```
"[表現]" + 场合/情况/时候
```

例: `"搞定了" 什么时候用`

**用途**: いつ、どんな場面で使うかを調べる

#### パターン5: バリエーション検索
```
[表現A] OR [表現B] OR [表現C]
```

例: `"挺好的" OR "很好" OR "不错"`

**用途**: 似た表現を比較

### 高度なテクニック

#### 除外検索
```
"[表現]" -[除外ワード]
```

例: `"好吃" -广告` （広告を除外）

#### 期間指定

検索エンジンのツールで期間を指定：
- 過去1年
- 2020年以降

**用途**: 最新の使用例、現代的な表現かを確認

---

## 信頼できる情報源

### SNS・動画プラットフォーム（優先順位：高）

#### Weibo（微博）- weibo.com

**特徴**: リアルタイムの使用例、カジュアルな表現、時事ネタ、流行語

**検索方法**: `"[表現]" site:weibo.com`

**評価ポイント**:
- ✅ ネイティブの自然な使用、最新の用例
- ⚠️ 誤字・俗語も混在

#### bilibili - bilibili.com

**特徴**: 動画コメント、弾幕、若者の表現、ネットスラング

**検索方法**: `"[表現]" site:bilibili.com`

**評価ポイント**:
- ✅ 若者の口語表現、感情表現が豊富
- ⚠️ かなりカジュアル、スラング多用

#### Zhihu（知乎）- zhihu.com

**特徴**: Q&Aサイト、やや知的な議論、詳しい説明

**検索方法**:
- `"[表現]" site:zhihu.com`
- `[表現] 怎么用 site:zhihu.com`

**評価ポイント**:
- ✅ 詳細な説明付き、用法の議論、質が高い
- ⚠️ やや書き言葉寄り

#### Douban（豆瓣）- douban.com

**特徴**: 映画・本のレビュー、長めの感想文、文化的な議論

**評価ポイント**:
- ✅ 文化的な文脈、レビューでの使用例

### ニュース・メディア（優先順位：中）

#### 人民日報 - people.com.cn / 新華社 - xinhuanet.com

**特徴**: 公式ニュース、フォーマルな表現、標準語

**用途**: フォーマルな場面での使用例

---

## 検索戦略

### ステップ1: 基本検索

まず完全一致検索で全体像を把握：

```
"[表現]"
```

**確認ポイント**:
- 検索結果の数（使用頻度の目安）
- トップに出るサイトの種類
- 見出しで分かる使用場面

### ステップ2: SNSでの使用例を探す

実際の使用例を3-5個探す：

```
"[表現]" site:weibo.com
"[表現]" site:bilibili.com
```

**収集する情報**:
- 実際の文章（前後の文脈を含む）
- 投稿日時
- どんな場面で使われているか
- 感情・ニュアンス

### ステップ3: 使用場面を確認

どんな場面で使うかを明確にする：

```
"[表現]" 场景
"[表現]" 什么时候
```

**確認ポイント**:
- カジュアル/フォーマル
- 口語/書き言葉
- どんな相手に使うか

### ステップ4: バリエーションを探す

似た表現や言い換えを探す：

```
"[表現]" 类似
"[表現]" 同义
[表現A] OR [表現B]
```

**収集する情報**:
- 似た意味の表現
- ニュアンスの違い
- 使い分け

### ステップ5: 評価・選別

集めた用例を評価：

**良い用例の条件**:
- ✅ ネイティブスピーカーの使用
- ✅ 文脈が明確
- ✅ 最近の用例（2020年以降推奨）
- ✅ 信頼できるソース

**避けるべき用例**:
- ❌ 学習者の作文
- ❌ 機械翻訳の可能性
- ❌ 文脈不明
- ❌ 古すぎる

---

## 用例の記録と引用

### 用例の記録フォーマット

各用例について以下を記録：

```
**例X**: [プラットフォーム]
> [実際の文章]
> （[日本語訳]）

- **文脈**: [どんな場面で使われているか]
- **学べること**: [この用例から何を学べるか]
- **出典**: [URL または プラットフォーム名 - 日付]
```

### 出典の明示方法

すべての応答の最後に Sources セクション：

```
### Sources:
- [Weibo - 「有点儿意思」の使用例検索](URL)
- [bilibili - 動画コメント分析](URL)
- [Zhihu - 表現の使い分けに関する議論](URL)
```

---

## 検索のベストプラクティス

### DO（すべきこと）

✅ 完全一致検索 `"[表現]"` を使う
✅ サイト指定で信頼できるソースに絞る
✅ 文脈付きの用例を探す
✅ 最新の用例を優先する（2020年以降）
✅ 複数の情報源から用例を集める
✅ 出典を必ず記録する

### DON'T（避けるべきこと）

❌ 学習者サイトの用例を鵜呑みにしない
❌ 古すぎる用例（1990年代等）に頼らない
❌ 機械翻訳の可能性がある文を使わない
❌ 文脈不明な用例を使わない
❌ 出典を明示せずに引用しない
❌ 1つの情報源だけに頼らない

---

## 主要プラットフォーム一覧

| プラットフォーム | URL | 特徴 | 主な用途 |
|---------------|-----|------|---------|
| Weibo | weibo.com | SNS、リアルタイム | 日常表現、流行語 |
| bilibili | bilibili.com | 動画、コメント | 若者の表現、スラング |
| Zhihu | zhihu.com | Q&A | 詳しい説明、用法議論 |
| Douban | douban.com | レビュー | 文化的な文脈 |
| 人民日報 | people.com.cn | ニュース | フォーマルな表現 |
| 新華社 | xinhuanet.com | ニュース | 時事用語 |

---

**重要**: Web検索は手段であり、目的ではありません。最終的には**ネイティブの自然な使用例**を見つけ、**実践的な学習**に役立てることが目標です。