# Tech Debt Report

**Generated:** {timestamp}
**Scope:** {scope_description}
**Scan Time:** {duration}
**Debt Score:** {score}/100

---

## Executive Summary

{summary_paragraph}

**Key Findings:**
- {finding_count} total issues found
- {p0_count} critical issues requiring immediate action
- {p1_count} high-priority issues to address soon
- Debt score is {trend} compared to baseline

---

## Summary Statistics

| Category | Findings | P0 | P1 | P2 | P3 |
|----------|----------|----|----|----|----|
| 🔄 Duplication | {dup_total} | {dup_p0} | {dup_p1} | {dup_p2} | {dup_p3} |
| 🔒 Security | {sec_total} | {sec_p0} | {sec_p1} | {sec_p2} | {sec_p3} |
| 📊 Complexity | {cplx_total} | {cplx_p0} | {cplx_p1} | {cplx_p2} | {cplx_p3} |
| 💀 Dead Code | {dead_total} | {dead_p0} | {dead_p1} | {dead_p2} | {dead_p3} |
| **Total** | **{total}** | **{p0_total}** | **{p1_total}** | **{p2_total}** | **{p3_total}** |

---

## Critical Issues (P0) 🚨

{if p0_count > 0}
{for each p0_finding}
### {file_path}:{line_number}

**Category:** {category}
**Issue:** {issue_description}
**Impact:** {impact_description}
**Recommendation:** {fix_suggestion}

```{language}
{code_snippet}
```

**Fix:**
```{language}
{fixed_code_snippet}
```

---
{end for}
{else}
✅ No critical issues found.
{endif}

---

## High Priority (P1) ⚠️

{if p1_count > 0}
{for each p1_finding}
### {file_path}:{line_number}

**Category:** {category}
**Issue:** {issue_description}
**Impact:** {impact_description}
**Recommendation:** {fix_suggestion}

```{language}
{code_snippet}
```

---
{end for}
{else}
✅ No high-priority issues found.
{endif}

---

## Medium Priority (P2) 📋

{if p2_count > 0}
<details>
<summary>Show {p2_count} medium-priority findings</summary>

{for each p2_finding}
### {file_path}:{line_number}

**Category:** {category}
**Issue:** {issue_description}
**Fix:** {fix_suggestion}

---
{end for}

</details>
{else}
✅ No medium-priority issues found.
{endif}

---

## Low Priority (P3) 🧹

{if p3_count > 0}
<details>
<summary>Show {p3_count} low-priority findings</summary>

{for each p3_finding}
- **{file_path}:{line_number}** - {issue_description}
{end for}

</details>
{else}
✅ No low-priority issues found.
{endif}

---

## Trends

{if baseline_exists}
### Comparison to Baseline

**Baseline:** {baseline_date} (commit {baseline_commit})

| Metric | Baseline | Current | Change |
|--------|----------|---------|--------|
| Debt Score | {baseline_score} | {current_score} | {score_delta} |
| P0 Issues | {baseline_p0} | {current_p0} | {p0_delta} |
| P1 Issues | {baseline_p1} | {current_p1} | {p1_delta} |
| Total Findings | {baseline_total} | {current_total} | {total_delta} |

**Trend:** {trend_description}

{else}
No baseline found. Run `/techdebt --save-baseline` to start tracking trends.
{endif}

---

## Recommendations

### Immediate Actions

{if p0_count > 0}
1. **Address all {p0_count} P0 issues before merging**
   - These represent security or data integrity risks
   - Estimated fix time: {p0_fix_time}
{else}
✅ No immediate actions required
{endif}

### Short-Term (This Sprint)

{if p1_count > 0}
1. **Refactor {high_complexity_count} high-complexity functions**
   - Start with most frequently modified files
   - Estimated time: {p1_fix_time}

2. **Eliminate major code duplication**
   - {dup_p1_count} instances of significant duplication
   - Extract to shared utilities
{else}
✅ No urgent refactoring needed
{endif}

### Medium-Term (This Quarter)

{if p2_count > 0}
1. **Code cleanup sprint**
   - Address {p2_count} medium-priority issues
   - Focus on {top_p2_category}

2. **Establish debt baseline**
   - Track trends over time
   - Set improvement goals
{endif}

### Long-Term

1. **Prevent new debt**
   - Add pre-commit hooks for tech debt scanning
   - Include in CI/CD pipeline
   - Set quality gates for PRs

2. **Regular debt reviews**
   - Weekly P1 triage
   - Monthly full scans
   - Quarterly architectural reviews

---

## Files Analyzed

{file_list_with_counts}

**Total:** {total_files} files, {total_lines} lines analyzed

---

## Auto-Fix Available

{if auto_fix_count > 0}
The following {auto_fix_count} issues can be automatically fixed:

{for each auto_fix}
- [ ] {file_path}:{line_number} - {fix_description}
{end for}

Run `/techdebt --fix` to apply these changes interactively.
{else}
No safe auto-fixes available. All issues require manual review.
{endif}

---

## Next Steps

1. **Review this report** with your team
2. **Address P0 issues** immediately
3. **Create tickets** for P1 findings
4. **Schedule refactoring** for high-impact areas
5. **Track progress** with baseline comparisons

---

*Generated by claude-mods techdebt skill v1.0*
