---
name: agile-ceremonies
description: Agile ceremonies and sprint management specialist. Use when running standups,
  retrospectives, sprint planning, or tracking sprint progress.
author: Joseph OBrien
status: unpublished
updated: '2025-12-23'
version: 1.0.1
tag: skill
type: skill
---

# Agile Ceremonies Skill

Supports agile team ceremonies including standups, retrospectives, and sprint management.

## What This Skill Does

- Structures daily standups
- Facilitates retrospectives
- Tracks sprint progress
- Documents action items
- Measures team health
- Creates weekly summaries

## When to Use

- Daily standups (sync or async)
- Sprint retrospectives
- Sprint planning
- Progress tracking
- Team health checks

## Reference Files

- `references/RETROSPECTIVE.template.md` - Sprint retrospective format
- `references/DAILY_STANDUP.template.md` - Standup formats (individual, team, async)

## Standup Format

- **Yesterday** - What was completed
- **Today** - What's planned
- **Blockers** - What's blocking progress

## Retrospective Format

- **What went well** - Celebrate wins
- **What didn't go well** - Identify issues
- **What we learned** - Capture insights
- **Action items** - Specific improvements

## Best Practices

- Keep standups under 15 minutes
- Make blockers specific and actionable
- Follow up on previous retro actions
- Quantify progress where possible
- Celebrate team accomplishments
