---
name: devops-runbooks
description: Operational runbook and procedure documentation specialist. Use when
  creating incident response procedures, operational playbooks, or system maintenance
  guides.
author: Joseph OBrien
status: unpublished
updated: '2025-12-23'
version: 1.0.1
tag: skill
type: skill
---

# DevOps Runbooks Skill

Creates actionable runbooks for operational procedures, incident response, and system maintenance.

## What This Skill Does

- Creates operational runbooks
- Documents incident procedures
- Defines escalation paths
- Provides troubleshooting guides
- Documents rollback procedures
- Captures operational knowledge

## When to Use

- Incident response planning
- On-call documentation
- System maintenance procedures
- Disaster recovery planning
- Knowledge transfer

## Reference Files

- `references/RUNBOOK.template.md` - Comprehensive operational runbook format

## Runbook Structure

1. **Overview** - Purpose and when to use
2. **Prerequisites** - Access and tools needed
3. **Quick Reference** - Key commands and URLs
4. **Procedure** - Step-by-step with verification
5. **Rollback** - How to revert changes
6. **Troubleshooting** - Common issues
7. **Escalation** - When and how to escalate

## Best Practices

- Commands must be copy-pasteable
- Include expected output for each step
- Document decision points clearly
- Define rollback at each step
- Keep procedures current (test regularly)
- Include escalation contacts
