---
author: Joseph OBrien
status: unpublished
updated: '2025-12-23'
version: 1.0.1
tag: skill
type: reference
parent: global-standards
---

# Coding Style Standards

Detailed guidelines for coding style, naming conventions, and code organization.

## Naming Conventions

### Variables and Functions

- Use descriptive names that reveal intent
- Prefer full words over abbreviations
- Use camelCase for JavaScript/TypeScript
- Use snake_case for Python
- Use PascalCase for classes and types

### Files and Directories

- Use kebab-case for file names
- Match file names to their primary export
- Use descriptive directory names

## Code Organization

### Function Size

- Keep functions small and focused
- Single Responsibility Principle
- Extract complex logic into separate functions

### Structure

- Clear separation of concerns
- Logical grouping of related code
- Consistent indentation and formatting

## DRY Principle

- Extract reusable logic into functions
- Avoid code duplication
- Use shared utilities and helpers

## Formatting

- Consistent indentation (spaces or tabs per project)
- Proper spacing around operators
- Consistent line length limits
- Proper import organization
