#!/usr/bin/env -S uv run --script
# /// script
# requires-python = ">=3.12"
# dependencies = [
#   "{{DEPENDENCY_1}}",
#   "{{DEPENDENCY_2}}",
# ]
# [tool.uv]
# exclude-newer = "{{ISO_DATE}}"
# ///
"""{{SCRIPT_DESCRIPTION}}

Usage:
    uv run {{SCRIPT_NAME}}.py [OPTIONS] [ARGUMENTS]

Examples:
    uv run {{SCRIPT_NAME}}.py --help
    uv run {{SCRIPT_NAME}}.py input.txt
    uv run {{SCRIPT_NAME}}.py --verbose --output results.json

Requirements:
    - uv (https://docs.astral.sh/uv/)
    - Python 3.12+

The script will automatically install dependencies on first run.
"""

import argparse
import sys
from pathlib import Path


def parse_args() -> argparse.Namespace:
    parser = argparse.ArgumentParser(
        description="{{SCRIPT_DESCRIPTION}}",
        formatter_class=argparse.RawDescriptionHelpFormatter,
    )
    parser.add_argument(
        "input",
        type=Path,
        nargs="?",
        help="Input file path",
    )
    parser.add_argument(
        "-o",
        "--output",
        type=Path,
        help="Output file path",
    )
    parser.add_argument(
        "-v",
        "--verbose",
        action="store_true",
        help="Enable verbose output",
    )
    return parser.parse_args()


def main() -> int:
    args = parse_args()

    if args.verbose:
        print(f"Input: {args.input}")
        print(f"Output: {args.output}")

    # {{MAIN_LOGIC}}

    return 0


if __name__ == "__main__":
    sys.exit(main())
