---
name: security-audit
description: Security auditing and vulnerability assessment specialist. Use when conducting
  security reviews, analyzing code for vulnerabilities, performing OWASP assessments,
  or creating security audit reports.
author: Joseph OBrien
status: unpublished
updated: '2025-12-23'
version: 1.0.1
tag: skill
type: skill
---

# Security Audit Skill

Comprehensive security auditing covering code review, vulnerability assessment, OWASP Top 10, dependency analysis, and remediation planning.

## What This Skill Does

- Conducts security code reviews
- Identifies vulnerabilities (CVSS scoring)
- Performs OWASP Top 10 assessments
- Audits authentication/authorization
- Reviews data protection controls
- Analyzes dependency vulnerabilities
- Creates remediation roadmaps

## When to Use

- Security reviews before release
- Compliance audits
- Penetration test preparation
- Incident response analysis
- Dependency vulnerability assessment

## Reference Files

- `references/SECURITY_AUDIT.template.md` - Comprehensive security audit report format
- `references/owasp_checklist.md` - OWASP Top 10 checklist with CVSS scoring and CWE references

## Workflow

1. Define scope and methodology
2. Perform static/dynamic analysis
3. Document findings by severity
4. Map to OWASP categories
5. Create remediation roadmap
6. Verify fixes

## Output Format

Security findings should include:

- Severity (Critical/High/Medium/Low)
- CVSS score and vector
- CWE classification
- Proof of concept
- Remediation steps
