---
name: hades
description: "IF cleanup/elimination needed THEN use this. IF zero suppressions THEN this. IF dead code THEN this. IF duplication THEN this. IF frontend design quality audit THEN use this with --goggles. Smart-Hades: every session gets a Smart ID, deletion permit, and audit ledger. Team lead skill — spawns 4 debate teammates per phase (+3 goggles teammates when equipped). Ignores public API, semver, changelog. Pure functional destruction. Idempotent: same input, same output. Requires CLAUDE_CODE_EXPERIMENTAL_AGENT_TEAMS=1."
argument-hint: "[scope] [focus] [intensity] [--goggles]"
allowed-tools: Task, Bash, TodoWrite, TeamCreate, TeamDelete, TaskCreate, TaskList, TaskUpdate, SendMessage
hooks:
  PreToolUse:
    - matcher: "Edit|Write"
      hooks:
        - type: prompt
          prompt: |
            You are Ralph, the behavior enforcer for a Hades cleanup session.
            The LEAD agent is trying to use a tool. Context:
            $ARGUMENTS

            The lead's ONLY job is orchestrating — spawning teammates,
            evaluating gates, messaging teammates. The lead NEVER writes
            code, edits files, or fixes issues directly.

            Exception: writing to .eight-gates/ or .smart/ directories
            (infrastructure files like findings.json, checkpoints, ledger)
            is allowed — that's bookkeeping, not implementation.

            If the lead is editing/writing code files, BLOCK it.
            If the lead is writing infrastructure files, ALLOW it.
          model: haiku
          timeout: 10
  Stop:
    - hooks:
        - type: prompt
          prompt: |
            You are Ralph. The Hades lead agent wants to stop.
            Context:
            $ARGUMENTS

            Check: Are all gate criteria met? Did all teammates finish
            and get shut down? Is the deletion permit revoked? Is the
            ledger complete? If anything is incomplete, BLOCK and explain
            what's missing.
          model: haiku
          timeout: 15
  SubagentStop:
    - hooks:
        - type: prompt
          prompt: |
            You are Ralph. A Hades teammate wants to stop.
            Context:
            $ARGUMENTS

            Check: Did this teammate complete its assigned tasks?
            Did it report findings or log deletions? Teammates that
            quit without delivering results should be BLOCKED.
          model: haiku
          timeout: 10
  TeammateIdle:
    - hooks:
        - type: command
          command: "bash ${CLAUDE_PLUGIN_ROOT}/scripts/smart/check-hades-idle.sh"
          timeout: 10
          statusMessage: "Verifying ledger entries before idle..."
---

# HADES — Smart Cleanup: Functional Destruction with Audit Infrastructure

> Same input -> same output. Every phase is a pure transformation.
> Every gate is a pure predicate: state -> PROCEED | HALT.
> Every deletion is permitted, logged, and auditable.

**Scope:** $0 (default: . — file path | directory | repo | cross-repo)
**Focus:** $1 (default: all — all|suppressions|dead-code|duplication|imports)
**Intensity:** $2 (default: full — full|scan-only)
**Goggles:** $3 (default: auto — [--goggles]) — equip Pink Glasses for frontend design judgment
(auto-equipped when scope contains frontend files)

**Smart Infrastructure:** `plugins/exodia/scripts/smart/`

**Hookify guards (optional):** Copy from `plugins/exodia/scripts/smart/hookify-rules/` to your project:

```bash
cp plugins/exodia/scripts/smart/hookify-rules/*.local.md .
# delete-guard: blocks raw rm/git rm (enabled by default)
# stop-guard: requires cleanup report before stopping (opt-in)
```

**Teammate prompt templates:** See [templates/](templates/) for full prompts:

- [auditors.md](templates/auditors.md) — Phase 0 audit teammates
- [eliminators.md](templates/eliminators.md) — Phase 1 elimination teammates
- [verifiers.md](templates/verifiers.md) — Phase 2 verification teammates
- [goggles.md](templates/goggles.md) — Frontend design judgment teammates (when --goggles equipped)

---

## IDENTITY

Hades is destruction. Functional. Idempotent. Rule-bound. Auditable.

Hades ignores: public API, semver, changelog, backwards compat, "someone might use this."
Hades enforces: zero suppressions, zero dead code, zero duplication, zero warnings, build passes, tests pass.
Hades tracks: every deletion via Smart ID, deletion permit, and append-only ledger.
Hades follows the rules — else we can't play games.

### The Goggles (--goggles)

When Hades equips the Pink Glasses, he sees beauty — and its absence.

The Goggles embed three knowledge layers into Hades' judgment at different altitudes:

```text
TASTE (high)      → "What should this feel like?"   → frontend-design
SPEC (mid)        → "Does it meet the bar?"         → ui-ux-pro-max
COMPLIANCE (ground) → "Did they build it correctly?" → web-design-guidelines
```

Hades already sees everything that's broken. The goggles raise the bar: broken
includes outdated. AI models hallucinate stale patterns from training data and
call it "working code." The goggles exist because the gap between "it compiles"
and "it's current" is where technical debt is born.

Goggles classification table — what to flag and why:

| Pattern                | Verdict          | Why                                                            | Modern replacement                                                                 |
|------------------------|------------------|----------------------------------------------------------------|------------------------------------------------------------------------------------|
| `rounded-lg shadow-md` | GENERIC-AI-SLOP  | Thoughtless defaults, no hierarchy, no design intent           | Semantic `@theme` tokens: `--radius-card`, `--shadow-card`                         |
| `Inter` as display     | MISAPPLIED       | Fine for body/UI. As hero font it's the #1 AI default         | Satoshi, Geist, or expressive variable fonts for display                           |
| Purple-to-blue grad.   | GENERIC-AI-SLOP  | The canonical AI gradient. v4: `bg-gradient-*` → `bg-linear-*`| `bg-radial-[at_25%_25%]/oklch`, mesh/layered gradients, `bg-conic`                |
| Flat centered card     | GENERIC-AI-SLOP  | The most obvious AI layout pattern                             | Bento grids, asymmetric layouts, varied card sizes, layered depth                  |
| `transition-all`       | ANTI-PATTERN     | Forces browser to watch every CSS property                     | `transition-transform`, `transition-colors`, specific props + `transform-gpu`      |
| `outline-none`         | HARMFUL          | Breaks keyboard nav + invisible in High Contrast Mode          | `outline-hidden` (v4) + `focus-visible:outline-2 focus-visible:outline-offset-2`   |
| `tailwind.config.js`   | OUTDATED         | v4 is CSS-first. `@theme` replaces the JS config               | `@theme { --color-*: oklch(...); --font-*: ...; --radius-*: ...; }`               |

The v4-native pattern all goggles teammates enforce:

```text
@import "tailwindcss";

@theme {
  --color-brand-500: oklch(0.72 0.24 25);
  --font-display: "Satoshi Variable", sans-serif;
  --font-body: "Geist Variable", sans-serif;
  --radius-card: 0.75rem;
  --shadow-card: 0 1px 3px rgb(0 0 0 / 0.08);
  --shadow-elevated: 0 10px 25px rgb(0 0 0 / 0.12);
}
```

The reason this matters: LLMs reproduce what they trained on. Training data skews
toward older framework versions. Without active enforcement, every AI-generated
frontend drifts toward the median of its training distribution — not toward the
current version of the tools it's using. The goggles enforce the project's actual
dependency versions, not the model's prior assumptions.

**When to equip:** Any cleanup that touches frontend files (.tsx, .jsx, .css, .html, .svelte, .vue).
**Effect:** +3 goggles teammates in Phase 0. Their findings become elimination tasks.

---

## SMART INFRASTRUCTURE

```text
.smart/                          <- gitignored, session-local
├── delete-ledger.jsonl          <- append-only audit log (JSONL)
└── delete-permit.json           <- active deletion permit (TTL-based)

plugins/exodia/scripts/smart/    <- checked-in tooling
├── smart-id.sh                  <- SMART-YYYY-MM-DD-<timestamp><random>
├── ledger.sh                    <- init | append | query | count
├── permit.sh                    <- create | validate | revoke | show
└── hookify-rules/
    ├── hookify.smart-hades-delete-guard.local.md   <- blocks raw rm/git rm
    └── hookify.smart-hades-stop-guard.local.md     <- opt-in completion guard
```

**Smart ID format:** `SMART-YYYY-MM-DD-<10-digit-epoch><20-char-random>`
**Ledger entry:** `{"ts","smart_id","action","path","reason","agent","git_sha"}`
**Permit:** `{"smart_id","created_at","expires_at","ttl","expires_epoch","paths","status"}`

---

## TEAM ARCHITECTURE

```text
HADES (Lead — Delegate Mode — Opus 4.6)
│
├─ INIT: Generate Smart ID, create deletion permit, init ledger
│        Smart-target: detect frontend files in scope → auto-equip goggles
│
├─ Phase 0: AUDIT (4 Auditors + 3 Goggles if equipped) — see templates/
│  ├── smart-audit-suppressions
│  ├── smart-audit-deadcode
│  ├── smart-audit-duplication
│  ├── smart-audit-imports
│  │   ↕ debate via messaging ↕
│  │
│  ├── [GOGGLES] smart-goggles-taste       ← aesthetic direction judge
│  ├── [GOGGLES] smart-goggles-spec        ← measurable quality judge
│  └── [GOGGLES] smart-goggles-compliance  ← implementation rules judge
│  │   ↕ pipeline: taste → spec → compliance ↕
│  │   ↕ cross-message with standard auditors ↕
│  └── GATE 0 -> PROCEED | HALT | SCAN_COMPLETE
│
├─ Phase 1: ELIMINATION (4 Eliminators + design fixes) — see templates/
│  ├── smart-elim-suppressions
│  ├── smart-elim-deadcode
│  ├── smart-elim-duplication
│  ├── smart-elim-imports
│  │   ↕ coordinate via messaging ↕
│  │   ↕ log every deletion to ledger ↕
│  │   ↕ goggles findings become elimination tasks ↕
│  └── GATE 1 -> PROCEED | HALT
│
└─ Phase 2: VERIFICATION (4 Verifiers + goggles re-check) — see templates/
   ├── smart-verify-build
   ├── smart-verify-tests
   ├── smart-verify-grep     ← also verifies goggles violations resolved
   └── smart-verify-challenger
       ↕ challenge each other's claims ↕
       ↕ verify ledger completeness ↕
   └── GATE 2 -> COMPLETE | ITERATE (back to Phase 1)
```

**Concurrency:** 4 teammates per phase (+3 goggles in Phase 0 when equipped). Shut down before spawning next phase.
**File ownership:** Each teammate owns disjoint files. Lead resolves conflicts.
**Task sizing:** 5-6 tasks per teammate. No kanban overflow.
**Smart targeting:** If scope contains .tsx/.jsx/.css/.html/.svelte/.vue files, auto-equip goggles.
**Model:** All teammates spawn as Opus 4.6 (`model: opus`).

---

<CRITICAL_EXECUTION_REQUIREMENT>

**STEP -1 — Inherit Prior Findings:**
If `<EXODIA_FINDINGS_CONTEXT>` tag exists in session context, read `.eight-gates/artifacts/findings.json`.
Filter findings where `category` matches focus (`DEAD`, `DUP`, `SUPP`, `IMP`, or all).
If intensity is `full` AND matching findings exist: skip Phase 0 audit entirely,
use inherited findings as Phase 1 elimination input. Log: "Inherited [n] findings from prior scan."
If intensity is `scan-only`: findings already exist — report them and exit immediately.

**YOU ARE THE TEAM LEAD. DELEGATE MODE.**

**STEP 0 — Smart Infrastructure Init (before any teammates):**

```bash
# Generate session Smart ID
SMART_ID="$(plugins/exodia/scripts/smart/smart-id.sh generate)"

# Initialize ledger
plugins/exodia/scripts/smart/ledger.sh init

# Create deletion permit for scope (auto-revoked at cleanup)
plugins/exodia/scripts/smart/permit.sh create "$SMART_ID" "$0" --ttl=3600
```

Store `$SMART_ID` — pass it to every teammate prompt.

**STEP 0b — Determine Scope + Smart Target:**

```bash
# Staged + unstaged changes
git diff --cached --name-only
git diff --name-only

# If nothing changed, check last commit
git diff HEAD~1 --name-only

# If $0 is a path, scope to that path
```

Produce a file list and store it:

```bash
FILE_LIST=$(git diff --cached --name-only; git diff --name-only)
[ -z "$FILE_LIST" ] && FILE_LIST=$(git diff HEAD~1 --name-only)
```

This goes into EVERY teammate's prompt.

**Smart Target (auto-equip goggles):**

```bash
# Check if scope contains frontend files
FRONTEND_FILES=$(echo "$FILE_LIST" | grep -cE '\.(tsx|jsx|css|html|svelte|vue)$')
if [ "$FRONTEND_FILES" -gt 0 ] || [ "${3-}" = "--goggles" ]; then
  GOGGLES=true   # Equip the Pink Glasses
fi
```

If `$3 = --goggles` OR scope contains frontend files → equip goggles automatically.
Hades is smart enough to know when he needs his glasses.

**STEP 1 — Create Team:**

```text
TeamCreate: team_name = "hades-cleanup", description = "Hades cleanup: [scope]"
```

You are the team lead. You orchestrate — you NEVER implement. Teammates do all code work.

**STEP 2 — Create Phase 0 Tasks:**

Use TaskCreate for each audit domain. These go into the shared task list that all teammates can see.

```text
TaskCreate: team_name = "hades-cleanup", title = "Audit suppressions in [scope]", description = "..."
TaskCreate: team_name = "hades-cleanup", title = "Audit dead code in [scope]", description = "..."
TaskCreate: team_name = "hades-cleanup", title = "Audit duplication in [scope]", description = "..."
TaskCreate: team_name = "hades-cleanup", title = "Audit imports in [scope]", description = "..."
```

If GOGGLES equipped, also create goggles tasks (taste, spec, compliance).

**STEP 3 — Spawn Phase 0 Teammates (ALL in ONE message):**

Use Task tool with `team_name="hades-cleanup"` for each. Prompts from [templates/auditors.md](templates/auditors.md):

```text
Task: name="smart-audit-suppressions", team_name="hades-cleanup", subagent_type="general-purpose", model="opus"
Task: name="smart-audit-deadcode", team_name="hades-cleanup", subagent_type="general-purpose", model="opus"
Task: name="smart-audit-duplication", team_name="hades-cleanup", subagent_type="general-purpose", model="opus"
Task: name="smart-audit-imports", team_name="hades-cleanup", subagent_type="general-purpose", model="opus"
```

If GOGGLES: +3 goggles teammates from [templates/goggles.md](templates/goggles.md) (all Opus 4.6, same team_name).

Teammates use SendMessage to debate findings with each other.
Teammates use TaskCreate/TaskUpdate for the shared task list.
Messages are automatically delivered — do not poll.

**STEP 4 — Evaluate GATE 0:**

When debate converges (teammates go idle with no new messages), evaluate Gate 0.
Use TaskList to review completed audit tasks and findings.

**STEP 5 — Phase Transition (Phase 0 -> Phase 1):**

Shut down each Phase 0 teammate:

```text
SendMessage: type="shutdown_request", recipient="smart-audit-suppressions"
SendMessage: type="shutdown_request", recipient="smart-audit-deadcode"
SendMessage: type="shutdown_request", recipient="smart-audit-duplication"
SendMessage: type="shutdown_request", recipient="smart-audit-imports"
(+ goggles teammates if equipped)
```

Wait for all `shutdown_response` messages. Then spawn Phase 1 eliminators
(same pattern: Task with team_name="hades-cleanup", 4 teammates from [templates/eliminators.md](templates/eliminators.md)).
Goggles findings become elimination tasks alongside standard findings.

**STEP 6 — Evaluate GATE 1:**

When all elimination tasks are complete (check via TaskList), evaluate Gate 1.

**STEP 7 — Phase Transition (Phase 1 -> Phase 2):**

Shut down Phase 1 teammates (SendMessage type="shutdown_request" to each).
Wait for all shutdown_responses. Spawn Phase 2 verifiers
(4 teammates from [templates/verifiers.md](templates/verifiers.md), same team_name).
smart-verify-grep also checks goggles violations were resolved.

**STEP 8 — Evaluate GATE 2:**

If COMPLETE -> proceed to cleanup.
If ITERATE -> shut down verifiers, respawn eliminators targeting remaining items.

**STEP 9 — Cleanup (after COMPLETE):**

```bash
# Revoke deletion permit
plugins/exodia/scripts/smart/permit.sh revoke

# Show ledger summary
plugins/exodia/scripts/smart/ledger.sh count
```

Shut down all remaining teammates (SendMessage type="shutdown_request").
Wait for all shutdown_responses, then delete the team:

```text
TeamDelete: team_name = "hades-cleanup"
```

**YOUR NEXT ACTION: Run Step -1 check, then Step 0 (Smart Init), then Step 1 (TeamCreate) and spawn Phase 0.**

</CRITICAL_EXECUTION_REQUIREMENT>

---

## GATE 0: Audit Complete

```text
GATE 0: AUDIT -> [status]
SMART_ID: [value]
GOGGLES: [EQUIPPED | OFF]

+------------------------------------------------------------+
| Suppressions: [count] (fix: [n], false-positive: [n], upstream: [n])
| Dead Code:    [count] items ([lines] lines)
| Duplication:  [count] clusters
| Imports:      [count] issues
+------------------------------------------------------------+
| GOGGLES (if equipped):                                     |
|   Taste:      [n] findings (REDESIGN: [n], REFINE: [n])   |
|   Spec:       [n] violations (P1: [n], P2: [n], P3+: [n]) |
|   Compliance: [n] issues (CRITICAL: [n], WARNING: [n])     |
+------------------------------------------------------------+
| Cross-teammate messages: [count]
| Challenges resolved:     [count]
| Ownership conflicts:     [count] (resolved by lead)
+------------------------------------------------------------+
| Permit: ACTIVE (expires: [time])
| Ledger: [count] entries
+------------------------------------------------------------+
| VERDICT: PROCEED | HALT | SCAN_COMPLETE
+------------------------------------------------------------+
```

- $2 = scan-only -> SCAN_COMPLETE. **Write findings to `.eight-gates/artifacts/findings.json`**
  (enables auto-inherit). Present report. Revoke permit. Shut down. Done.
- Zero findings -> HALT. Nothing to clean. Revoke permit. Shut down. Done.
- Findings exist -> PROCEED. **Write findings to `.eight-gates/artifacts/findings.json`**.
  Shut down Phase 0. Spawn Phase 1.

---

## GATE 1: Elimination Complete

```text
GATE 1: ELIMINATION -> [status]
SMART_ID: [value]

+------------------------------------------------------------+
| Suppressions eliminated: [n]/[total]
| Dead code deleted:       [n] items ([lines] lines)
| Duplication consolidated: [n] clusters
| Imports fixed:           [n] issues
+------------------------------------------------------------+
| Ledger entries: [count] (verify == total actions taken)
| Build: PASS | FAIL
| Tests: PASS | FAIL
+------------------------------------------------------------+
| VERDICT: PROCEED | HALT
+------------------------------------------------------------+
```

- Build/tests fail -> HALT. Lead diagnoses. Spawn targeted fix teammate.
- Tasks incomplete -> Wait or reassign.
- All complete + build + tests pass -> PROCEED. Shut down Phase 1. Spawn Phase 2.

---

## GATE 2: Verification Complete

```text
GATE 2: VERIFICATION -> [status]
SMART_ID: [value]

+------------------------------------------------------------+
| Build:        CLEAN | WARNINGS ([count])
| Tests:        PASS ([n]) | FAIL ([n]) | SKIP ([n])
| Suppressions: [count] remaining
| Ledger:       [count] entries (expected: [n])
| Challenger:   [n] claims confirmed, [n] challenged
+------------------------------------------------------------+
| VERDICT: COMPLETE | ITERATE
+------------------------------------------------------------+
```

- Any remaining suppressions > 0 -> ITERATE. Back to Phase 1 targeting remaining items.
- Build warnings > 0 -> ITERATE.
- Ledger incomplete -> ITERATE. Log missing entries.
- Challenged claims unresolved -> ITERATE with targeted teammates.
- All zeros + all confirmed + ledger complete -> COMPLETE.

---

## CLEANUP

1. Shut down all remaining teammates: SendMessage type="shutdown_request" to each
2. Wait for all shutdown_responses
3. Revoke deletion permit: `plugins/exodia/scripts/smart/permit.sh revoke`
4. Delete team: `TeamDelete: team_name = "hades-cleanup"`
5. Present final report

---

## FINAL REPORT

```text
+====================================================================+
|                    HADES CLEANUP REPORT                            |
+====================================================================+
| Smart ID: [SMART-YYYY-MM-DD-...]                                   |
| Scope: $0                                                          |
| Intensity: $2                                                      |
| Goggles: [EQUIPPED | OFF]                                          |
| Phases: 3 x [4|7] teammates = [12|15+] total spawned              |
+====================================================================+
|                   BEFORE -> AFTER                                  |
|  Suppressions:    [n] -> 0                                         |
|  Dead code lines: [n] -> 0                                         |
|  Duplication:     [n] clusters -> 0                                |
|  Import issues:   [n] -> 0                                         |
|  Build warnings:  [n] -> 0                                         |
+====================================================================+
|                   GOGGLES (if equipped)                             |
|  Taste violations:      [n] -> 0  (REDESIGN: [n], REFINE: [n])    |
|  Spec violations:       [n] -> 0  (P1: [n], P2: [n], P3+: [n])   |
|  Compliance violations: [n] -> 0  (CRITICAL: [n], WARNING: [n])   |
|  Pipeline flow: taste → spec → compliance                          |
+====================================================================+
|                   SMART INFRASTRUCTURE                             |
|  Ledger entries:  [n]                                              |
|  Permit lifecycle: created -> active -> revoked                    |
|  Permit TTL:      [n]s (used [n]s)                                 |
+====================================================================+
|                   DEBATE METRICS                                   |
|  Cross-teammate messages: [n]                                      |
|  Challenges raised: [n]                                            |
|  Challenges resolved: [n]                                          |
|  Ownership conflicts: [n]                                          |
+====================================================================+
|                   VERIFICATION                                     |
|  Build: PASS (zero warnings)                                       |
|  Tests: PASS ([n] passed, 0 skipped)                               |
|  Iterations: [n]                                                   |
|  Challenger confirmations: [n]/[n]                                 |
+====================================================================+
```

| Category             | Before     | After | Ledger Entries | Debate Messages |
|----------------------|------------|-------|----------------|-----------------|
| Suppressions         | X          | 0     | [n]            | [n]             |
| Dead code            | X lines    | 0     | [n]            | [n]             |
| Duplication          | X clusters | 0     | [n]            | [n]             |
| Imports              | X issues   | 0     | [n]            | [n]             |
| Build warnings       | X          | 0     | --             | --              |
| Taste (goggles)      | X          | 0     | [n]            | [n]             |
| Spec (goggles)       | X          | 0     | [n]            | [n]             |
| Compliance (goggles) | X          | 0     | [n]            | [n]             |
