---
name: writing-rules
description: >
  Guide for creating hookify rules to prevent unwanted AI behaviors.
  Use when user asks to create, write, or configure hookify rules.
---

# Writing Hookify Rules

## When to Use

- User asks to create, write, or configure hookify rules
- User wants to prevent specific behaviors in Claude Code

## Process

1. **Identify the behavior** to prevent
2. **Choose the event type** (bash, file, stop, prompt, all)
3. **Write the pattern** (regex or conditions)
4. **Create the rule file** in `.claude/hookify.{name}.local.md`
5. **Test immediately** — rules take effect on next tool use

## Rule File Format

```markdown
---
name: rule-identifier
enabled: true
event: bash|file|stop|prompt|all
pattern: regex-pattern-here
---

Message shown to Claude when rule triggers.
```

## Event Types

| Event | Matches Against | Use For |
|-------|----------------|---------|
| `bash` | Command text | Dangerous commands, privilege escalation |
| `file` | File path + content | Debug code, sensitive files, security risks |
| `stop` | Always (use `.*`) | Completion checklists, required steps |
| `prompt` | User prompt text | Deployment gates, process enforcement |
| `all` | All events | Cross-cutting concerns |

## Actions

- `warn` (default): Show message, allow operation
- `block`: Prevent operation entirely

## Advanced: Multiple Conditions

```yaml
conditions:
  - field: file_path
    operator: regex_match
    pattern: \.env$
  - field: new_text
    operator: contains
    pattern: API_KEY
```

**Operators:** `regex_match`, `contains`, `equals`, `not_contains`, `starts_with`, `ends_with`

**Fields:** bash → `command` | file → `file_path`, `new_text`, `old_text`, `content` | prompt → `user_prompt`

All conditions must match for the rule to trigger.

## File Organization

- **Location:** `.claude/hookify.{descriptive-name}.local.md`
- **Gitignore:** Add `.claude/*.local.md` to `.gitignore`
- **Naming:** Start with verb: `warn-dangerous-rm`, `block-console-log`, `require-tests`

See `references/` for regex patterns, examples, and common pitfalls.
