# 市场研究报告数据分析模式

用于进行严格市场分析的模板和框架。

---

## 市场规模框架

### TAM/SAM/SOM分析

**总可获得市场（TAM）**代表如果实现100%市场份额的可用总收入机会。

#### 自上而下方法
```
TAM = 行业总收入（来自市场研究报告）

示例：
- 全球AI软件市场（2024）：1840亿美元
- 来源：高德纳、IDC或类似
```

#### 自下而上方法
```
TAM = 潜在客户数量 × 平均每客户收入

示例：
- 全球企业数量：4亿
- 目标细分（大企业）：50,000
- 解决方案平均年支出：500,000美元
- TAM = 50,000 × 500,000 = 250亿美元
```

**可服务可获得市场（SAM）**代表在给定产品/服务能力的情况下可以服务的TAM部分。

```
SAM = TAM × 适用细分 %

示例：
- TAM：250亿美元
- 地理限制（仅北美）：40%
- 产品适配（仅企业）：60%
- SAM = 250亿美元 × 40% × 60% = 60亿美元
```

**可获得服务市场（SOM）**代表现实的市场份额获取。

```
SOM = SAM × 可实现市场份额 %

示例：
- SAM：60亿美元
- 保守市场份额（5%）：3亿美元
- 基础情况市场份额（10%）：6亿美元
- 乐观市场份额（15%）：9亿美元
```

### 增长率计算

#### CAGR（复合年增长率）
```
CAGR = (结束值 / 开始值)^(1/n) - 1

其中n = 年数

示例：
- 2020年市场规模：100亿美元
- 2024年市场规模：180亿美元
- n = 4年
- CAGR = (180/100)^(1/4) - 1 = 15.8%
```

#### 同比增长
```
同比增长 = (当年 - 上年) / 上年 × 100

示例：
- 2023年：150亿美元
- 2024年：180亿美元
- 同比增长 = (180-150)/150 × 100 = 20%
```

---

## 波特五力分析

### 框架模板

对每种力量，评估：**高**、**中**或**低**

#### 1. 新进入者威胁

**评估因素：**
| 因素 | 评估 | 备注 |
|------|------|------|
| 资本要求 | 高/中/低 | 进入所需资本 |
| 规模经济 | 强/中/弱 | 现有企业优势 |
| 品牌忠诚度 | 高/中/低 | 客户转换成本 |
| 分销渠道获取 | 易/中/难 | 渠道可用性 |
| 监管壁垒 | 高/中/低 | 许可、认证 |
| 专有技术 | 关键/重要/次要 | IP和专有技术 |
| 预期报复 | 激烈/中等/被动 | 现有企业响应 |

**总体评估：**[高/中/低]

**关键洞察：**[含义摘要]

#### 2. 供应商议价能力

**评估因素：**
| 因素 | 评估 | 备注 |
|------|------|------|
| 供应商集中度 | 高/中/低 | 供应商数量 |
| 转换成本 | 高/中/低 | 更换供应商成本 |
| 供应商差异化 | 高/中/低 | 投入独特性 |
| 前向整合威胁 | 高/中/低 | 供应商能否竞争？ |
| 对供应商重要性 | 关键/重要/次要 | 你占其收入的比例 |
| 替代投入 | 许多/一些/少数 | 可用替代品 |

**总体评估：**[高/中/低]

#### 3. 买方议价能力

**评估因素：**
| 因素 | 评估 | 备注 |
|------|------|------|
| 买方集中度 | 高/中/低 | 大客户vs多小客户 |
| 采购量 | 大/中/小 | 相对重要性 |
| 转换成本 | 低/中/高 | 更换供应商成本 |
| 价格敏感性 | 高/中/低 | 关注价格vs价值 |
| 后向整合威胁 | 高/中/低 | 买方能否自给？ |
| 信息可用性 | 完全/部分/有限 | 市场透明度 |

**总体评估：**[高/中/低]

#### 4. 替代品威胁

**评估因素：**
| 因素 | 评估 | 备注 |
|------|------|------|
| 替代品可用性 | 许多/一些/少数 | 替代品数量 |
| 价格性能比 | 更好/相同/更差 | 价值比较 |
| 转换成本 | 低/中/高 | 替换摩擦 |
| 买方转换倾向 | 高/中/低 | 转换意愿 |
| 感知差异化 | 低/中/高 | 独特价值 |

**总体评估：**[高/中/低]

#### 5. 竞争对抗

**评估因素：**
| 因素 | 评估 | 备注 |
|------|------|------|
| 竞争者数量 | 许多/几个/少数 | 市场碎片化 |
| 行业增长 | 慢/中/快 | 增长率影响 |
| 固定成本 | 高/中/低 | 填满产能压力 |
| 产品差异化 | 低/中/高 | 商品化水平 |
| 退出壁垒 | 高/中/低 | 离开市场难度 |
| 战略重要性 | 高/中/低 | 对竞争者的重要性 |

**总体评估：**[高/中/低]

### 五力摘要表

| 力量 | 评级 | 关键驱动因素 | 含义 |
|------|------|-------------|------|
| 新进入者 | [高/中/低] | [主要因素] | [战略影响] |
| 供应商权力 | [高/中/低] | [主要因素] | [战略影响] |
| 买方权力 | [高/中/低] | [主要因素] | [战略影响] |
| 替代品 | [高/中/低] | [主要因素] | [战略影响] |
| 对抗 | [高/中/低] | [主要因素] | [战略影响] |

**整体行业吸引力：**[有吸引力 / 中等 / 无吸引力]

---

## PESTLE分析

### 框架模板

#### 政治因素

| 因素 | 当前状态 | 趋势 | 影响 | 时间范围 |
|------|----------|------|------|----------|
| 政府稳定度 | | ↑ ↓ → | 高/中/低 | 短/中/长 |
| 贸易政策 | | ↑ ↓ → | 高/中/低 | |
| 税收法规 | | ↑ ↓ → | 高/中/低 | |
| 政府支持 | | ↑ ↓ → | 高/中/低 | |
| 政治关系 | | ↑ ↓ → | 高/中/低 | |

**关键政治含义：**[摘要]

#### 经济因素

| 因素 | 当前状态 | 趋势 | 影响 | 时间范围 |
|------|----------|------|------|----------|
| GDP增长 | X.X% | ↑ ↓ → | 高/中/低 | |
| 利率 | X.X% | ↑ ↓ → | 高/中/低 | |
| 通胀 | X.X% | ↑ ↓ → | 高/中/低 | |
| 汇率 | | ↑ ↓ → | 高/中/低 | |
| 消费支出 | | ↑ ↓ → | 高/中/低 | |
| 失业 | X.X% | ↑ ↓ → | 高/中/低 | |

**关键经济含义：**[摘要]

#### 社会因素

| 因素 | 当前状态 | 趋势 | 影响 | 时间范围 |
|------|----------|------|------|----------|
| 人口统计 | | ↑ ↓ → | 高/中/低 | |
| 文化态度 | | ↑ ↓ → | 高/中/低 | |
| 消费行为 | | ↑ ↓ → | 高/中/低 | |
| 教育水平 | | ↑ ↓ → | 高/中/低 | |
| 健康意识 | | ↑ ↓ → | 高/中/低 | |
| 工作生活平衡 | | ↑ ↓ → | 高/中/低 | |

**关键社会含义：**[摘要]

#### 技术因素

| 因素 | 当前状态 | 趋势 | 影响 | 时间范围 |
|------|----------|------|------|----------|
| 研发活动 | | ↑ ↓ → | 高/中/低 | |
| 技术采用 | | ↑ ↓ → | 高/中/低 | |
| 自动化 | | ↑ ↓ → | 高/中/低 | |
| 数字基础设施 | | ↑ ↓ → | 高/中/低 | |
| 创新率 | | ↑ ↓ → | 高/中/低 | |
| 破坏性技术 | | ↑ ↓ → | 高/中/低 | |

**关键技术含义：**[摘要]

#### 法律因素

| 因素 | 当前状态 | 趋势 | 影响 | 时间范围 |
|------|----------|------|------|----------|
| 行业法规 | | ↑ ↓ → | 高/中/低 | |
| 数据保护 | | ↑ ↓ → | 高/中/低 | |
| 劳动法 | | ↑ ↓ → | 高/中/低 | |
| 消费者保护 | | ↑ ↓ → | 高/中/低 | |
| 知识产权 | | ↑ ↓ → | 高/中/低 | |
| 反垄断 | | ↑ ↓ → | 高/中/低 | |

**关键法律含义：**[摘要]

#### 环境因素

| 因素 | 当前状态 | 趋势 | 影响 | 时间范围 |
|------|----------|------|------|----------|
| 气候变化 | | ↑ ↓ → | 高/中/低 | |
| 可持续性要求 | | ↑ ↓ → | 高/中/低 | |
| 资源可用性 | | ↑ ↓ → | 高/中/低 | |
| 废物管理 | | ↑ ↓ → | 高/中/低 | |
| 碳法规 | | ↑ ↓ → | 高/中/低 | |
| 环境意识 | | ↑ ↓ → | 高/中/低 | |

**关键环境含义：**[摘要]

---

## SWOT分析

### 框架模板

#### 优势（内部、正面）
| 优势 | 证据 | 战略价值 |
|------|------|----------|
| [优势1] | [数据/证明] | 高/中/低 |
| [优势2] | [数据/证明] | 高/中/低 |
| [优势3] | [数据/证明] | 高/中/低 |

**核心优势摘要：**[2-3句综合]

#### 劣势（内部、负面）
| 劣势 | 证据 | 严重程度 |
|------|------|----------|
| [劣势1] | [数据/证明] | 关键/中等/轻微 |
| [劣势2] | [数据/证明] | 关键/中等/轻微 |
| [劣势3] | [数据/证明] | 关键/中等/轻微 |

**关键弱点摘要：**[2-3句综合]

#### 机会（外部、正面）
| 机会 | 规模/潜力 | 时间范围 |
|------|-----------|----------|
| [机会1] | $X / 高/中/低 | 短/中/长 |
| [机会2] | $X / 高/中/低 | 短/中/长 |
| [机会3] | $X / 高/中/低 | 短/中/长 |

**优先机会摘要：**[2-3句综合]

#### 威胁（外部、负面）
| 威胁 | 可能性 | 影响 |
|------|--------|------|
| [威胁1] | 高/中/低 | 高/中/低 |
| [威胁2] | 高/中/低 | 高/中/低 |
| [威胁3] | 高/中/低 | 高/中/低 |

**关键威胁摘要：**[2-3句综合]

### SWOT策略矩阵

| | **优势** | **劣势** |
|---|---------------|----------------|
| **机会** | **SO策略**（利用优势捕捉机会） | **WO策略**（克服劣势捕捉机会） |
| **威胁** | **ST策略**（利用优势缓解威胁） | **WT策略**（最小化劣势避免威胁） |

---

## BCG增长份额矩阵

### 框架模板

**坐标轴：**
- X轴：相对市场份额（高→低，对数尺度）
- Y轴：市场增长率（高→低，通常10%为中点）

### 象限定义

| 象限 | 增长 | 份额 | 特征 | 策略 |
|------|------|-------|-----------------|----------|
| **明星** | 高 | 高 | 增长市场中的市场领导者 | 投资维持地位 |
| **现金牛** | 低 | 高 | 成熟市场中的市场领导者 | 收获现金流 |
| **问题儿童** | 高 | 低 | 增长市场中的小份额 | 选择性投资或剥离 |
| **瘦狗** | 低 | 低 | 成熟市场中的小份额 | 剥离或最小化投资 |

### 产品/业务单元分析

| 产品/BU | 市场增长 | 相对份额 | 象限 | 推荐策略 |
|---------|-----------|----------|------|----------|
| [产品A] | X.X% | X.X | 明星/现金牛/问题儿童/瘦狗 | [策略] |
| [产品B] | X.X% | X.X | 明星/现金牛/问题儿童/瘦狗 | [策略] |
| [产品C] | X.X% | X.X | 明星/现金牛/问题儿童/瘦狗 | [策略] |

### 投资组合平衡评估

| 象限 | 产品数量 | 收入% | 投资优先级 |
|------|-----------|-------|-----------|
| 明星 | X | X% | 高 |
| 现金牛 | X | X% | 维持 |
| 问题儿童 | X | X% | 选择性 |
| 瘦狗 | X | X% | 低/剥离 |

---

## 价值链分析

### 框架模板

#### 主要活动

| 活动 | 描述 | 创造价值 | 成本 | 竞争地位 |
|------|------|----------|------|-----------|
| **入站物流** | 接收、存储、库存 | | $X | 强/平均/弱 |
| **运营** | 制造、组装 | | $X | 强/平均/弱 |
| **出站物流** | 分销、交付 | | $X | 强/平均/弱 |
| **营销与销售** | 推广、销售队伍 | | $X | 强/平均/弱 |
| **服务** | 安装、支持、维修 | | $X | 强/平均/弱 |

#### 支持活动

| 活动 | 描述 | 创造价值 | 成本 | 竞争地位 |
|------|------|----------|------|-----------|
| **基础设施** | 管理、财务、法律 | | $X | 强/平均/弱 |
| **人力资源管理** | 招聘、培训、薪酬 | | $X | 强/平均/弱 |
| **技术开发** | 研发、流程改进 | | $X | 强/平均/弱 |
| **采购** | 采购、供应商管理 | | $X | 强/平均/弱 |

### 价值链边际分析

```
总收入：           $XXX
- 入站物流：       ($XX)
- 运营：           ($XX)
- 出站物流：       ($XX)
- 营销与销售：     ($XX)
- 服务：           ($XX)
- 支持活动：       ($XX)
= 边际：           $XX (X%)
```

### 竞争比较

| 活动 | 公司 | 行业平均 | 最佳水平 | 差距 |
|------|------|----------|----------|------|
| [活动] | X% | Y% | Z% | +/-X% |

---

## 竞争定位分析

### 框架模板

#### 定位维度

常见定位维度对：
- 价格vs质量
- 市场焦点（细分vs广泛）
- 解决方案类型（产品vs平台）
- 地理范围（区域vs全球）
- 客户焦点（企业vs中小型企业vs消费者）
- 创新水平（领导者vs追随者）

#### 竞争对手映射

| 竞争者 | 维度1 评分 (1-10) | 维度2 评分 (1-10) | 市场份额 | 备注 |
|--------|-------------------------|-------------------------|----------|-------|
| 公司A | X | X | X% | [定位描述] |
| 公司B | X | X | X% | [定位描述] |
| 公司C | X | X | X% | [定位描述] |

#### 战略群体识别

| 战略群体 | 公司 | 特征 | 市场份额 |
|----------|------|-----------------|----------|
| 群体1：[名称] | A、B、C | [描述] | X% |
| 群体2：[名称] | D、E | [描述] | X% |
| 群体3：[名称] | F、G、H | [描述] | X% |

---

## 风险评估框架

### 风险识别

#### 风险类别
1. **市场风险**：需求变化、价格压力、市场转移
2. **竞争风险**：新进入者、竞争对手动向、破坏
3. **监管风险**：新法规、合规要求
4. **技术风险**：过时、安全、集成
5. **运营风险**：供应链、质量、产能
6. **财务风险**：货币、利率、信贷
7. **声誉风险**：品牌损害、社交媒体、道德

### 风险评估矩阵

| 风险ID | 风险描述 | 类别 | 概率 | 影响 | 评分 | 优先级 |
|---------|----------|------|-----------|--------|-------|----------|
| R1 | [描述] | 市场 | 1-5 | 1-5 | P×I | 高/中/低 |
| R2 | [描述] | 竞争 | 1-5 | 1-5 | P×I | 高/中/低 |

**评分指南：**
- 概率：1=非常不可能，2=不可能，3=可能，4=可能，5=非常可能
- 影响：1=最小，2=次要，3=中等，4=主要，5=严重
- 优先级：评分15-25=高，8-14=中，1-7=低

### 风险缓解规划

| 风险ID | 风险 | 缓解策略 | 负责人 | 时间表 | 成本 |
|---------|------|-------------|--------|----------|------|
| R1 | [风险] | [预防+响应] | [姓名] | [日期] | $X |

---

## 财务分析模式

### 收入预测模型

```
N年收入 = 年份N-1收入 × (1 + 增长率)

或自下而上：
收入 = 客户数量 × 每客户收入 × 留存率
        + 新客户 × 每客户收入 × (1 - 流失率)
```

### 情景分析模板

| 指标 | 保守 | 基础情况 | 乐观 |
|------|--------|------------|--------|
| 市场增长 | X% | Y% | Z% |
| 市场份额 | X% | Y% | Z% |
| 定价 | $X | $Y | $Z |
| 毛利率 | X% | Y% | Z% |
| **收入Y5** | $X | $Y | $Z |
| **EBITDA Y5** | $X | $Y | $Z |

### 关键财务指标

| 指标 | 公式 | 目标 |
|------|---------|--------|
| 毛利率 | (收入 - 销售成本) / 收入 | X% |
| EBITDA利润率 | EBITDA / 收入 | X% |
| 客户获取成本 | 销售与营销 / 新客户 | $X |
| 生命周期价值 | ARPU × 毛利率 × 生命周期 | $X |
| LTV/CAC比率 | LTV / CAC | >3倍 |
| 回收期 | CAC / (ARPU × 毛利率 × 12) | <X个月 |

---

## 数据收集检查清单

### 市场规模数据
- [ ] 当前市场规模（带年份和来源）
- [ ] 历史市场规模（5-10年）
- [ ] 市场增长预测（5-10年）
- [ ] CAGR（历史和预测）
- [ ] 区域分解
- [ ] 细分分解

### 竞争数据
- [ ] 按公司的市场份额（前10名）
- [ ] 按竞争对手的收入
- [ ] 按竞争对手的增长率
- [ ] 战略动向（并购、合作、发布）
- [ ] 定价信息
- [ ] 产品/服务提供

### 客户数据
- [ ] 客户细分和规模
- [ ] 细分增长率
- [ ] 按细分的平均交易规模
- [ ] 客户获取成本
- [ ] 客户生命周期价值
- [ ] 流失率

### 行业数据
- [ ] 关键行业趋势
- [ ] 监管发展
- [ ] 技术趋势
- [ ] 经济指标
- [ ] 人口统计趋势

---

## 研究来源

### 主要研究
- 客户访谈
- 专家访谈
- 调查
- 焦点小组

### 次要研究
- 市场研究报告（高德纳、弗雷斯特、IDC、麦肯锡）
- 行业协会
- 政府统计数据
- 公司年报
- SEC文件（10-K、10-Q）
- 收益电话会议记录
- 行业出版物
- 学术期刊
- 新闻文章

### 数据验证
- 交叉参考多个来源
- 检查日期时效性（偏好<2年）
- 验证方法论
- 记录置信水平
- 记录假设