---
name: weibo
description: 获取微博热搜榜实时数据。当需要查看微博热点、热门话题、实时舆情时使用该技能。
---

# 微博热搜技能

此技能允许 Alice 获取微博平台的实时热搜榜数据，包括热搜话题、热度值等信息。

## 核心功能

- **实时热搜榜**: 获取微博平台当前最热门的话题列表
- **热度分析**: 查看每个热搜话题的热度数值
- **多领域覆盖**: 包括娱乐、时事、生活、科技等各类热点话题

## 使用方法

在终端运行以下命令：

获取微博热搜榜
python skills/weibo/weibo_hot.py

获取指定数量的热搜条目
python skills/weibo/weibo_hot.py --limit 30

## 技术细节

- **数据来源**: 使用微博内部 API 接口
- **数据格式**: JSON 格式，包含热搜词、热度值、分类等信息
- **无需认证**: 该接口为公开接口，无需登录或 API Key

## 参数说明

- `--limit`, `-l`: 获取热搜条目的数量，默认 20 条
- `--raw`: 输出原始 JSON 数据

## 注意事项

- 该接口为微博内部 API，可能随时变更，如失效需及时更新
- 热搜数据实时更新，每次调用可能获得不同的结果
- 某些热搜话题可能包含敏感词或政治内容，请谨慎处理
