---
name: eve-project-updater
description: Comprehensive EVE Online project management and ESI integration toolkit. Use when updating, auditing, or integrating ESI into EVE Online projects like EVE_Rebellion, EVE_Gatekeeper, EVE_Ships, or any EVE-related development. Triggers on project updates, ESI integration, compliance checking, asset management, or multi-project coordination.
---

# EVE Project Updater

Master toolkit for managing and updating EVE Online development projects with ESI integration.

## Quick Commands

```bash
# Audit all projects
python scripts/project_auditor.py ~/projects/EVE_* --report

# Update a specific project
python scripts/project_updater.py ~/projects/EVE_Rebellion --apply

# Bulk download assets for all projects
python scripts/asset_manager.py --sync-all

# Generate compliance report
python scripts/project_auditor.py ~/projects --compliance-report
```

## Project Detection

The updater automatically detects project type by:
1. Repository name patterns (EVE_*, eve-*)
2. File signatures (pygame → game, fastapi → api, package.json → web)
3. Existing ESI usage patterns

## Update Workflow

### 1. Audit Phase
```bash
python scripts/project_auditor.py /path/to/projects
```
Generates:
- Compliance score (0-100)
- Missing requirements checklist
- Integration opportunities
- Recommended actions

### 2. Plan Phase
Review `configs/update_plan.json` generated by auditor

### 3. Apply Phase
```bash
python scripts/project_updater.py /path/to/project --apply
```
Applies:
- ESI client template
- Attribution files
- Compliance fixes
- Asset downloads

## Project-Specific Templates

### Game Projects (EVE_Rebellion)
- `templates/esi_client_pygame.py` - Pygame-compatible ESI client
- `templates/ship_sprites.py` - Image Server sprite loader
- `templates/game_attribution.md` - README attribution block

### API Projects (EVE_Gatekeeper)
- `templates/esi_client_fastapi.py` - FastAPI ESI integration
- `templates/sso_routes.py` - SSO authentication routes
- `templates/cache_middleware.py` - Response caching

### Asset Projects (EVE_Ships)
- `templates/asset_manifest.json` - Type ID to file mapping
- `templates/fetch_config.yaml` - Bulk download configuration

## Compliance Scoring

| Score | Grade | Status |
|-------|-------|--------|
| 90-100 | A | Production ready |
| 80-89 | B | Minor issues |
| 70-79 | C | Needs attention |
| 60-69 | D | Significant gaps |
| 0-59 | F | Critical issues |

### Scoring Criteria

| Criterion | Weight | Check |
|-----------|--------|-------|
| User-Agent Header | 20 | Set with contact info |
| Cache Handling | 15 | Respects Expires header |
| Error Limit Monitoring | 15 | Checks X-ESI-Error-Limit |
| No Discovery Patterns | 20 | No ID iteration loops |
| Rate Limiting | 10 | Implements throttling |
| Attribution | 10 | CCP credit in README |
| Versioned Endpoints | 10 | Uses /latest/ or /v{n}/ |

## File References

- `scripts/project_auditor.py` - Multi-project scanner and rater
- `scripts/project_updater.py` - Apply updates to projects
- `scripts/asset_manager.py` - Centralized asset management
- `templates/` - Project-specific integration templates
- `configs/` - Generated configuration files
