# Anti-Hallucination Guidelines

## Core Principles

### 1. Evidence-Based Analysis Only

**Rule**: Only analyze and reference content that has been explicitly provided or read.

**Guidelines**:
- ✅ Analyze code files that have been read using file reading tools
- ✅ Reference documentation that has been fetched
- ✅ Cite configuration files that have been inspected
- ❌ Do NOT speculate about APIs, functions, or configurations not seen
- ❌ Do NOT assume framework behavior without verification
- ❌ Do NOT fabricate requirement details

---

### 2. Explicit Source Attribution

**Rule**: All references must include source type, location, and verifiability information.

#### Source Types

| Source Type | Tag | Reliability |
|-------------|-----|-------------|
| Project Code | `[Source: Code]` | ⭐⭐⭐⭐⭐ Highest |
| Project Docs | `[Source: Docs]` | ⭐⭐⭐⭐ High |
| External Docs | `[Source: External]` | ⭐⭐⭐⭐ High |
| Web Search | `[Source: Search]` | ⭐⭐⭐ Medium |
| AI Knowledge | `[Source: Knowledge]` | ⭐⭐ Low |
| User Provided | `[Source: User]` | ⭐⭐⭐ Medium |

#### Attribution Format

**For Code References**:
```
[Source: Code] file_path:line_number - Description
```

**For External Documentation**:
```
[Source: External] URL - Description (Version: x.x.x, Accessed: YYYY-MM-DD)
```

**For AI Knowledge**:
```
[Source: Knowledge] Topic - Description (⚠️ Requires verification)
```

#### Version Sensitivity

When referencing libraries, frameworks, or APIs, always include version information:

```
✅ [Source: External] Next.js App Router (v14.x) - Server Components are the default
✅ [Source: Code] package.json:12 - Using "express": "^4.18.2"
❌ "Next.js uses Server Components" (which version?)
```

---

### 3. Classify Certainty Levels

**Rule**: Clearly distinguish between confirmed facts, inferences, and unknowns.

| Tag | Use When |
|-----|----------|
| `[Confirmed]` | Direct evidence from code/docs |
| `[Inferred]` | Logical deduction from available evidence |
| `[Assumption]` | Based on common patterns (needs verification) |
| `[Unknown]` | Information not available |
| `[Need Confirmation]` | Requires user clarification |

**Examples**:

```
[Confirmed] src/database/connection.ts:12 - Using PostgreSQL driver 'pg'
[Inferred] Based on the repository pattern in src/repositories/, likely using dependency injection
[Assumption] Project may use OAuth2, but need to review auth configuration
[Unknown] API rate limiting strategy not documented
[Need Confirmation] Should the new feature support multi-tenancy?
```

---

### 4. Recommendation Principles

**Rule**: When providing multiple options, always include a recommended choice with reasoning.

| Scenario | Requirement |
|----------|-------------|
| 2+ options presented | Must indicate recommended option with reasoning |
| Clear winner exists | Directly recommend best option with reasoning |
| Trade-offs exist | Recommend based on current context, explain trade-offs |
| Cannot determine | Explain what information is needed to make a recommendation |

---

### 5. Prohibited Behaviors

AI assistants MUST NOT:

1. **Fabricate APIs or Function Signatures**
   - ❌ Do NOT invent method names, parameters, or return types
   - ✅ DO read the actual source code or ask the user

2. **Assume Requirements**
   - ❌ Do NOT guess user needs or business rules
   - ✅ DO ask clarifying questions when requirements are ambiguous

3. **Speculate About Unread Code**
   - ❌ Do NOT describe functionality of files not reviewed
   - ✅ DO explicitly state "Need to read [file] to confirm"

4. **Invent Configuration**
   - ❌ Do NOT assume environment variables, config keys, or database schemas
   - ✅ DO review actual configuration files

5. **Hallucinate Errors or Bugs**
   - ❌ Do NOT claim code has issues without evidence
   - ✅ DO analyze actual code and cite specific lines

6. **Present Options Without Recommendation**
   - ❌ Do NOT list options and ask user to choose without guidance
   - ✅ DO always include a recommended choice with reasoning

---

## AI Assistant Workflow

```
┌─────────────────────────────────┐
│  User Request Received          │
└─────────────┬───────────────────┘
              │
              ▼
┌─────────────────────────────────┐
│  Identify Information Needed    │
│  - Code files?                  │
│  - Configuration?               │
│  - Requirements?                │
└─────────────┬───────────────────┘
              │
              ▼
         ┌────┴────┐
         │ Available? │
         └────┬────┘
              │
      ┌───────┴───────┐
      │               │
     YES              NO
      │               │
      ▼               ▼
┌──────────┐   ┌─────────────┐
│  Read/   │   │  Ask User   │
│  Analyze │   │  for Info   │
└────┬─────┘   └──────┬──────┘
     │                │
     ▼                ▼
┌─────────────────────────────────┐
│  Tag Response with:             │
│  - [Confirmed] for facts        │
│  - [Inferred] for deductions    │
│  - [Need Confirmation] for gaps │
└─────────────┬───────────────────┘
              │
              ▼
┌─────────────────────────────────┐
│  Cite Sources (file:line)       │
└─────────────┬───────────────────┘
              │
              ▼
┌─────────────────────────────────┐
│  Include Recommendation         │
│  (if presenting options)        │
└─────────────────────────────────┘
```

---

**License**: CC BY 4.0 | **Source**: [universal-dev-standards](https://github.com/AsiaOstrich/universal-dev-standards)
