# Standard Ignore Patterns by Project Type

When scanning codebases, use this table to determine which directories to EXCLUDE based on the project type mentioned by the user.

| Project Type | Folders to Ignore (Comma Separated)             | File Extensions to Count |
|--------------|-------------------------------------------------|--------------------------|
| Python       | venv, .venv, __pycache__, dist, .skills         | .py, .ipynb              |
| Node/JS      | node_modules, dist, build, coverage, .skills    | .js, .ts, .jsx, .tsx     |
| Java/Maven   | target, .idea, .gradle, .skills                 | .java, .xml              |
| Go           | vendor, bin, .skills                            | .go                      |
| General      | .git, .vscode, .idea, .skills                   | (All text files)         |

*Usage Hint: Pass these ignore patterns as a comma-separated string to the script.*