# Review / Retake Loop

Breezing における三者分離リテイクフローと Reviewer↔Implementer 直接対話パターン。

## 概要

```
ultrawork: Lead が自己レビュー → 自己修正 (一人三役)
breezing: Reviewer が独立レビュー → Lead が分解 → Implementer が修正 (三者分離)
```

三者分離により:
- レビューの客観性が向上 (自分のコードを自分でレビューしない)
- Lead は調整に専念できる
- 修正と再レビューが並行可能

## 通信パターン (v2)

### パターン A: 軽微な質問・確認（直接対話）

```text
Reviewer → SendMessage → Implementer:
  「この関数、なぜ async にしていない？」

Implementer → SendMessage → Reviewer:
  「DB アクセスがないので同期で十分です」

Reviewer: 了解、問題なし → レビュー継続
```

**使用条件**: 実装意図の確認、命名の理由、設計判断の質問など
**Lead の関与**: 不要（監視のみ）

### パターン B: 修正指示（Lead 経由）

```text
Reviewer → SendMessage → Lead:
  findings 報告 (構造化フォーマット)

Lead:
  1. findings を修正タスクに分解
  2. TaskCreate で修正タスク登録
  3. Implementer に SendMessage で修正指示

Implementer:
  修正タスクを claim → 実装 → 完了報告
```

**使用条件**: コードの変更が必要な場合
**Lead の関与**: 必須（タスク分解と管理）

### パターン C: エスカレーション（Lead 経由）

```text
Implementer → SendMessage → Lead:
  「タスク X が 3回失敗。原因: 型エラー解消不能」

Lead の判断:
  1. 別 Implementer に再割当て
  2. タスク分割して再登録
  3. ユーザーにエスカレーション (重大問題時)
```

**使用条件**: 自力解決不能な問題
**Lead の関与**: 必須（判断と対応）

### パターン D: Peer Knowledge Sharing（Implementer 間直接対話）

```text
Implementer #1 → SendMessage → Implementer #2:
  「src/utils/auth.ts に extractAuthToken() を作成しました。
   セッション管理タスクで使えるかもしれません。」

Implementer #2 → SendMessage → Implementer #1:
  「了解、使わせてもらいます。」
```

**使用条件**: 他の Implementer のタスクに関連する発見があった場合
- 共通ユーティリティ/ヘルパーの作成通知
- 他タスクに影響する制約やゴチャの共有
- API 仕様の変更通知（他タスクが消費する API を変更した場合）

**Lead の関与**: 不要（監視のみ）
**制約**: コード変更の依頼はパターン D では行わない（変更が必要な場合は Lead 経由）

### パターン使い分け基準

| 状況 | パターン | 理由 |
|------|---------|------|
| 「なぜこう書いた？」という質問 | A (直接) | 確認のみ、コード変更不要 |
| 「ここのロジックは正しい？」 | A (直接) | 確認のみ |
| 「入力バリデーションが不足」 | B (Lead経由) | コード変更が必要 |
| 「N+1クエリを修正して」 | B (Lead経由) | コード変更が必要 |
| 「セキュリティ Critical 検出」 | B (Lead経由) | 重大問題、Lead 判断必要 |
| 「ビルドが通らない」 | C (エスカレーション) | 自力解決不能 |
| 「共通ユーティリティ作ったよ」 | D (Impl間直接) | 情報共有のみ、変更不要 |
| 「この API の仕様変えたよ」 | D (Impl間直接) | 影響通知、変更は各自判断 |

## レビューフロー図

```text
Lead がレビュー指示 (任意のタイミング)
    ↓
┌──────────────────────────────────────────────────────┐
│ Step 1: Reviewer がレビュー実行                       │
│  a. git diff --merge-base で全変更を確認              │
│  b. harness-review 4観点:                             │
│     ├── セキュリティ                                  │
│     ├── パフォーマンス                                │
│     ├── 品質                                          │
│     └── 互換性                                        │
│  c. (--codex-review) Codex MCP 4エキスパート          │
│  d. 不明点は Implementer に直接質問 (パターン A)      │
│  e. findings 集約 → 判定                              │
└──────────────────────────────────────────────────────┘
    ↓
┌──────────────────────────────────────────────────────┐
│ Step 2: Reviewer → Lead に SendMessage (判定報告)     │
│                                                       │
│  ├── APPROVE (Grade A-B)                              │
│  │   → 完了処理へ                                    │
│  │                                                    │
│  ├── REQUEST CHANGES (Grade C)                        │
│  │   → Step 3 へ (リテイクループ)                     │
│  │                                                    │
│  ├── REJECT (Grade D)                                 │
│  │   → 即停止 + ユーザーに手動修正を要請              │
│  │                                                    │
│  └── STOP (検証失敗)                                  │
│      → 即停止 + ビルド/テスト失敗報告                 │
└──────────────────────────────────────────────────────┘
    ↓ REQUEST CHANGES の場合
┌──────────────────────────────────────────────────────┐
│ Step 3: Lead がリテイク処理                           │
│  a. findings を修正タスクに分解                       │
│  b. 修正タスクを TaskCreate で登録                    │
│  c. 担当 Implementer に SendMessage で修正指示        │
│  d. retake_count++ (breezing-active.json 更新)       │
│  e. retake_count > 3 → ユーザーにエスカレーション    │
└──────────────────────────────────────────────────────┘
    ↓
┌──────────────────────────────────────────────────────┐
│ Step 4: Implementer が修正実行                        │
│  - 修正タスクを self-claim → 実装 → ビルド → テスト  │
│  - 完了 → Lead に SendMessage で修正完了報告          │
└──────────────────────────────────────────────────────┘
    ↓
┌──────────────────────────────────────────────────────┐
│ Step 5: Lead → Reviewer に再レビュー指示              │
│  「修正が完了しました。再レビューをお願いします」      │
│  → Step 1 へ戻る                                      │
└──────────────────────────────────────────────────────┘
```

## review-result.json への自動記録

Reviewer が APPROVE/REQUEST_CHANGES 判定を下した際、判定結果を `.claude/state/review-result.json` に記録する。
この記録は Phase C の APPROVE ファストパス（`execution-flow.md` 参照）で参照される。

### 記録タイミング

- **APPROVE 時**: Lead への SendMessage と同時に記録する（Phase C ファストパスで使用）
- **REQUEST_CHANGES 時**: 同様に記録する（ファストパスでは `APPROVE` 以外は無視される）

### JSON フォーマット

```json
{
  "verdict": "APPROVE",
  "grade": "A",
  "commit_hash": "abc1234def567890",
  "timestamp": "2026-02-22T14:30:00Z",
  "reviewer": "reviewer",
  "session_id": "breezing-20260222-1400"
}
```

| フィールド | 型 | 説明 |
|-----------|-----|------|
| `verdict` | string | `"APPROVE"` / `"REQUEST_CHANGES"` / `"REJECT"` / `"STOP"` |
| `grade` | string | `"A"` / `"B"` / `"C"` / `"D"` / `"N/A"` |
| `commit_hash` | string | レビュー時点の `git rev-parse HEAD` の値 |
| `timestamp` | string | ISO 8601 形式の UTC タイムスタンプ |
| `reviewer` | string | Reviewer の Teammate 名 |
| `session_id` | string | `breezing-active.json` の `session_id`（セッション照合用） |

### 記録方法（Reviewer は Read-only のため Lead が書き込む）

Reviewer は `.claude/state/review-result.json` を**直接書き込めない**（Read-only 制約）。
そのため、Lead への SendMessage 報告に `review_result_json` フィールドを含め、
Lead が受信後に `review-result.json` への書き込みを実行する。

**Reviewer の SendMessage 報告フォーマット（追加フィールド）**:

```json
{
  "decision": "APPROVE",
  "grade": "A",
  "findings": [],
  "review_result_json": {
    "verdict": "APPROVE",
    "grade": "A",
    "commit_hash": "<git rev-parse HEAD の出力>",
    "timestamp": "<ISO 8601 UTC>",
    "reviewer": "reviewer",
    "session_id": "<breezing-active.json の session_id>"
  },
  "summary": "全観点で問題なし"
}
```

**Lead の書き込み手順**（delegate mode 解除前または解除後に実行）:

```bash
# .claude/state/review-result.json に書き込む
jq -n \
  --arg verdict "APPROVE" \
  --arg grade "A" \
  --arg hash "$(git rev-parse HEAD)" \
  --arg ts "$(date -u +%Y-%m-%dT%H:%M:%SZ)" \
  --arg reviewer "reviewer" \
  --arg session "$(jq -r .session_id .claude/state/breezing-active.json)" \
  '{verdict:$verdict,grade:$grade,commit_hash:$hash,timestamp:$ts,reviewer:$reviewer,session_id:$session}' \
  > .claude/state/review-result.json
```

**ファイルのライフサイクル**:
- 作成: Reviewer の APPROVE 報告を Lead が受信した直後
- 参照: Phase C の APPROVE ファストパスチェック時
- 削除: Phase C の cleanup ステップ（`rm -f .claude/state/review-result.json`）

## 判定基準

### APPROVE

```json
{
  "decision": "APPROVE",
  "grade": "A",
  "conditions": [
    "Critical/Major findings が 0 件",
    "全観点で Grade B 以上",
    "ビルド成功",
    "テスト全通過"
  ]
}
```

### REQUEST CHANGES

```json
{
  "decision": "REQUEST_CHANGES",
  "grade": "C",
  "conditions": [
    "Critical findings が 0 件",
    "Major findings が 1 件以上",
    "自動修正可能な問題が主"
  ]
}
```

### REJECT

```json
{
  "decision": "REJECT",
  "grade": "D",
  "conditions": [
    "Critical findings が 1 件以上",
    "セキュリティ脆弱性",
    "設計レベルの根本的問題"
  ]
}
```

### STOP

```json
{
  "decision": "STOP",
  "grade": "N/A",
  "conditions": [
    "ビルドが失敗",
    "テストが失敗",
    "環境エラー"
  ]
}
```

## findings → 修正タスク分解

Lead が REQUEST CHANGES を受けた際の分解ロジック:

### 分解ルール

```
1. findings をファイル別にグループ化
2. 同一ファイルの findings → 1 修正タスクにまとめる
3. auto_fixable: true の findings を優先
4. Critical → Major → Warning の優先順位で対応
```

### 修正タスク生成例

Reviewer からの findings:

```json
{
  "findings": [
    {
      "severity": "warning",
      "category": "security",
      "file": "src/auth/login.ts",
      "line": 15,
      "issue": "入力バリデーション不足",
      "suggestion": "zod スキーマでバリデーション追加",
      "auto_fixable": true
    },
    {
      "severity": "warning",
      "category": "quality",
      "file": "src/auth/login.ts",
      "line": 42,
      "issue": "エラーハンドリング不足",
      "suggestion": "try-catch で適切にハンドリング",
      "auto_fixable": true
    },
    {
      "severity": "warning",
      "category": "performance",
      "file": "src/db/users.ts",
      "line": 8,
      "issue": "N+1 クエリ",
      "suggestion": "JOIN または一括取得に変更",
      "auto_fixable": false
    }
  ]
}
```

Lead が生成する修正タスク:

```
TaskCreate:
  subject: "src/auth/login.ts のセキュリティ・品質修正"
  description: |
    以下の 2 件を修正:
    1. L15: 入力バリデーション不足 → zod スキーマ追加
    2. L42: エラーハンドリング不足 → try-catch 追加
    owns: src/auth/login.ts

TaskCreate:
  subject: "src/db/users.ts の N+1 クエリ修正"
  description: |
    L8: N+1 クエリ → JOIN または一括取得に変更
    owns: src/db/users.ts
```

## APPROVE 結果の自動記録

### review-result.json スキーマ

Reviewer が APPROVE 判定を下した際、Lead は `.claude/state/review-result.json` にその結果を記録する。
この記録は Phase C の APPROVE ファストパスチェック（execution-flow.md 参照）で参照される。

```json
{
  "verdict": "APPROVE",
  "commit_hash": "abc1234",
  "timestamp": "2026-02-23T03:00:00Z",
  "reviewer": "reviewer",
  "grade": "A",
  "session_id": "breezing-20260223-0300"
}
```

**フィールド仕様**:

| フィールド | 型 | 説明 |
|-----------|-----|------|
| `verdict` | string | `"APPROVE"` / `"REQUEST_CHANGES"` / `"REJECT"` / `"STOP"` |
| `commit_hash` | string | 判定時の HEAD コミットハッシュ（`git rev-parse HEAD` の出力） |
| `timestamp` | string | 記録時刻（ISO 8601 UTC） |
| `reviewer` | string | Reviewer の Teammate 名 |
| `grade` | string | `"A"` / `"B"` / `"C"` / `"D"` / `"N/A"` |
| `session_id` | string | breezing-active.json の session_id と一致 |

**Lead の記録タイミング**: Reviewer からの APPROVE SendMessage 受信直後に Write で記録する。

**APPROVE 以外の判定**: REQUEST_CHANGES/REJECT/STOP の場合も記録する（ファストパスは発動しないが、デバッグ情報として有用）。

**ライフサイクル**: Phase C 完了（breezing-active.json 削除）と同時に review-result.json も削除する。

## リテイク回数管理

### retake_count の管理

breezing-active.json の `review.retake_count` でリテイク回数を追跡:

```
REQUEST CHANGES 受信 → retake_count++
APPROVE 受信 → リテイクループ終了
retake_count > max_retakes → エスカレーション
```

### エスカレーション条件

| 条件 | アクション |
|------|-----------|
| retake_count > 3 | ユーザーにエスカレーション |
| REJECT | 即停止 + ユーザー報告 |
| STOP | 即停止 + 検証失敗報告 |

### エスカレーション時のメッセージ

Lead が会話コンテキスト内の Reviewer 報告履歴からメッセージを構成:

```text
⚠️ Breezing: リテイク上限 (3回) に達しました

## 未解決の問題

| # | ファイル | 問題 | 重要度 |
|---|---------|------|--------|
| 1 | src/auth/login.ts:15 | 入力バリデーション | warning |
| 2 | src/db/users.ts:8 | N+1 クエリ | warning |

## リテイク経過 (Lead の Reviewer 報告受信履歴から構成)

| 回 | 判定 | Grade | 指摘数 |
|----|------|-------|--------|
| 1 | REQUEST_CHANGES | C | 5 |
| 2 | REQUEST_CHANGES | C | 3 |
| 3 | REQUEST_CHANGES | C | 2 |

手動で修正するか、`/breezing 続きやって` で再開してください。
```

> **データ源**: リテイク履歴は breezing-active.json には保存しない。
> Lead の会話コンテキスト内に蓄積された Reviewer の SendMessage 報告から動的に構成する。
> `review.retake_count` のみ breezing-active.json で永続化。

## Codex Review 統合 (--codex-review)

### フロー

```
Reviewer の通常レビュー (harness-review 4観点)
    +
Codex MCP 並列エキスパートレビュー (4エキスパート)
    ↓
結果統合 → 総合判定
```

### 統合ルール

```
1. harness-review の findings を基盤とする
2. Codex エキスパートの findings を追加
3. 重複する findings はマージ (harness-review 側を優先)
4. 最終判定は harness-review の基準に従う
5. Codex が Critical を検出した場合は Grade を1段階下げる
```

詳細: codex-review-integration.md 参照

## REJECT / STOP テンプレート

### REJECT

```markdown
### Manual Intervention Required

**Decision**: REJECT
**Grade**: D
**Reason**: 重大な問題があり、自動修正では対応できません

**Critical Issues**:
1. [ファイル:行] 問題の説明
2. ...

Breezing を停止しました。手動で修正してください。
```

### STOP

```markdown
### Verification Failed

**Decision**: STOP
**Grade**: N/A (blocked)
**Failure Type**: [lint_failure | test_failure | build_failure | environment_error]
**Failed Command**: ...

**Required Fixes**:
1. ...

Breezing を停止しました。問題を解決して `/breezing 続きやって` で再開してください。
```
