# タスクライフサイクル例

実際のタスクが Plans.md でどのように管理されるかの例。

---

## 例1: 通常のタスクフロー

### Step 1: PM がタスクを追加

```markdown
## 🟡 未着手のタスク

- [ ] ログイン画面のバリデーション追加 `pm:依頼中`
  - メールアドレス形式チェック
  - パスワード強度チェック
```

### Step 2: Claude Code が着手

```markdown
## 🔴 進行中のタスク

- [ ] ログイン画面のバリデーション追加 `cc:WIP`
  - メールアドレス形式チェック
  - パスワード強度チェック
  - 関連ファイル: `src/components/LoginForm.tsx`
```

### Step 3: Claude Code が完了

```markdown
## 🟢 完了タスク

- [x] ログイン画面のバリデーション追加 `cc:完了` (2024-01-15)
  - メールアドレス形式チェック
  - パスワード強度チェック
  - 関連ファイル: `src/components/LoginForm.tsx`
```

### Step 4: PM が確認

```markdown
## 🟢 完了タスク

- [x] ログイン画面のバリデーション追加 `pm:確認済` (2024-01-15)
```

---

## 例2: サブタスクを含むタスク

```markdown
## 🔴 進行中のタスク

- [ ] ユーザー管理機能の実装 `cc:WIP`
  - [x] データベーススキーマ設計
  - [x] API エンドポイント作成
  - [ ] フロントエンド実装
  - [ ] テスト作成
```

---

## 例3: ブロックされたタスク

```markdown
## 🟡 未着手のタスク

- [ ] 決済機能の実装 `blocked`
  - ブロック理由: Stripe アカウントの本番環境承認待ち
  - 担当: @client
  - 予定解消日: 2024-01-20
```

---

## 例4: 優先度付きタスク

```markdown
## 🟡 未着手のタスク

- [ ] 🔥 【緊急】本番エラー修正 `pm:依頼中`
- [ ] ⭐ 【重要】パフォーマンス改善 `cc:TODO`
- [ ] ドキュメント更新 `cc:TODO`
```

---

## 例5: アーカイブ

```markdown
## 📦 アーカイブ

### 2024年1月

- [x] 初期プロジェクトセットアップ `pm:確認済` (2024-01-10)
- [x] CI/CD 構築 `pm:確認済` (2024-01-12)
- [x] 認証機能実装 `pm:確認済` (2024-01-14)

### 2023年12月

- [x] 要件定義 `pm:確認済` (2023-12-20)
```
