---
name: error-recovery
description: "エラーが発生した際に自動修正を試みる。ビルドエラー、テスト失敗、または実行時エラーが検出された場合に使用します。"
allowed-tools: [Read,Edit,Bash]
---

# Error Recovery

ビルドやテストで発生したエラーを自動診断し、修正を試みるスキル。
最大3回のリトライ後、解決しない場合はエスカレーションする。

---

## 目的

- エラーの自動診断
- 一般的なエラーパターンの自動修正
- 修正不可能な場合の適切なエスカレーション

---

## 入力

| 項目 | 説明 |
|------|------|
| `error_type` | エラーの種類（build, test, lint, runtime） |
| `error_message` | エラーメッセージ |
| `error_file` | エラーが発生したファイル |
| `error_line` | エラーが発生した行番号 |
| `retry_count` | 現在のリトライ回数 |

---

## 出力

| 項目 | 説明 |
|------|------|
| `fixed` | 修正成功フラグ |
| `fix_description` | 修正内容の説明 |
| `escalate` | エスカレーションが必要か |

---

## エラーパターンと自動修正

### TypeScript / JavaScript

| エラーパターン | 自動修正 |
|--------------|---------|
| `Cannot find module` | パッケージインストール or パス修正 |
| `Type 'X' is not assignable` | 型定義の追加・修正 |
| `Property 'X' does not exist` | オプショナルチェーン追加 |
| `Expected X arguments` | 引数の追加・削除 |

### Python

| エラーパターン | 自動修正 |
|--------------|---------|
| `ModuleNotFoundError` | pip install or import 修正 |
| `IndentationError` | インデント修正 |
| `NameError` | 変数定義の追加 |
| `TypeError` | 型変換の追加 |

### テストエラー

| エラーパターン | 自動修正 |
|--------------|---------|
| `AssertionError` | 期待値の確認・修正 |
| `Timeout` | タイムアウト値の増加 |
| `Mock not called` | モック設定の修正 |

---

## 実行フロー

```
エラー発生
    │
    ▼
┌─────────────────────────────┐
│ エラーパターンの分析        │
│ - エラーメッセージ解析      │
│ - ファイル・行番号特定      │
│ - 関連コードの読み取り      │
└─────────────┬───────────────┘
              │
              ▼
┌─────────────────────────────┐
│ 修正の試行                  │
│ - パターンマッチング        │
│ - 自動修正の適用            │
│ - ビルド・テスト再実行      │
└─────────────┬───────────────┘
              │
    ┌─────────┴─────────┐
    ▼                   ▼
 成功               失敗
    │                   │
    ▼                   ▼
 完了           リトライ < 3?
                    │
          ┌─────────┴─────────┐
          ▼                   ▼
        再試行          エスカレーション
```

---

## リトライ戦略

**リトライ上限の決定**:
- `claude-code-harness.config.yaml` の `orchestration.max_state_retries` があればそれを優先
- 未設定時はデフォルト `3`

| 回数 | 戦略 |
|------|------|
| 1回目 | 直接的なパターンマッチ修正 |
| 2回目 | 関連ファイルを含めた広範な分析 |
| 3回目 | 代替アプローチの試行 |

---

## エスカレーション

3回のリトライで解決しない場合：

```markdown
## ⚠️ エラー修正エスカレーション

**失敗回数**: 3回
**エラー種別**: {{error_type}}

### エラー内容
{{error_message}}

### 試した修正
1. {{fix_attempt_1}}
2. {{fix_attempt_2}}
3. {{fix_attempt_3}}

### 推定原因
{{estimated_cause}}

### 推奨アクション
- [ ] 手動での確認が必要
- [ ] 設計の見直しが必要
```

---

## 注意事項

- 修正は最小限の変更に留める
- 修正前後で diff を提示する
- 破壊的な変更は行わない
- 不明な場合はユーザーに確認を求める
