---
name: review-aggregate
description: "複数のレビュー結果を集約し総合評価を生成するスキル。複数のレビュー結果を統合して総合評価を作成する場合に使用します。"
allowed-tools: ["Read"]
---

# Review Aggregate

複数のレビュー結果（セキュリティ、パフォーマンス、品質、アクセシビリティ）を集約し、総合評価を生成するスキル。

---

## 目的

個別のレビュー結果を統合して：
- 総合評価の算出
- 優先度付けされた改善提案リストの生成
- 次のアクションの提示

---

## 入力

| 項目 | 説明 |
|------|------|
| `security_issues` | セキュリティレビュー結果 |
| `performance_issues` | パフォーマンスレビュー結果 |
| `quality_issues` | 品質レビュー結果 |
| `a11y_issues` | アクセシビリティレビュー結果（該当する場合） |

---

## 出力

| 項目 | 説明 |
|------|------|
| `overall_grade` | 総合評価 (A-F) |
| `improvement_suggestions` | 優先度付き改善提案リスト |

---

## 評価アルゴリズム

### スコア計算

各カテゴリのスコアを数値化：
- A = 5, B = 4, C = 3, D = 2, F = 1

### 重み付け

| カテゴリ | 重み | 理由 |
|---------|------|------|
| セキュリティ | 35% | 最重要、脆弱性は致命的 |
| パフォーマンス | 25% | ユーザー体験に直結 |
| 品質 | 25% | 保守性に影響 |
| アクセシビリティ | 15% | 重要だが全プロジェクトに該当しない |

### 総合スコア算出

```
総合スコア = (セキュリティ × 0.35) + (パフォーマンス × 0.25)
           + (品質 × 0.25) + (アクセシビリティ × 0.15)
```

### グレード判定

| スコア範囲 | グレード |
|-----------|---------|
| 4.5 - 5.0 | A |
| 3.5 - 4.4 | B |
| 2.5 - 3.4 | C |
| 1.5 - 2.4 | D |
| 1.0 - 1.4 | F |

---

## 優先度付け

### 優先度決定基準

| 優先度 | 基準 |
|--------|------|
| クリティカル | セキュリティの重大な問題 |
| 高 | セキュリティ中程度 / パフォーマンス重大 |
| 中 | パフォーマンス中程度 / 品質重大 |
| 低 | 品質軽微 / アクセシビリティ |

---

## 出力例

```markdown
## 📊 コードレビュー総合結果

### 総合評価: B

| 観点 | 評価 | 問題数 |
|------|------|--------|
| セキュリティ | B | 2 件 |
| パフォーマンス | C | 3 件 |
| コード品質 | A | 1 件 |
| アクセシビリティ | B | 2 件 |

---

### 改善提案（優先度順）

#### クリティカル (0件)
なし

#### 高優先度 (2件)
1. **N+1 クエリ問題** - `src/api/posts.ts:23`
   - パフォーマンスに重大な影響

2. **SQL インジェクションの可能性** - `src/api/users.ts:45`
   - セキュリティリスク

#### 中優先度 (3件)
3. **長すぎる関数** - `src/services/user.ts:45`
4. **非仮想化リスト** - `src/components/List.tsx:45`
5. **alt 属性欠落** - `src/components/Image.tsx:8`

#### 低優先度 (1件)
6. **未使用の import** - `src/utils/helpers.ts:12`

---

### 推奨アクション

1. **すぐに対応**: 高優先度の 2 件を修正
2. **今週中に対応**: 中優先度の 3 件を修正
3. **余裕があれば**: 低優先度の 1 件を修正

自動修正を適用しますか？
```

---

## 注意事項

- クリティカル問題がある場合はマージ推奨しない
- 修正の自動適用は確認を求める
- 改善による効果を具体的に説明する
