# Scope Dialog

`/work` 引数なし時の対話式スコープ確認仕様。

## Dialog Flow

```text
/work
    ↓
引数あり? → YES → 即実行（対話スキップ）
    ↓ NO
AskUserQuestion で対話:

どこまでやりますか?
1) 次のタスク (推奨): Plans.md の次の未完了タスク
2) 全部: 残りのタスクを全て完了
3) 指定: タスク番号や範囲を指定 (例: 3, 3-6)

> [Enter = 1]
```

## 引数パターンと即実行

| 引数 | 解釈 | 対話 |
|------|------|------|
| (なし) | 対話で確認 | あり |
| `3` | タスク3だけ | スキップ |
| `3-6` | タスク3〜6 | スキップ |
| `all` | 全未完了タスク | スキップ |
| `--codex` | Codex エンジン（スコープは対話） | あり |
| `--codex all` | Codex で全タスク | スキップ |
| `--codex 3` | Codex でタスク3 | スキップ |

## 自然言語対応

```bash
/work 認証機能からユーザー管理まで
/work ログイン機能を終わらせて
/work Header, Footer, Sidebar を作って
```

自然言語は Plans.md のタスクタイトルとマッチング:
1. 各タスクのタイトルをトークン化
2. ユーザー入力のキーワードとの一致度を計算
3. マッチしたタスクを表示して確認

## AskUserQuestion の実装

```json
{
  "questions": [{
    "question": "どこまでやりますか?",
    "header": "Scope",
    "options": [
      {
        "label": "次のタスク (推奨)",
        "description": "Plans.md の次の未完了タスク 1 件を実行"
      },
      {
        "label": "全部",
        "description": "残りの未完了タスクを全て完了まで実行"
      },
      {
        "label": "指定",
        "description": "タスク番号や範囲を指定 (例: 3, 3-6)"
      }
    ],
    "multiSelect": false
  }]
}
```

「指定」が選ばれた場合、追加で番号/範囲を聞く:

```json
{
  "questions": [{
    "question": "タスク番号または範囲を指定してください (例: 3, 3-6)",
    "header": "Range",
    "options": [
      {"label": "次の3件", "description": "未完了の先頭3タスク"},
      {"label": "残り全部", "description": "全未完了タスク"}
    ],
    "multiSelect": false
  }]
}
```

## スコープ確認プロンプト（実行前に必ず表示）

```text
📋 実行範囲を確認します

対象タスク:
├── 3. ログイン機能の実装 (cc:TODO)
├── 4. 認証ミドルウェアの作成 (cc:TODO)
└── 5. セッション管理 (cc:TODO)

🔧 戦略: 並列 3 ワーカー (タスク3件)

計 3 タスクを実行します。よろしいですか？
```

## /breezing との対話の違い

| 項目 | /work | /breezing |
|------|-------|-----------|
| デフォルト選択 | 次のタスク (1件) | 全部 |
| 理由 | 軽量実行が基本 | チーム並列が前提 |
| 「次のタスク」選択肢 | あり | なし |
