---
name: context-resume
description: 恢复之前保存的会话上下文。列出所有待处理的 session，读取选定 session 的任务信息，更新进度，任务全部完成后删除文件。
---

# 上下文恢复指南

## 使用场景

在新的 Claude Code 窗口中，需要继续之前未完成的任务时调用此 Skill。

---

## 执行步骤

### Step 1: 列出所有 Session

读取 `docs/context-sessions/` 目录下的所有 `.md` 文件（排除 .gitkeep）。

**输出格式**:

```
📋 待处理的 Session 列表:

1. 20251128-1430-实现用户登录功能.md
   未完成任务: 3 项

2. 20251128-1600-修复导出bug.md
   未完成任务: 1 项

请告诉我要恢复哪个 session（输入序号或文件名）
```

如果目录为空，输出：

```
📭 当前没有待处理的 session。

所有任务已完成，或尚未使用 context-save 保存过上下文。
```

### Step 2: 读取并展示 Session 内容

用户选择后，读取对应的 session 文件，完整展示内容。

**输出格式**:

```
📂 已加载 Session: {文件名}

---
{session 文件完整内容}
---

🎯 接下来要处理哪个任务？或者需要我继续之前的工作？
```

### Step 3: 开始工作

根据 session 中的信息：
1. 读取关键文件，恢复上下文理解
2. 按优先级处理未完成任务
3. 遵循"下一步行动"的建议

### Step 4: 更新任务进度

每完成一个任务后，**立即更新** session 文件：

1. 将已完成的任务从"未完成"移到"已完成"
2. 更新元信息中的"最后更新"时间
3. 添加新发现的任务（如果有）

**示例更新**:

```markdown
## 已完成任务
- [x] 任务1描述
- [x] 任务2描述
- [x] 🔴 高优先级: 实现 publishArticle 方法  ← 新完成

## 未完成任务
- [ ] 🔴 高优先级: 处理图片上传到微信服务器
- [ ] 🟡 中优先级: 添加发布结果回调
```

### Step 5: 任务完成处理

当所有未完成任务都被完成后：

1. **立即删除** session 文件
2. 输出完成信息

**输出格式**:

```
🎉 Session 所有任务已完成！

已完成任务汇总:
- [x] 任务1
- [x] 任务2
- [x] 任务3

Session 文件已删除: docs/context-sessions/{文件名}
```

---

## 工作流程图

```
┌─────────────────┐
│  调用 skill     │
└────────┬────────┘
         │
         ▼
┌─────────────────┐
│  列出所有       │
│  session 文件   │
└────────┬────────┘
         │
         ▼
┌─────────────────┐
│  用户选择       │
│  要恢复的       │
│  session        │
└────────┬────────┘
         │
         ▼
┌─────────────────┐
│  读取并展示     │
│  session 内容   │
└────────┬────────┘
         │
         ▼
┌─────────────────┐
│  开始处理任务   │◄──────────┐
└────────┬────────┘           │
         │                    │
         ▼                    │
┌─────────────────┐           │
│  完成一个任务   │           │
│  更新 session   │           │
└────────┬────────┘           │
         │                    │
         ▼                    │
    ┌────────────┐            │
    │ 还有未完成 │───Yes──────┘
    │   任务？   │
    └─────┬──────┘
          │ No
          ▼
┌─────────────────┐
│  删除 session   │
│  文件           │
└─────────────────┘
```

---

## 命令快捷方式

在恢复 session 后，可以使用以下指令：

| 指令 | 作用 |
|------|------|
| `继续` | 按优先级继续处理下一个任务 |
| `更新进度` | 手动触发 session 文件更新 |
| `查看剩余` | 显示剩余未完成任务 |
| `换窗口处理-` | 再次保存并切换窗口 |

---

## 注意事项

1. **及时更新** - 每完成一个任务立即更新 session 文件
2. **保持文件同步** - 如果发现新任务，添加到未完成列表
3. **删除确认** - 只有当所有任务完成才删除文件
4. **关键文件** - 恢复时优先读取 session 中列出的关键文件
