---
name: context-save
description: 当用户发送"换窗口处理-"时调用。总结当前窗口的上下文信息、已完成任务、未完成任务，保存到 docs/context-sessions/ 目录，便于新窗口恢复。
---

# 上下文保存指南

## 触发条件

当用户发送 `换窗口处理-` 时，调用此 Skill。

---

## 执行步骤

### Step 1: 分析当前上下文

回顾当前会话，提取以下信息：

1. **核心任务** - 用户最初的请求是什么
2. **已完成任务** - 本次会话中完成了哪些工作
3. **未完成任务** - 还有哪些工作待完成
4. **关键文件** - 正在操作或需要关注的文件
5. **技术要点** - 重要的技术决策、踩过的坑
6. **下一步行动** - 建议新窗口首先做什么

### Step 2: 生成 Session 文件

**文件命名规则**: `{YYYYMMDD}-{HHMM}-{简短描述}.md`

示例: `20251128-1430-实现用户登录功能.md`

**文件位置**: `docs/context-sessions/`

### Step 3: 写入标准格式

```markdown
# Session: {简短描述}

## 元信息
- **创建时间**: {当前时间}
- **状态**: 进行中

## 上下文摘要
{简洁描述当前正在做什么、背景信息、关键决策}

## 已完成任务
- [x] 任务1描述
- [x] 任务2描述

## 未完成任务
- [ ] 🔴 高优先级: {任务描述}
- [ ] 🟡 中优先级: {任务描述}
- [ ] 🟢 低优先级: {任务描述}

## 关键文件
- `{文件路径}` - {说明}
- `{文件路径}` - {说明}

## 注意事项
{需要注意的技术细节、已知问题、踩过的坑}

## 下一步行动
{建议新窗口首先执行的操作}
```

### Step 4: 告知用户

保存完成后，输出：

```
✅ 上下文已保存到: docs/context-sessions/{文件名}

新窗口恢复方法:
1. 调用 skill: context-resume
2. 选择对应的 session 文件

未完成任务数: {数量}
```

---

## 优先级标记说明

| 标记 | 含义 | 使用场景 |
|------|------|---------|
| 🔴 | 高优先级 | 阻塞性任务、核心功能 |
| 🟡 | 中优先级 | 重要但不紧急 |
| 🟢 | 低优先级 | 优化、可选功能 |

---

## 示例输出

```markdown
# Session: 实现微信公众号发布功能

## 元信息
- **创建时间**: 2025-11-28 14:30
- **状态**: 进行中

## 上下文摘要
用户需要实现微信公众号的自动发布功能。已完成登录态获取和 Cookie 管理，正在实现文章发布 API 对接。

## 已完成任务
- [x] 创建 WechatPublisher 基础类结构
- [x] 实现 Cookie 存储和读取
- [x] 完成登录检测逻辑

## 未完成任务
- [ ] 🔴 高优先级: 实现 publishArticle 方法
- [ ] 🔴 高优先级: 处理图片上传到微信服务器
- [ ] 🟡 中优先级: 添加发布结果回调
- [ ] 🟢 低优先级: 添加草稿箱功能

## 关键文件
- `electron/services/publish/publishers/wechat.publisher.ts` - 主要开发文件
- `electron/services/core/cookie.service.ts` - Cookie 管理
- `shared/types/publish.types.ts` - 类型定义

## 注意事项
- 微信 API 有频率限制，需要添加请求间隔
- 图片需要先上传到微信素材库获取 media_id
- 登录态 24 小时过期，需要定期刷新

## 下一步行动
1. 先读取 wechat.publisher.ts 了解当前进度
2. 继续实现 publishArticle 方法
3. 参考 xiaohongshu.publisher.ts 的图片上传实现
```

---

## 注意事项

1. **精炼总结** - 只保留关键信息，避免冗余
2. **可执行性** - 未完成任务要具体、可操作
3. **文件路径准确** - 确保关键文件路径正确
4. **优先级合理** - 帮助新窗口快速确定工作重点
