---
name: tech-doc
description: 技术协作场景下撰写与维护高质量技术文档的统一写作指南。
---

# 技术文档协作 Skill

## 写作基线
 - 输出先给结论再解释理由，层级不超过三层，遵循金字塔结构：顶层一句话结论，下一层分解 2–5 个要点，再补充支撑证据。
- 以事实准确为先：不脑补、不擅自扩展原始信息，术语统一且可追溯；必要时保留引用与原始数据。
- 语句保持短句与主动语态，数值带单位，避免模板化口吻； Markdown 标题≤4级，内联代码以反引号标注命令/路径。
- 限定范围与读者：首段交代目标、读者画像、默认前置知识与不在范围内的内容。

## 介绍/解释型文档
1. 用单段开篇说明 What/Why/Outcome，并点出背景、现状与读者对象。
2. 列出 2–5 条先结论后佐证的支撑要点，可用要点或短小节。
3. 展开时覆盖流程、边界、典型反例；引入新概念应先给直观例子与整体图景，再补充正式定义、场景与不适用情形。

## 速查/SOP 文档
- 开头一句话描述任务与预期，随后用 1–3 行列表说明适用范围、前置条件、风险或权限，再立刻给最短可用示例。
- 采用“索引 → 分类 → 卡片”结构，每张卡按照“名称/意图 → 最短示例 → 常用参数 → 常见错误 → 相关资料”。
- 不得凭空新增步骤或假设；如需补充，标注“待确认/建议补充”并说明依据。
- 代码块标注 `bash`/`sh`，无提示符，命令可直接复制执行；提供占位符说明，必要时给 `--dry-run` 或只读版本优先。

## 信息边界与引用
- 不添加原文未给出的结论或数据；修改错别字或数值前需确认并记录原因。
- 关键定义、API、协议引用权威来源，说明链接、版本与访问日期；多来源冲突时列出差异和采信理由。
- 保持命令、代码、图表语义不变，只做格式与注释优化；示例输出需标注“示例”。

## 排版与 Markdown 细则
- 标题与列表层级控制在 2 层，长段落拆分为列表或表格；对比与权衡用表格或并列小节展示。
- 内联代码只包裹标识符或命令，标点写在反引号之外；配置示例按原生语法呈现。
- 代码块按步骤一块，说明执行权限，长命令必要时用反斜杠续行并避免尾随空格。
- 链接锚点可读且稳定，外链注明版本或提交号与访问日期；图片需有替代文本。

## 协作提示
- 如遇信息不足或上下文不清，应先与相关开发者/作者确认，再扩展或发布文档。
- 发现潜在冲突或风险点，先在文档中提醒并同步讨论记录，确保后续维护人员可追踪。
