# CLAUDE.md - {{PROJECT_NAME}}

## PROJECT IDENTITY

**Project Name**: {{PROJECT_TITLE}}
**Project Type**: {{PROJECT_TYPE}} (Complex - Multi-Project Coordination)
**Status**: Incubating
**Created**: {{CREATED_DATE}}
**Owner**: Daron Vener

---

## PROJECT MISSION

{{PROJECT_PURPOSE}}

**Core Focus**:
{{CORE_FOCUS_ITEMS}}

---

## SCOPE & BOUNDARIES

### IN SCOPE
{{IN_SCOPE_ITEMS}}

### OUT OF SCOPE
{{OUT_OF_SCOPE_ITEMS}}

---

## PARENT SYSTEM INTEGRATION

**This is a sub-project of CCGG Business Operations**

### Project Memory Index Sync

**Your Project Index**: `../../../Project Memory/Active Projects Index/{{PROJECT_NAME}}-index.md`

**When to Update** (PROACTIVELY):
- After completing major deliverable
- When project status changes (incubating → ready, paused, etc.)
- After significant progress (weekly recommended during active work)

**How to Update**:
1. Read `../../../Project Memory/Active Projects Index/{{PROJECT_NAME}}-index.md`
2. Update: Current Status, Key Deliverables (mark completed items), Last Activity, date_modified, last_sync
3. Offer to log in operations_log.txt

**Example Updates**:
- "Completed deliverable: [specific output]"
- "Phase [X] complete: [summary]"
- "Status changed: incubating → ready for implementation"

---

### Operations Logging

**Location**: `../../../operations_log.txt`

**Auto-log** (AUTOMATICALLY, without asking): Major deliverables, milestones, decisions, phase completions, index updates

**Format**: `[YYYY-MM-DD HH:MM:SS] - [ACTION] - {{PROJECT_NAME}} - [details]`

**Actions to Auto-Log**:
- **CREATE**: New deliverables, documents, implementations
- **UPDATE**: Revisions to key outputs
- **COMPLETE**: Phase completions, deliverable handoffs
- **SYSTEM_UPGRADE**: Infrastructure improvements
- **SYNC**: Project index updates

**Examples**:
```
[YYYY-MM-DD HH:MM:SS] - COMPLETE - {{PROJECT_NAME}} - [Deliverable name] complete. [Key details].
[YYYY-MM-DD HH:MM:SS] - CREATE - {{PROJECT_NAME}} - [New output] created. [Purpose and context].
[YYYY-MM-DD HH:MM:SS] - SYNC - {{PROJECT_NAME}} - Project index updated. Status: [current status].
```

---

### Strategic Alignment Validation

Reference `../../../AI Growth Engine/Knowledge Base/Strategy_for_CCGG_AI_Leaders_Business.md`

**OOBG Check**: Does this help coaches/consultants monetize with AI?
{{OOBG_ALIGNMENT}}

**Unique Vehicle Check**: Does this leverage YouTube + CCGG paid community?
{{UV_ALIGNMENT}}

**Avatar Targeting**: Which specific customer avatars benefit?
{{AVATAR_TARGETING}}

---

### Cross-Project Intelligence

Search `../../../Project Memory/Active Projects Index/` for related projects when asked.

**Related Projects**:
{{RELATED_PROJECTS}}

---

## AUTONOMOUS KNOWLEDGE ACCESS

**This is a complex project that coordinates with other active projects.**

### Cross-Project References

**Upstream Dependencies** (Projects this project needs):
{{UPSTREAM_DEPENDENCIES}}

**Downstream Dependencies** (Projects that need this project's outputs):
{{DOWNSTREAM_DEPENDENCIES}}

### Access Commands

**To find related project outputs**:
- "Search Active Projects Index for [keyword]"
- "Read [project-name]/Coordination Hub/OUTPUT_LIBRARY.md"
- "What outputs does [project-name] provide?"

**To check integration status**:
- "Read Coordination Hub/INTEGRATION_CHECKLIST.md"
- "Are all upstream dependencies met?"
- "Which downstream projects are blocked by this?"

---

## COORDINATION WITH OTHER PROJECTS

### Dependency Chain

{{DEPENDENCY_CHAIN_DESCRIPTION}}

### Integration Points

{{INTEGRATION_POINTS}}

### Coordination Hub

**Location**: `Coordination Hub/`

**Files**:
- `PROJECT_DEPENDENCIES.md` - Upstream and downstream dependency tracking
- `INTEGRATION_CHECKLIST.md` - Pre-requisites, execution, and post-implementation checklists
- `OUTPUT_LIBRARY.md` - Catalog of deliverables for other projects to reference

**When to Update**:
- **PROJECT_DEPENDENCIES.md**: When blockers change, dependencies met/unmet
- **INTEGRATION_CHECKLIST.md**: After each phase, when handoffs complete
- **OUTPUT_LIBRARY.md**: Whenever new deliverable created or status changes

---

## PROJECT STRUCTURE

```
{{PROJECT_NAME}}/
├── CLAUDE.md                    # This file - project guidance
├── README.md                    # Project overview
├── Coordination Hub/            # Cross-project coordination
│   ├── PROJECT_DEPENDENCIES.md
│   ├── INTEGRATION_CHECKLIST.md
│   └── OUTPUT_LIBRARY.md
{{FOLDER_STRUCTURE}}
```

---

## EXPECTED DELIVERABLES

{{DELIVERABLES_LIST}}

---

## MULTI-PHASE PROJECT TRACKER

{{PHASE_TRACKER_SECTION}}

---

## SUCCESS CRITERIA

### Project Success
{{PROJECT_SUCCESS_CRITERIA}}

### Integration Success
{{INTEGRATION_SUCCESS_CRITERIA}}

### Business Impact (Post-Implementation)
{{BUSINESS_IMPACT_CRITERIA}}

---

## IMPORTANT REMINDERS

1. **Update Project Memory Index** after major deliverables
2. **Log significant progress** to operations_log.txt
3. **Validate strategic alignment** periodically (OOBG, UV, Avatars)
4. **Check upstream dependencies** before starting phases (read Coordination Hub)
5. **Update OUTPUT_LIBRARY.md** when deliverables complete (downstream projects need visibility)
6. **Coordinate handoffs** to downstream projects (notify via operations_log.txt)

---

**Your mission**: {{MISSION_STATEMENT}}
