# CLAUDE.md - {{PROJECT_NAME}}

## PROJECT IDENTITY

**Project Name**: {{PROJECT_TITLE}}
**Project Type**: {{PROJECT_TYPE}}
**Status**: Incubating
**Created**: {{CREATED_DATE}}
**Owner**: Daron Vener

---

## PROJECT MISSION

{{PROJECT_PURPOSE}}

**Core Focus**:
{{CORE_FOCUS_ITEMS}}

---

## SCOPE & BOUNDARIES

### IN SCOPE
{{IN_SCOPE_ITEMS}}

### OUT OF SCOPE
{{OUT_OF_SCOPE_ITEMS}}

---

## PARENT SYSTEM INTEGRATION

**This is a sub-project of CCGG Business Operations**

### Project Memory Index Sync

**Your Project Index**: `../../../Project Memory/Active Projects Index/{{PROJECT_NAME}}-index.md`

**When to Update** (PROACTIVELY):
- After completing major deliverable
- When project status changes (incubating → ready, paused, etc.)
- After significant progress (weekly recommended during active work)

**How to Update**:
1. Read `../../../Project Memory/Active Projects Index/{{PROJECT_NAME}}-index.md`
2. Update: Current Status, Key Deliverables (mark completed items), Last Activity, date_modified, last_sync
3. Offer to log in operations_log.txt

**Example Updates**:
- "Completed deliverable: [specific output]"
- "Phase [X] complete: [summary]"
- "Status changed: incubating → ready for implementation"

---

### Operations Logging

**Location**: `../../../operations_log.txt`

**Auto-log** (AUTOMATICALLY, without asking): Major deliverables, milestones, decisions, phase completions, index updates

**Format**: `[YYYY-MM-DD HH:MM:SS] - [ACTION] - {{PROJECT_NAME}} - [details]`

**Actions to Auto-Log**:
- **CREATE**: New deliverables, documents, implementations
- **UPDATE**: Revisions to key outputs
- **COMPLETE**: Phase completions, deliverable handoffs
- **SYSTEM_UPGRADE**: Infrastructure improvements
- **SYNC**: Project index updates

**Examples**:
```
[YYYY-MM-DD HH:MM:SS] - COMPLETE - {{PROJECT_NAME}} - [Deliverable name] complete. [Key details].
[YYYY-MM-DD HH:MM:SS] - CREATE - {{PROJECT_NAME}} - [New output] created. [Purpose and context].
[YYYY-MM-DD HH:MM:SS] - SYNC - {{PROJECT_NAME}} - Project index updated. Status: [current status].
```

---

### Strategic Alignment Validation

Reference `../../../AI Growth Engine/Knowledge Base/Strategy_for_CCGG_AI_Leaders_Business.md`

**OOBG Check**: Does this help coaches/consultants monetize with AI?
{{OOBG_ALIGNMENT}}

**Unique Vehicle Check**: Does this leverage YouTube + CCGG paid community?
{{UV_ALIGNMENT}}

**Avatar Targeting**: Which specific customer avatars benefit?
{{AVATAR_TARGETING}}

---

### Cross-Project Intelligence

Search `../../../Project Memory/Active Projects Index/` for related projects when asked.

**Related Projects**:
{{RELATED_PROJECTS}}

---

## PROJECT STRUCTURE

```
{{PROJECT_NAME}}/
├── CLAUDE.md                    # This file - project guidance
├── README.md                    # Project overview
{{FOLDER_STRUCTURE}}
```

---

## EXPECTED DELIVERABLES

{{DELIVERABLES_LIST}}

---

## MULTI-PHASE PROJECT TRACKER

{{PHASE_TRACKER_SECTION}}

---

## SUCCESS CRITERIA

### Project Success
{{PROJECT_SUCCESS_CRITERIA}}

### Business Impact (Post-Implementation)
{{BUSINESS_IMPACT_CRITERIA}}

---

## IMPORTANT REMINDERS

1. **Update Project Memory Index** after major deliverables
2. **Log significant progress** to operations_log.txt
3. **Validate strategic alignment** periodically (OOBG, UV, Avatars)
4. **Reference related projects** for context and integration

---

**Your mission**: {{MISSION_STATEMENT}}
