# Sequential Thinking

Structured problem-solving through iterative reasoning with revision and branching capabilities. Use for complex tasks that require multi-stage analysis or decomposition.

## Core Process
1. **Initial Thought**: State the problem and the first step toward a solution.
2. **Iterative Steps**: Continue with sequential thoughts, adjusting the estimated total thoughts as needed.
3. **Revision**: Backtrack and reconsider earlier thoughts if assumptions prove incorrect or new data emerges.
4. **Branching**: Explore alternative paths from any point in the reasoning chain.
5. **Conclusion**: Signal when the reasoning process is complete.

## When to Use
- The problem is complex and requires multiple interconnected steps.
- The initial scope or approach is uncertain.
- You need to filter through complexity to find core issues.
- Backtracking or alternative exploration is likely needed.

## Key Rules
- **Be Explicit**: Express uncertainty and assumptions clearly in your thoughts.
- **Adjust Scope**: Don't worry about being exactly right with the total thought count initially; update it as you go.
- **Branching**: Use branches to compare different architectural or implementation approaches.
