# Workhub 技能更新总结

**日期**: 2025-01-09  
**版本**: v2.0  
**更新类型**: 功能增强 + 优化

---

## 📋 更新概述

本次更新为 workhub 技能添加了 YAML front matter 元数据支持，并优化了模板结构，移除了冗余信息。

---

## ✨ 新功能

### 1. YAML Front Matter 元数据

所有 Issue 和 PR 文件现在在顶部包含详细的 YAML front matter，包含以下信息：

#### Issue 元数据字段

| 分类 | 字段 | 说明 |
|------|------|------|
| **基础信息** | id, title, type, status, priority, labels | 唯一标识、标题、类型、状态、优先级、标签 |
| **时间信息** | created, updated, due_date, estimated_hours | 创建时间、更新时间、截止日期、预估工时 |
| **人员信息** | assignees, reviewers, reporter, contributors | 负责人、审查人、报告人、贡献者 |
| **分类和关联** | category, tags, related_issues, blocked_by, blocks | 分类、标签、相关 Issue、阻塞关系 |
| **业务信息** | project, milestone, sprint, story_points | 项目、里程碑、迭代周期、故事点数 |
| **技术信息** | complexity, effort, risk_level, dependencies | 复杂度、工作量、风险级别、依赖项 |
| **指标** | created_by_ai, last_updated_by_ai, version | AI 创建标记、版本号 |

#### PR 元数据字段

| 分类 | 字段 | 说明 |
|------|------|------|
| **基础信息** | id, title, type, status, labels | 唯一标识、标题、类型、状态、标签 |
| **时间信息** | created, updated, merged_at, closed_at | 创建时间、更新时间、合并时间、关闭时间 |
| **人员信息** | author, reviewers, assignees | 作者、审查人、负责人 |
| **分类和关联** | category, tags, related_prs, related_issues, branch_from, branch_to | 分类、标签、关联关系、分支信息 |
| **业务信息** | project, milestone, linked_issues | 项目、里程碑、链接 Issue |
| **技术信息** | change_type, size, complexity, risk_level | 变更类型、规模、复杂度、风险级别 |
| **指标** | created_by_ai, last_updated_by_ai, version, files_changed, additions, deletions, commits | AI 创建标记、版本号、代码变更统计 |

### 2. 动态占位符替换

模板支持以下占位符，在创建文件时自动替换：

- `{{date}}`: 当前日期 (格式: yyyy-mm-dd)
- `{{description}}`: 文件描述
- `{{category}}`: 分类（前端/后端/数据库/运维等）

### 3. 自动生成字段

以下字段由系统自动生成，无需手动填写：

- `id`: 唯一标识 (格式: yyyy-mm-dd-描述)
- `created`: 创建时间
- `updated`: 更新时间
- `labels`: 自动生成的标签列表
- `category`: 自动添加分类标签
- `tags`: 自动添加描述标签
- `created_by_ai`: AI 创建标记
- `last_updated_by_ai`: AI 更新标记
- `version`: 版本号

---

## 🎯 优化内容

### 1. 简化模板结构

移除了 Issue 和 PR 模板中与 YAML front matter 重复的元数据表格：

- ❌ 移除 Issue 的"元数据"表格（文件名、创建时间、状态、优先级、负责人、预计工时）
- ❌ 移除 PR 的"元数据"表格（文件名、创建时间、状态、类型、审查人）

这些信息现在统一在 YAML front matter 中管理，遵循 SSOT 原则。

### 2. 保持核心内容

保留了以下关键内容部分：

#### Issue 保留内容
- Goal（目标）
- 背景/问题
- 验收标准
- 实施阶段
- 关键决策
- 遇到的错误
- 相关资源
- Notes
- Status 更新日志

#### PR 保留内容
- 背景与目的
- 变更内容概述
- 关联 Issue 与 ToDo 条目
- 测试与验证结果
- 风险与影响评估
- 回滚方案
- 变更类型
- 文件变更列表
- 详细变更说明
- 测试命令和输出
- 破坏性变更
- 性能影响
- 依赖变更
- 安全考虑
- 文档变更
- 代码审查检查清单
- 审查日志
- 最终状态

---

## 🚀 使用方式

### 创建 Issue

```bash
# 基本用法
bun ~/.pi/agent/skills/workhub/lib.ts create issue "添加深色模式"

# 带分类
bun ~/.pi/agent/skills/workhub/lib.ts create issue "添加深色模式" 前端
```

生成的文件包含：

```yaml
---
# 基础信息
id: "2025-01-09-添加深色模式"
title: "[标题]"
type: "task"
status: "todo"
priority: "medium"
labels:
  - "area:前端"
  - "type:task"
  - "status:todo"

# 时间信息
created: "2025-01-09"
updated: "2025-01-09"
due_date: ""
estimated_hours: ""

# ... 其他元数据
---
```

### 创建 PR

```bash
# 基本用法
bun ~/.pi/agent/skills/workhub/lib.ts create pr "修复登录bug"

# 带分类
bun ~/.pi/agent/skills/workhub/lib.ts create pr "修复登录bug" 后端
```

生成的文件包含：

```yaml
---
# 基础信息
id: "2025-01-09-修复登录bug"
title: "[Pull Request 标题]"
type: "change"
status: "draft"
labels:
  - "area:后端"
  - "type:change"
  - "status:draft"

# 时间信息
created: "2025-01-09"
updated: "2025-01-09"
merged_at: ""
closed_at: ""

# ... 其他元数据
---
```

---

## 📊 AI 索引优势

添加 YAML front matter 后，AI 可以：

1. **快速检索**：通过标签、类型、状态、优先级等字段快速过滤
2. **智能关联**：自动识别相关 Issue 和 PR 之间的依赖关系
3. **统计分析**：按时间、分类、状态等维度生成报告
4. **自动化流程**：根据状态自动触发后续流程
5. **知识管理**：构建结构化的项目知识库

### 示例查询

```bash
# 查找所有高优先级的 Issue
# 查询: priority: "critical" OR priority: "high"

# 查找所有进行中的前端任务
# 查询: category: "前端" AND status: "in-progress"

# 查找所有已合并的 PR
# 查询: status: "merged"

# 查找被阻塞的 Issue
# 查询: blocked_by.length > 0

# 查找某个作者的所有 PR
# 查询: author: "John Doe"
```

---

## 🔧 技术实现

### 1. 动态日期生成

```typescript
function getCurrentDateString(): string {
  const now = new Date();
  const year = now.getFullYear();
  const month = String(now.getMonth() + 1).padStart(2, "0");
  const day = String(now.getDate()).padStart(2, "0");
  return `${year}${month}${day}`;
}

function getISODateString(): string {
  const now = new Date();
  const year = now.getFullYear();
  const month = String(now.getMonth() + 1).padStart(2, "0");
  const day = String(now.getDate()).padStart(2, "0");
  return `${year}-${month}-${day}`;
}
```

### 2. 占位符替换

```typescript
function replaceTemplatePlaceholders(
  content: string, 
  date: string, 
  description: string, 
  category?: string
): string {
  return content
    .replace(/{{date}}/g, date)
    .replace(/{{description}}/g, description || "description")
    .replace(/{{category}}/g, category || "general");
}
```

### 3. 文件创建流程

1. 生成文件名（使用 `getCurrentDateString()`）
2. 读取模板文件
3. 替换占位符（使用 `replaceTemplatePlaceholders()`）
4. 写入目标文件

---

## 📝 文件变更

### 更新的文件

1. **`~/.pi/agent/skills/workhub/lib.ts`**
   - 添加日期生成函数
   - 添加占位符替换函数
   - 更新 `createIssue()` 函数以支持动态替换
   - 更新 `createPR()` 函数以支持动态替换

2. **`~/.pi/agent/skills/workhub/templates/issue-template.md`**
   - 添加 YAML front matter
   - 移除冗余的元数据表格

3. **`~/.pi/agent/skills/workhub/templates/pr-template.md`**
   - 添加 YAML front matter
   - 移除冗余的元数据表格

4. **`~/.pi/agent/skills/workhub/SKILL.md`**
   - 添加 YAML front matter 字段说明
   - 添加 AI 索引优势说明
   - 更新模板结构示例

### 备份文件

- **`~/.pi/agent/skills/workhub/lib.ts.backup`**: 原始 lib.ts 文件备份

---

## ✅ 测试验证

### 测试环境

- 临时目录: `/tmp/test-workhub`
- 测试命令: 使用 `bun` 运行 TypeScript

### 测试结果

1. ✅ 初始化文档结构成功
2. ✅ 创建 Issue 成功，YAML front matter 正确生成
3. ✅ 创建 PR 成功，YAML front matter 正确生成
4. ✅ 占位符替换正确（日期、描述、分类）
5. ✅ 自动生成标签正确
6. ✅ 模板简化成功，移除冗余内容

---

## 🔄 向后兼容性

### 兼容性说明

- ✅ 完全向后兼容
- ✅ 现有的 Issue 和 PR 文件仍然可以正常使用
- ✅ 新创建的文件自动使用新的 YAML front matter
- ✅ 旧的文件可以手动添加 YAML front matter（可选）

### 迁移建议

对于现有的 Issue 和 PR 文件，可以选择：

1. **保持原样**：旧文件继续使用旧格式
2. **手动迁移**：在旧文件顶部添加 YAML front matter
3. **逐步迁移**：创建新文件时自动使用新格式，旧文件在编辑时迁移

---

## 📚 相关文档

- **`~/.pi/agent/skills/workhub/SKILL.md`**: 完整的技能文档
- **`~/.pi/agent/skills/workhub/templates/issue-template.md`**: Issue 模板
- **`~/.pi/agent/skills/workhub/templates/pr-template.md`**: PR 模板
- **`~/.pi/agent/skills/workhub/lib.ts`**: 主脚本文件

---

## 🎉 总结

本次更新显著提升了 workhub 技能的功能性和可用性：

1. **结构化元数据**：通过 YAML front matter 提供丰富的元数据支持
2. **AI 索引优化**：便于 AI 快速检索、关联和统计分析
3. **模板简化**：移除冗余内容，遵循 SSOT 原则
4. **动态生成**：自动填充时间、标签等字段，减少手动输入
5. **向后兼容**：不影响现有文件的使用

这些改进使得 workhub 更适合作为项目文档管理和任务跟踪的工具，特别是在 AI 辅助开发的场景下。