# Magic Model Review - How It Works

## The One-Sentence Version

It's like having Ed look over your shoulder while you review a BlackBelt member's framework, whispering exactly what to say in the Facebook comment.

## Why This Exists

BlackBelt members submit their Magic Models (also called Triangles) for feedback. These are their offer frameworks - the visual map of what they sell and how they deliver transformation.

Reviewing them well takes time. You need to:
- Evaluate five different elements
- Keep feedback practical, not theoretical
- Write in a voice that's supportive but direct
- Stay within Facebook's constraints
- Make the coach feel seen, not lectured

This skill handles the craft. You look at the Magic Model, it produces the feedback ready to paste.

## The Mental Model: The Trusted Advisor

Think of this skill like a trusted advisor who's reviewed hundreds of these frameworks. They've seen all the common mistakes. They know what makes the difference between a framework that sells and one that confuses.

When you show them a Magic Model, they don't give you a checklist. They give you a conversation. "This is already doing good work. Here's what I'd look at..."

That's the output: a conversation, not a report.

## The Five Elements

Every Magic Model has five things to evaluate:

**Yellow (The Goal)** - What result are they promising? Is it concrete? Can someone point to it and say "I achieved that"?

**Reds (The Problems)** - These are the frustrations prospects feel. Are they written in the prospect's actual words? Do they sound like something someone would say at 2am?

**Greens (The Milestones)** - These are the stepping stones to the Yellow. Do they feel like real destinations, or just vague areas? Does each one clearly advance toward the goal?

**Blues (The Projects)** - These are what the client actually does. Are they named as results or tools, not activities? If you complete the Blues, do you achieve the Green?

**Symmetry** - Does the whole thing hang together visually? Same number of Blues per Green? Similar word counts? A Magic Model should look balanced.

## How You Actually Use It

Someone posts their Magic Model screenshot in the BlackBelt group. You want to give feedback.

Upload the image and say "review this Magic Model."

The skill reads it, evaluates all five elements, and produces a Facebook comment. Flowing paragraphs, conversational tone, practical suggestions.

Copy. Paste. Done.

## The Voice

The output sounds like Ed typed it. Not AI. Not a template.

- Short, clean sentences
- Compassionate but direct
- Suggestions, not commands ("worth looking at" not "you should")
- Specific to what you're seeing
- Encouragement that feels earned, not generic

The goal: the coach feels seen, safe, encouraged, and clear on what to do next.

## What It's NOT

This isn't a scoring system. It doesn't give a number out of 10.

This isn't a template filler. It reads the actual Magic Model and responds to what's there.

This isn't positioning or funnel strategy. It stays focused on the five elements. The Magic Model framework, not everything else.

## The Facebook Constraint

Here's a practical detail: Facebook comments have limits. 8,000 characters max, and a 100 line break limit (whichever you hit first).

Bulleted feedback can hit the line break limit at only 2,000 characters. That's why the output is flowing prose, not structured lists. It fits more value into the constraint.

## The Coaching Analogy

When you give feedback to a client, you don't hand them a report card. You have a conversation. You acknowledge what's working. You point to what could be sharpened. You leave them feeling capable, not critiqued.

This skill captures that approach. The output reads like a coaching conversation, not an assessment. Because that's what actually helps people improve.
