---
name: mission-context
description: Provides context about Ed, his mission, terminology, and business. Use when working on Ed's projects, coaching business, AI Powerhouse content, BlackBelt work, or The Little Blue Report. Also use when Ed asks you to understand his business or speak in his voice.
allowed-tools: Read, Glob, Grep, WebSearch, WebFetch, Write, Edit
---

# Mission Context - Ed's Operating Context

This skill gives you everything you need to work effectively with Ed. Load this context when working on his projects.

---

## WHO ED IS

**Ed Dale** - Vibe Coder, world-class copywriter, and coach. Founder of the 30 Day Challenge, The first ever online challenge. Author of the Book Your First Dollar

**Company:** Neon Marillion Pty Ltd

**Background:**
- Senior coach at BlackBelt coaching program
- Created the AI Amplified Coaching Powerhouse program
- Publishes "The Little Blue Report" on Substack
- Thinks in headlines, hooks, and frameworks

**Superpower:** He knows what good looks like. He doesn't need to know how to build it - he needs AI to translate his vision into working reality.

**Mental models come from:** Gary Halbert, Bond Halbert, Stephen King, William Zinsser. Use copywriting and coaching analogies when explaining things.

---

## THE MISSION

### The One-Sentence Strategy (Prime Directive)

> **"First AI win in 30 days. Then compound."**

This is the filter for every decision. If it doesn't help coaches get their first win fast or build compounding leverage, it's a distraction.

**Agent check:** Before building anything, ask:
- Does this help them win in 30 days?
- Does this compound over time?
- If no to both → reconsider.

### The Full Mission

Transform established coaches ($30k+/month) into **AI Amplified Coaching Powerhouses** - safely, sanely, and in a way that feels like them.

**The core promise:**
> Within the first 30 days, you will have your first AI leverage tool deployed live in your business, with a clear roadmap for what to build next.

**What Ed is NOT building:**
- SaaS companies
- Complex tech platforms
- Anything that requires becoming a tech founder

**What Ed IS building:**
- Leverage assets that do the lifting
- Skills that can be reused and shared
- Systems that compound over time

---

## THE TRIANGLE MODEL

Ed's delivery framework has three layers:

### RED - The Problems (What clients feel)
1. Everyone seems to be moving faster with AI
2. Every tech project turns into a nightmare sinkhole
3. Lots of AI toys, AI slop, and no real lift

### GREEN - The Milestones (What they achieve)
1. **Leverage opportunities mapped** - Know where the wins are
2. **Leverage assets live** - Actually deployed and working
3. **Leverage engine amplification** - System keeps improving itself

### BLUE - The Projects (How we get there)

**Milestone 1: Leverage Opportunities Mapped**
- Capabilities X-Ray (scan the business for hidden opportunities)
- Plays Shortlist (prioritized by riskiest assumption first)
- Upgrade Roadmap (90-day sequence with clear success signals)

**Milestone 2: Leverage Assets Live**
- Prompt Whispering™ Prototypes (risk-free proving grounds)
- Deployed Leverage Assets (in live workflows, team-safe)
- Leverage Skunkworks (controlled factory with kill rules)

**Milestone 3: Leverage Engine Amplification**
- Founder AI Lab (test, break, validate what matters)
- Learn & Adapt Cycles (usage → insight → upgrades)
- Compound & Retire Protocols (scale what works, kill what doesn't)

---

## THE THREE STAGES (Data to Implementation)

A framework for explaining AI leverage to coaching businesses:

| Stage | Name | What It Is | The Unlock |
|-------|------|------------|------------|
| **1** | Data Chaos | Can't see what's happening | — |
| **2** | Data Clarity | Can see what's happening | Dashboards, single source of truth |
| **3** | Learning Loops | Insights automatically become implementations | **This is the game changer** |

**Key insight:** Most data/insight services stop at Stage 2. The real unlock is Stage 3—where the CEO has an idea, encodes it in one sentence, and wakes up to find it implemented everywhere.

**The difference:**
- Stage 2 ends with "hope they act"
- Stage 3 ends with "it just appears"

**The tagline:** "Stage 2 is the eyes. Stage 3 is the nervous system that acts."

**The Ash Maurya connection:** The agentic coding loop (Plan → Code → Test → Iterate) IS the business validation loop (Plan → Do → Check → Act). Same engine, different domain. Goal-driven iteration + feedback.

**What Stage 3 looks like:**
- Decision trees change automatically
- Documents produced through AI systems get better every day
- 1% improvements don't add—they multiply (exponential compounding)
- Like opening your app and seeing a cool new feature—it's just there

---

## NEON MARILLION DESIGN SYSTEM

The standard look and feel for web demos and prototypes.

### Brand Color
- **Primary:** Burnt Orange `#E85D04`
- **Primary Light:** `#FFF4ED` (backgrounds, hover states)

### Color Palette
| Color | Hex | Usage |
|-------|-----|-------|
| Burnt Orange | `#E85D04` | Primary brand, CTAs, highlights |
| Orange Light | `#FFF4ED` | Backgrounds, cards |
| Charcoal | `#1C1917` | Primary text, headings |
| Stone | `#78716C` | Secondary text |
| Cream | `#FAFAF9` | Page backgrounds |
| White | `#FFFFFF` | Cards, contrast areas |

### Typography (Fontshare)
```html
<link href="https://api.fontshare.com/v2/css?f[]=clash-display@400,500,600,700&f[]=satoshi@400,500,700&display=swap" rel="stylesheet">
```

| Font | Usage | Weights |
|------|-------|---------|
| **Clash Display** | Headings, hero text, brand name | 400, 500, 600, 700 |
| **Satoshi** | Body copy, UI elements | 400, 500, 700 |

### CSS Variables Template
```css
:root {
    --orange: #E85D04;
    --orange-light: #FFF4ED;
    --charcoal: #1C1917;
    --stone: #78716C;
    --cream: #FAFAF9;
    --white: #FFFFFF;
    --font-display: 'Clash Display', sans-serif;
    --font-body: 'Satoshi', sans-serif;
}
```

### Reference Implementation
See `prototypes/clear-insight-demo/index.html` for a complete example with scroll-triggered animations using Intersection Observer.

---

## ED'S TERMINOLOGY (Use These)

| Term | Meaning |
|------|---------|
| **Capabilities X-Ray** | Scanning a business for leverage opportunities |
| **Plays Shortlist** | Prioritized task list, riskiest assumption first |
| **Leverage Asset** | Any tool that does the lifting |
| **Kill rules** | When to stop and pivot vs. keep pushing |
| **Ship This = Win Day** | The only metric that matters |
| **Prompt Whispering™** | Building AI tools through conversation |
| **Prompt Wrangling™** | Debugging and refinement |
| **Upgrade Roadmap** | 90-day sequence of experiments |
| **Leverage Skunkworks** | Controlled factory for building/testing assets |
| **Founder AI Lab** | Always-on testing of what's working in AI |
| **CFT (Critical Focus Time)** | 50-minute focus block based on attention science. One task, no interruptions. |
| **Research Swarm** | Multi-angle parallel research - attacking a question from 3-5 simultaneous perspectives |
| **Verify With Data** | Proving something works with code, not just eyeballs |
| **Screenshots as Spec** | Visual feedback showing exactly what's wrong - accelerates everything |

---

## HOW TO TALK TO ED

### Translation Layer (Tech → Copywriter Speak)

| Technical | What Ed Hears |
|-----------|---------------|
| Component | Reusable template (like a swipe file element) |
| Props | Variables you pass in (like merge tags) |
| State | What the page remembers (like cookies) |
| API | Backend conversation (like a database query) |
| Deploy | Publish live (like hitting "send") |
| Refactor | Editing for clarity without changing meaning |
| Debug | Finding why the copy isn't converting |
| Dependencies | Tools in your toolbox |
| Repository | Master swipe file for this project |

### Communication Style
- Short, punchy responses
- Use analogies from copywriting and coaching
- Explain the "why" in plain English
- No unnecessary jargon
- Celebrate wins - shipping matters

---

## THE IRON RULES

1. **DO NOT BE LAZY.** Find root causes. No temporary fixes.
2. **MAKE FIXES SIMPLE.** Minimum code impact. Zero new bugs goal.
3. **ALWAYS EXPLAIN THE WHY.** Plain English. Use analogies.

---

## TECH STACK

### The Vibe Coder Rule
> "If I want it to *think* smart, use Python.
> If I want it to *look* cool, use React."

### Hardware (Apple House... Mostly)
- **Mac Studio M4 Pro:** Primary workstation
- **iPhone 16 Pro Max:** Mobile
- **Apple Vision Pro:** First generation
- **iPad Pro 13-inch (M4):** Tablet
- **ASUS ROG Ally X:** PC gaming handheld (AMD Z2 Extreme chip) - the one Windows device

### Development & Deployment
- **Claude Code:** Primary AI coding partner (CLI)
- **Antigravity IDE:** Google's IDE with Claude extension
- **Claude.ai:** Web interface for conversations & skills
- **GitHub:** Version control, skill distribution
- **Vercel:** Hosting & deployment (React/Next.js)
- **Google Cloud Run:** Deployment (Google stack)
- **Google AI Studio:** AI development & testing

### Content & Knowledge
- **Obsidian:** Daily notes, content pipeline, knowledge base
- **Substack:** The Little Blue Report publication
- **MacWhisper:** Dictation and transcriptions
- **Descript:** Video editing
- **DaVinci Resolve:** Video editing (latest)

### Daily Drivers
- **Arc:** Primary browser
- **Comet:** Secondary browser
- **Apple Mail:** Email client (Claude Code can draft/send via AppleScript)
- **Google Calendar:** Calendar

### Languages
- **Python:** When it needs to think (AI, automation)
- **React/Next.js:** When it needs to look good (UI)
- **Markdown:** Everything else (skills, docs, notes)

### AI Tools
- **Claude:** Primary AI partner (Code + .ai)
- **ChatGPT:** Conversations, brainstorming

### CRM & Marketing Automation
- **GoHighLevel (GHL):** CRM, workflows, lead capture, landing pages
  - Ed uses **CMM (Coach Marketing Machine)** which is a white-label of GHL (identical functionality)
  - When writing content, refer to "GHL" for audience clarity (most won't know CMM)
  - **Integration strategy:** Direct API integration - Claude builds lead magnet sites that connect directly to GHL API for CRM updates and workflow triggers (no Zapier/n8n middleware)

### Socials & Platforms

| Platform | Handle | Usage |
|----------|--------|-------|
| **YouTube** | [@eddale](https://youtube.com/@eddale) | Weekly long-form value content (key focus going forward) |
| **Instagram** | [@eddale](https://instagram.com/eddale) | Daily posting: 4 days value/engagement, 1 day lead magnet handraiser (via GHL) |
| **Twitter/X** | [@Ed_Dale](https://x.com/ed_dale) | Read daily, rarely post |
| **Facebook** | Business + Personal pages | Experimenting with Instagram carousel reposts |
| **LinkedIn** | Neon Marillion Pty Ltd | Recently refreshed |
| **Linktree** | [linktr.ee/eddale](https://linktr.ee/eddale) | Link hub |
| **Substack** | The Little Blue Report | Primary newsletter |

### Agent Capabilities (What Claude Code Can Do)
- **Email (Send):** Draft and open in Mac Mail via AppleScript (review before send) ✓
- **Email (Search):** Limited - AppleScript too slow for large mailboxes, Spotlight broken since Catalina. Future: Python IMAP or Gmail API
- **Files:** Read/write to Obsidian vault and GitHub repos
- **Web:** Fetch and analyze URLs, search the web
- **Git:** Full version control, commits, pushes
- **Shell:** Run scripts, package skills, system automation
- **Browser Automation:** Claude in Chrome MCP for end-to-end testing of deployed apps

---

## THE LEVERAGE ASSET FORMULA

When building tools that do the lifting:

| Step | Action |
|------|--------|
| 1. **Identify grunt work** | What's repetitive and tedious? |
| 2. **Template it** | Create a prompt/process that produces consistent output |
| 3. **Wrap in UI** | Make it accessible (form, CLI, skill) |
| 4. **Deploy it** | Put it where it can be used (Vercel, Claude.ai, etc.) |
| 5. **Document it** | README + HOW-IT-WORKS so future-you understands |

**Replicable for:** SOPs, email sequences, workshop outlines, client intake forms, coaching frameworks, playbooks.

---

## HOW ED GIVES FEEDBACK

**What works:**
- Specific problem statements ("tables aren't rendering")
- Screenshots showing the issue
- Clear success criteria ("should look like X")

**What slows things down:**
- Vague descriptions ("something's off")
- No visual reference
- Moving targets

**Screenshots aren't decoration - they're the spec.**

---

## SKILL ARCHITECTURE

Ed's skills follow a three-layer pattern:

### The Three Layers

| Layer | What It Is | Who Maintains |
|-------|------------|---------------|
| **Tools** | Python scripts, APIs, Bash | Hidden inside skills |
| **Skills** | SKILL.md with instructions | Edit markdown to change |
| **Agents** | Orchestrators pulling skills | Reference skills, not tools |

### Skills Own Their Tools
- Python scripts live in `skills/<name>/tools/`
- SKILL.md tells Claude how to run them
- Agents reference skills, not tools directly

### Context Propagation
When writing content:
- Audience should be established early (ask if not specified)
- Pass context to downstream skills (hook-stack, slop-detector)
- Store in article frontmatter for visibility

### The Newsletter Pipeline
1. Input (YouTube URL, topic, experience)
2. Establish audience (ask if not specified)
3. Extract/analyze content
4. Generate headlines with audience context
5. Score with Hook Stack (12+ required)
6. Draft article in Ed's voice
7. Run through slop detector
8. Save to Zettelkasten with metadata

### Runtime Differences

Skills must account for which Claude runtime executes them:

| Capability | Claude Code (CLI) | Claude.ai (Mac/Web) |
|------------|-------------------|---------------------|
| Filesystem | Full access | Sandboxed |
| External APIs | Yes (curl, WebFetch) | Blocked by sandbox |
| Bash/Python | Yes | No |
| MCP Servers | Supported | Primary method for external data |
| Best for | Automation, building | Conversation, local-tool skills |

**Design implications:**
- Claude Code skills can use deployed APIs (Vercel, etc.)
- Claude.ai skills should either:
  1. Include all tools locally (`tools/` folder with scripts)
  2. Use MCP servers for external data access
  3. Accept manual paste as fallback

Example: youtube-processor has both local Python script (Claude Code) and Vercel API (doesn't work in Claude.ai due to sandbox - future MCP solution planned).

---

## CURRENT FOCUS AREAS

### Powerhouse Lab (This Repo)
Ed's Leverage Skunkworks where AI tools get built, tested, and validated.

**Lifecycle:**
```
prototypes/ → skills/ → [Own Repo]
     ↓
  archive/ (kill rule applied)
```

### The Little Blue Report
Ed's Substack newsletter. Educational content drawn from daily experiences.

### BlackBelt Coaching
Ed's a coach in Taki Moore's high-end coaching program.

### AI Amplified Coaching Powerhouse
Ed's flagship coaching program for implementing AI into successful coaching businesses.

---

## WHEN TO USE THIS SKILL

Activate this context when:
- Working on any Ed project
- Writing content in Ed's voice
- Building tools for the coaching business
- Discussing strategy or positioning
- Creating materials for clients
- Anytime you need to understand Ed's world

---

## UPDATING THIS CONTEXT

Ed can update this skill anytime by saying:
- "Update my mission context to include..."
- "Add this to my terminology..."
- "Change my current focus to..."

When Ed requests changes, edit this SKILL.md file directly.
