# Mission Context - How It Works

## The One-Sentence Version

It's like handing a new assistant the complete briefing book on who Ed is, what he's building, and how to talk to him.

## Why This Exists

Imagine hiring a new team member. On day one, they don't know your terminology. They don't know your priorities. They don't know why you cringe when someone says "utilize" or why you care so much about shipping.

Now imagine having to explain all of that every single time you start a new conversation.

That's the problem this skill solves. It's the briefing document that gets loaded automatically. Every skill and agent that pulls mission-context knows:
- Who Ed is
- What he's building
- How he talks about things
- What matters and what doesn't

## The Mental Model: The Company Bible

Big companies have these internal documents - the company values, the terminology guide, the "how we do things here" handbook.

Mission-context is that handbook for working with Ed. It's not policy - it's pattern. How to translate tech speak into copywriter language. Which frameworks to reference. What the prime directive actually means.

## What's In It

**Who Ed Is** - Vibe Coder, copywriter, coach. Founder of the 30 Day Challenge. Thinks in headlines and hooks. His superpower is knowing what good looks like without knowing how to build it.

**The Mission** - "First AI win in 30 days. Then compound." That's the filter. If a project doesn't help coaches win fast or build leverage that compounds, it's a distraction.

**The Triangle Model** - Ed's delivery framework. Red (problems clients feel), Green (milestones they achieve), Blue (projects that get them there). This is how Ed structures any transformation.

**The Terminology** - Capabilities X-Ray. Plays Shortlist. Leverage Assets. Kill rules. These aren't random words - they're specific concepts with specific meanings. Get them wrong and communication breaks down.

**The Translation Layer** - When Ed hears "component," he thinks "reusable template." When he hears "state," he thinks "what the page remembers." This layer makes tech talk feel familiar.

**The Tech Stack** - Mac Studio, Claude Code, Vercel, Obsidian. What tools Ed actually uses. Important when building things that need to integrate.

## How You Actually Use It

You don't invoke this skill directly. Other skills and agents load it.

When newsletter-writer needs to write in Ed's voice, it pulls mission-context to understand that voice. When capture-triage needs to route things, it checks mission-context for active projects.

The context propagates. You talk to one skill, and it knows who Ed is because it loaded this briefing.

## The Iron Rules

Three rules that never bend:
1. Don't be lazy - find root causes, no temp fixes
2. Make fixes simple - minimum impact, zero new bugs
3. Always explain the why - plain English, use analogies

These show up in code reviews, in feedback, in everything. They're the non-negotiables.

## What It's NOT

This isn't a biography. It's operational context.

This isn't static forever. When Ed's focus changes, when new terminology emerges, when the tech stack updates - this file gets updated.

This isn't public marketing. It's internal briefing. Raw and direct, not polished for external consumption.

## The Copywriter Analogy

Before writing for a client, a good copywriter builds a "client avatar" document. Who they are, what they care about, how they talk, what makes them cringe.

Mission-context is Ed's avatar document - but for AI. It's everything a skill or agent needs to work effectively with him, without asking basic questions every time.
