# Onboarding Doc Builder - How It Works

## The One-Sentence Version

It's like having Jennifer Waters' setter playbook system templated and ready to customize for any role in 60 seconds.

## Why This Exists

Every new hire needs onboarding. Training videos. Tool setup guides. Daily rhythms. Compensation structures.

Writing this from scratch takes hours. And every coach does it differently, leading to inconsistent results.

Jennifer Waters cracked this at BlackBelt. Her insight: "When we hire a setter, they do all their own onboarding because the playbook is completely laid out." Zero hand-holding required. The playbook is the training.

This skill generates that playbook structure instantly.

## The Mental Model: The Self-Service Training Manual

Imagine a new hire's first day. They could:
1. Follow you around asking questions for a week
2. Open a document and work through it at their own pace

Option 2 scales. It's consistent. It doesn't depend on you being available.

That's what this skill creates: a self-service training manual. Everything organized. Every step linked to a Loom video. Checkboxes to track progress.

## How You Actually Use It

Say "create onboarding doc" or "playbook for appointment setter."

Three questions:
1. What's the role?
2. What blueprint are they implementing? (e.g., "Sell by Chat")
3. What tools will they use?

Then you get a complete playbook: company foundation, tech setup, role training, daily activities, scorecard, communication structure, and completion confirmation.

## The Loom Placeholder Pattern

The playbook is full of `[INSERT LOOM LINK]` placeholders. That's intentional.

The structure is instant. The content is your job.

Record each Loom video, drop in the link. Jennifer's advice: "Do it in order. Takes about 2 hours total." Then you have a complete onboarding system forever.

## What Gets Generated

**Company Foundation** - Mission, values, who you serve. The "why we exist" stuff.

**Tech Setup** - Every tool they'll use, with a setup video for each. Plus account checklist.

**Role Training** - The system they're implementing. Product knowledge. Scripts and frameworks.

**Daily Activities** - What a typical day looks like. Time blocks. Pipeline workflow.

**Scorecard & Compensation** - KPIs with targets. Pay structure. What "good" looks like.

**Communication** - Who to contact for what. Weekly check-in schedule.

**Completion Confirmation** - How they signal "I'm done onboarding and ready to work."

## The Jennifer Waters Insight

"Don't try to type anything out. If you're hiring a setter, they're probably in their twenties. They hate reading. They'd rather consume via video."

That's why the playbook is structured around videos, not paragraphs. Each section links to a Loom. The text is just context and checkboxes.

## What It's NOT

This isn't a Loom recorder. You still make the videos.

This isn't HR software. It generates a markdown document, not a tracking system.

This isn't role definition. You still need to know what the role does. The skill structures the onboarding, not the job itself.

## The Leverage Asset Pattern

This is a perfect example of the leverage asset formula:
1. Identify grunt work → Writing onboarding docs manually
2. Template it → Standard structure that works across roles
3. Wrap it → Skill that generates customized versions
4. Deploy it → Save to Zettelkasten, copy to Google Docs
5. Document it → This guide you're reading

Same pattern works for SOPs, email sequences, any document you write repeatedly.
