# Skill Templates

This document provides templates for structuring different types of skills based on the learning moment type.

## Template 1: Workflow/Process Skill

**Use for**: Novel problem-solving approaches, workflow optimizations

**Structure**:
```markdown
---
name: [descriptive-name]
description: [What task this handles and when to use it. Be specific about triggers.]
---

# [Skill Name]

## Overview

[1-2 sentences: what problem this solves, what outcome it produces]

## When to Use This Skill

Use this skill when:
- [Specific trigger condition 1]
- [Specific trigger condition 2]
- [Specific trigger condition 3]

## Workflow

### Step 1: [Action Name]

[What to do, key considerations, expected output]

### Step 2: [Action Name]

[What to do, key considerations, expected output]

### Step 3: [Action Name]

[What to do, key considerations, expected output]

## Key Principles

- [Important guideline 1]
- [Important guideline 2]
- [Important guideline 3]
```

## Template 2: Domain Knowledge Skill

**Use for**: Domain-specific knowledge synthesis, company processes/terminology

**Structure**:
```markdown
---
name: [domain-name]
description: [Domain expertise this provides and what tasks it supports]
---

# [Domain Name]

## Overview

[1-2 sentences: what domain knowledge this captures]

## Core Concepts

### [Concept 1]
[Definition and key details]

### [Concept 2]
[Definition and key details]

## Standards and Conventions

[Company/domain-specific standards, terminology, processes]

## Common Patterns

[Recurring patterns in this domain that should be followed]

## References

[If applicable, point to reference files for detailed schemas, APIs, etc.]
```

## Template 3: Task Pattern Skill

**Use for**: Repeated patterns in user's work

**Structure**:
```markdown
---
name: [pattern-name]
description: [Specific task pattern this handles and when it's triggered]
---

# [Pattern Name]

## Overview

[1-2 sentences: what recurring task this handles]

## Template Structure

[The consistent structure/format to follow]

## Key Elements

### [Element 1]
[What to include, how to handle it]

### [Element 2]
[What to include, how to handle it]

## Examples

### Example 1: [Scenario]
[Concrete example showing the pattern]

### Example 2: [Scenario]
[Another concrete example]
```

## Template 4: Reasoning/Prompt Pattern Skill

**Use for**: Effective prompt/reasoning patterns discovered

**Structure**:
```markdown
---
name: [pattern-name]
description: [What reasoning approach this captures and for what types of problems]
---

# [Pattern Name]

## Overview

[1-2 sentences: what reasoning pattern this captures, what makes it effective]

## When to Use

Use this reasoning pattern for:
- [Problem type 1]
- [Problem type 2]
- [Problem type 3]

## Reasoning Structure

### Phase 1: [Name]
[What to think about, what questions to ask]

### Phase 2: [Name]
[What to analyze, what to consider]

### Phase 3: [Name]
[How to synthesize, what to output]

## Key Principles

- [Principle that makes this approach effective]
- [Principle that makes this approach effective]

## Example Application

[Concrete example of this reasoning pattern in action]
```

## Template Selection Guide

Choose template based on learning moment type:

| Learning Moment Type | Recommended Template | Key Features |
|---------------------|---------------------|--------------|
| Novel problem-solving | Workflow/Process | Sequential steps, clear decision points |
| Repeated patterns | Task Pattern | Structure/format emphasis, examples |
| Domain knowledge | Domain Knowledge | Concepts, standards, terminology |
| Reasoning patterns | Reasoning/Prompt Pattern | Thinking structure, principles |
| Workflow optimizations | Workflow/Process | Tool chaining, efficiency focus |
