# Pitch Deck Best Practices

This reference provides comprehensive guidance on creating effective pitch decks based on successful patterns, investor feedback, and presentation psychology.

## Core Principles

### The 10-Minute Rule
Pitch decks should tell a complete story in 10 minutes. This translates to roughly 1-2 minutes per slide. Design for the verbal presentation first, with the deck serving as visual support rather than a document to read.

### The "So What?" Test
Every slide must answer "so what?" If a slide presents information without conveying why it matters, either add context or remove the slide. Investors care about implications, not just facts.

### Show, Don't Tell
Replace claims with evidence:
- Instead of "Large market" → Show TAM/SAM/SOM breakdown
- Instead of "Strong traction" → Show growth chart with clear trajectory
- Instead of "Great team" → Show relevant exits, domain expertise, or track records
- Instead of "Better solution" → Show head-to-head comparison or customer testimonials

## Slide-Specific Guidance

### Cover Slide
**Purpose**: Establish credibility and set tone in 5 seconds

**Include**:
- Company name (prominent)
- One-line value proposition or tagline
- Visual that hints at the solution (product screenshot, icon, or brand element)
- Contact information (email, phone)
- Date (optional but useful for tracking versions)

**Avoid**:
- Long descriptions
- Multiple logos or cluttered branding
- Legal disclaimers (save for appendix)
- Generic stock photos

**Example Structure**:
```
[Large Company Name]
[Tagline: One sentence describing value]
[Visual element]
[Founder Name, Email] | [Date]
```

### Problem Slide
**Purpose**: Establish pain point urgency and relevance

**Critical Elements**:
- Quantify the problem (cost, time wasted, people affected)
- Make it relatable (use a concrete scenario or customer quote)
- Show why current solutions fail
- Demonstrate you deeply understand the customer

**Common Mistakes**:
- Being too abstract or high-level
- Listing problems without showing impact
- Focusing on your solution instead of the problem
- Underestimating existing alternatives

**Strong Example**:
```
"Healthcare providers waste 15+ hours per week on administrative paperwork"
- Average physician spends 35% of time on non-clinical tasks
- Leading cause of burnout cited by 63% of doctors
- Results in $4.6B in annual productivity loss
[Visual: Doctor buried in paperwork]
```

### Solution Slide
**Purpose**: Present your approach clearly and memorably

**Critical Elements**:
- How your solution addresses the specific problem presented
- Your unique approach or insight
- Why this hasn't been solved before (timing, technology, insight)
- Simple visual or diagram showing how it works

**Common Mistakes**:
- Feature dump instead of benefit focus
- Too technical too early
- Claiming to solve everything
- No clear differentiation from alternatives

**Framework**: "We [approach] that enables [customer] to [benefit] without [previous barrier]"

### Product/Demo Slide
**Purpose**: Make your solution tangible and credible

**Critical Elements**:
- Actual product screenshots or demo
- User flow or key interaction
- "Aha moment" - the core value delivery
- Keep it simple - show the essential workflow

**Common Mistakes**:
- Screenshots with too much detail
- Multiple disconnected features
- No clear user benefit visible
- Ugly or incomplete product views

**Tip**: If product isn't built yet, show high-fidelity mockups or prototype screenshots. Be transparent about stage.

### Market Slide
**Purpose**: Validate opportunity size and growth potential

**Critical Elements**:
- TAM (Total Addressable Market) - theoretical maximum
- SAM (Serviceable Addressable Market) - realistically reachable
- SOM (Serviceable Obtainable Market) - near-term target
- Market growth rate or trends
- Bottom-up calculation to validate top-down numbers

**Common Mistakes**:
- Only showing TAM without SAM/SOM
- Using unrealistic or old market research
- No explanation of how you'll capture market share
- Ignoring market dynamics or competition

**Strong Approach**:
```
TAM: $50B (All enterprise software buyers globally)
SAM: $8B (Mid-market SaaS companies in NA/EU)
SOM: $400M (Companies with 50-500 employees in our verticals)

Bottom-up: 2,000 target companies × $200K average deal = $400M SOM
```

### Business Model Slide
**Purpose**: Demonstrate path to revenue and unit economics

**Critical Elements**:
- Revenue model (subscription, transaction, licensing, etc.)
- Pricing structure
- Key unit economics (CAC, LTV, gross margin)
- Revenue streams if multiple

**Common Mistakes**:
- Vague "we'll figure it out later" attitude
- Complex multi-sided models without clear path
- Unit economics that don't work at scale
- No consideration of customer acquisition

**Tip**: If pre-revenue, show planned model with assumptions clearly stated. Show what validates pricing (customer interviews, willingness to pay, comparable products).

### Traction Slide
**Purpose**: Prove product-market fit and momentum

**Critical Elements**:
- Growth trajectory (users, revenue, key metrics over time)
- Meaningful absolute numbers
- Context (benchmarks, cohort analysis, retention)
- Visual chart showing hockey stick growth

**Common Mistakes**:
- Vanity metrics without business impact
- Percentage growth on tiny base numbers
- Cherry-picked timeframes
- No context for whether metrics are good

**Strong Metrics by Stage**:
- Pre-seed: User interviews, LOIs, pilot results, waitlist
- Seed: MoM growth rate, early revenue, retention
- Series A: ARR, growth rate, retention, CAC/LTV
- Series B+: ARR, growth rate, net retention, sales efficiency

### Competition Slide
**Purpose**: Show market understanding and defensibility

**Critical Elements**:
- Honest assessment of competitive landscape
- Clear differentiation on dimensions customers care about
- Why your approach is defensible
- Visual framework (quadrant, table, or positioning map)

**Common Mistakes**:
- Claiming no competition
- Only comparing features (not benefits)
- Attacking competitors personally
- No explanation of barriers to entry

**Frameworks**:
- 2×2 quadrant: Two key differentiators as axes
- Feature comparison table: You vs. 2-3 key competitors
- Evolution timeline: Show how market is shifting to your approach

### Team Slide
**Purpose**: Establish credibility and capability

**Critical Elements**:
- Founders with photos and relevant credentials
- Why this team can execute (domain expertise, prior exits, technical chops)
- Key hires or advisors if notable
- Clear roles and complementary skills

**Common Mistakes**:
- Overly detailed resumes
- Credentials that don't relate to the business
- No explanation of how team came together
- Missing technical co-founder in technical business

**Strong Formula**: [Name] - [One-line credential relevant to role]
Example: "Jane Chen - Former Product Lead at Stripe, scaled payments from $1B to $10B"

### Financials Slide
**Purpose**: Show path to scale and capital efficiency

**Critical Elements**:
- 3-5 year projections (revenue, expenses, headcount)
- Key assumptions clearly stated
- Path to profitability (or why growth > profitability)
- Use of funds if raising

**Common Mistakes**:
- Hockey stick with no justification
- Too much detail (avoid full P&L)
- Unrealistic growth rates
- No explanation of how you get there

**Tip**: Investors expect optimism but need to believe the math. Show 2-3 scenarios if possible (base, upside, downside).

### The Ask Slide
**Purpose**: Clear call to action with specific terms

**Critical Elements**:
- Amount raising
- Type of round (equity, SAFE, convertible note)
- Use of funds breakdown
- Expected timeline
- Key milestones this funding enables

**Common Mistakes**:
- Vague "we're open to investors"
- No breakdown of fund usage
- Unrealistic runway claims
- Not connecting funding to outcomes

**Strong Example**:
```
Raising: $2M Seed Round

Use of Funds:
- Product & Engineering (60%) - Launch V2.0, mobile app
- Sales & Marketing (25%) - Hire 2 AEs, expand to 3 new verticals  
- Operations (15%) - Customer success, infrastructure

Milestones with This Round:
- $1M ARR by Month 12
- 50+ enterprise customers
- Achieve unit economics: LTV/CAC > 3:1
```

## Visual Design Principles

### Typography
- **Headlines**: 36-48pt, bold, sentence case (not TITLE CASE)
- **Body text**: 20-24pt minimum (readable from back of room)
- **Maximum text per slide**: 30-40 words
- **Font choices**: Sans-serif for modern tech (Helvetica, Arial, Calibri), serif for professional services (Georgia, Garamond)

### Color Strategy
**Primary color**: Brand color, used for headers, key accents, data emphasis
**Secondary color**: Complementary, used for supporting elements
**Neutral base**: Dark gray (#333333) for text, light gray (#F5F5F5) for backgrounds
**Accent**: High-contrast color for calls-to-action or critical data

**Color meanings**:
- Blue: Trust, professional, stable (finance, enterprise)
- Green: Growth, sustainability, health (climate, wellness)
- Orange/Red: Energy, urgency, passion (consumer, social)
- Purple: Innovation, premium, creative (luxury, design)

### Chart Design
**Essential elements**:
- Title that states the insight (not just "Revenue Growth")
- Clear axis labels with units
- Minimal gridlines (every 2nd or 3rd line)
- Data labels on key points
- Source citation if from external data

**Chart types by use case**:
- **Line chart**: Trends over time, growth trajectories
- **Bar chart**: Comparisons, categorical data, survey results
- **Stacked bar/area**: Component breakdown over time
- **Pie chart**: Avoid unless showing 2-3 segments; use donut chart instead
- **Scatter plot**: Correlation, positioning (e.g., market quadrants)

## Storytelling Frameworks

### The Hero's Journey (Investor Pitch)
1. **Ordinary world**: Current market state (cover, problem)
2. **Call to adventure**: The opportunity or insight (solution)
3. **Meeting the mentor**: Validation, early traction, key partnerships
4. **Crossing threshold**: Product launched, first customers
5. **Trials**: Market challenges, competition, growth struggles
6. **Approach**: Strategy, business model, go-to-market
7. **Ordeal**: The critical challenge this funding solves
8. **Reward**: Vision achieved, market position secured
9. **Return**: Exit potential, impact delivered

### Problem-Agitate-Solve (Sales Pitch)
1. **Problem**: Establish the pain point with data
2. **Agitate**: Make the problem feel urgent and costly (what happens if unsolved?)
3. **Solve**: Present your solution as the clear answer
4. **Proof**: Show it works with customer examples
5. **Action**: Clear next steps

### The Pixar Pitch
"Once upon a time, [market state]. Every day, [problem occurred]. One day, [we discovered/built]. Because of that, [customer benefit]. Because of that, [market impact]. Until finally, [vision of future]."

## Common Investor Questions to Preempt

### "Why now?"
Address in solution or market slides:
- Technology enabler (e.g., AI capabilities reached threshold)
- Market shift (e.g., remote work normalized)
- Regulatory change
- Customer behavior evolution

### "Why you?"
Address in team slide:
- Domain expertise (10+ years in industry)
- Prior success (exits, scaled products)
- Unique insights (worked at company in space)
- Network effects (access to customers, partners)

### "What's the moat?"
Address in competition or solution slides:
- Network effects
- Proprietary data or technology
- Switching costs
- Brand and community
- Scale economies

### "What's the biggest risk?"
Address proactively:
- If execution risk: emphasize team capability
- If market risk: show traction and customer validation
- If technical risk: show prototype and expert team
- If competition risk: show differentiation and growth speed

## Deck Variants

### Pitch Deck (Presentation)
- **Length**: 12-15 slides
- **Format**: Visual-heavy, minimal text
- **Audience**: Live presentation to investors
- **Style**: Bold headlines, large charts, room for verbal explanation

### Extended Deck (Reading)
- **Length**: 15-25 slides
- **Format**: Self-explanatory, more detail
- **Audience**: Email to investors, detailed review
- **Style**: Complete sentences, additional context slides, appendix with details

### One-Pager / Teaser
- **Length**: 1 slide or page
- **Format**: Ultra-condensed key points
- **Audience**: Cold outreach, event handouts
- **Style**: Company name, one-line pitch, key metrics, team, ask

### Demo Day Deck
- **Length**: 8-12 slides (often time-constrained)
- **Format**: Extremely focused, high-impact visuals
- **Audience**: Large audience, quick impressions
- **Style**: Maximum visual impact, minimum text, memorable hook

## Quality Checklist

Before finalizing a deck, verify:

**Content**:
- [ ] Every slide passes "so what?" test
- [ ] Data is current and accurately cited
- [ ] Claims are supported with evidence
- [ ] Competitive analysis is honest and fair
- [ ] Financial projections have clear assumptions

**Design**:
- [ ] Consistent fonts and colors throughout
- [ ] No slide has >40 words of text
- [ ] All charts have clear titles and labels
- [ ] Images are high-resolution (not pixelated)
- [ ] Sufficient whitespace (40-60% per slide)

**Story**:
- [ ] First 3 slides hook attention
- [ ] Logical flow between slides
- [ ] Strongest material in slides 6-9
- [ ] Clear ask in final slides
- [ ] Deck can be understood without presenter (extended version)

**Technical**:
- [ ] All links work (if included)
- [ ] Deck exports properly to PDF
- [ ] File size reasonable (<10MB for sharing)
- [ ] Contact information is current
- [ ] Version number or date included
