---
name: resume-builder
description: Comprehensive resume creation, review, and optimization with support for multiple formats, ATS optimization, industry-specific guidance, and career stage customization. Use this skill when users request help writing, creating, reviewing, improving, or tailoring resumes for job applications.
---

# Resume Builder

## Overview

This skill provides comprehensive guidance for creating professional, ATS-optimized resumes tailored to specific industries, career stages, and job opportunities. It includes best practices, templates, industry-specific guidance, and ATS optimization strategies.

## Workflow Decision Tree

Use this decision tree to determine the appropriate workflow:

**1. Is this a new resume from scratch?**
   → Yes: Follow "Creating New Resumes" workflow
   → No: Continue to question 2

**2. Is there an existing resume to review/improve?**
   → Yes: Follow "Reviewing Existing Resumes" workflow
   → No: Continue to question 3

**3. Is the goal to tailor an existing resume for a specific job?**
   → Yes: Follow "Tailoring Resumes" workflow
   → No: Follow "General Resume Consultation" workflow

## Creating New Resumes

Use this workflow when creating a resume from scratch.

### Step 1: Gather Information

Collect essential information through conversation:

**Career Information:**
- Career stage (entry-level, mid-career, senior, career changer)
- Target industry and specific role
- Years of experience in field
- Education background
- Key skills and certifications
- Notable achievements and quantifiable results

**Context:**
- Specific job description (if available) for tailoring
- Career transition context (if applicable)
- Employment gaps or unique circumstances
- Geographic location (for regional considerations)

### Step 2: Select Appropriate Template

Choose from available templates based on situation:

**Chronological Template** (`assets/template-chronological.md`):
- Best for: Consistent work history, clear career progression
- Use when: Staying in same field, no significant gaps
- Candidates: Most professionals with traditional career paths

**Functional Template** (`assets/template-functional.md`):
- Best for: Career changers, employment gaps, diverse experience
- Use when: Emphasizing transferable skills over timeline
- Candidates: Career transitions, returning to workforce

**Combination Template** (`assets/template-combination.md`):
- Best for: Mid-career professionals with diverse skill sets
- Use when: Highlighting both skills and career progression
- Candidates: Strong experience wanting to emphasize competencies

**Entry-Level Template** (`assets/template-entry-level.md`):
- Best for: Recent graduates, 0-2 years experience
- Use when: Limited professional experience, strong academic background
- Candidates: New graduates, interns transitioning to full-time

### Step 3: Reference Industry and Career Stage Guidance

Before writing, consult relevant sections in `references/industry-career-guidance.md`:

**Career Stage Guidance:**
- Entry-Level / Recent Graduate strategies
- Mid-Career Professional approaches
- Senior / Executive positioning
- Career Changer techniques

**Industry-Specific Guidance:**
- Technology / Software Engineering
- Healthcare / Medical
- Finance / Accounting
- Marketing / Sales
- Education / Teaching
- Legal
- Retail / Hospitality
- Non-Profit / Social Impact
- Government / Public Service
- Creative / Design
- Manufacturing / Supply Chain

Tailor language, priorities, and emphasis based on industry norms.

### Step 4: Apply Best Practices

Consult `references/best-practices.md` for:

**Content Standards:**
- Achievement-oriented language with action verbs
- Quantified results following the formula: Action + Task + Result
- Appropriate professional tone and tense usage
- Relevance over completeness

**Format Standards:**
- Length appropriate to career stage (1-2 pages)
- Professional visual design with adequate white space
- Standard fonts and consistent formatting
- PDF file format for submission

**Section-Specific Guidance:**
- Contact information requirements
- Professional summary construction (when to include/skip)
- Work experience bullet formulation using STAR method
- Education placement and details based on career stage
- Skills section organization and content
- Additional sections (certifications, projects, etc.)

### Step 5: Implement ATS Optimization

Apply ATS-friendly practices from `references/ats-optimization.md`:

**Structure Requirements:**
- Standard section headings
- Simple, single-column layout
- No text boxes, tables, or complex formatting
- Standard fonts and bullet points

**Keyword Integration:**
- Extract keywords from job description (if provided)
- Place keywords strategically in summary, skills, and experience
- Use both acronyms and spelled-out versions
- Integrate naturally without keyword stuffing

**Format Compliance:**
- Text-selectable PDF format
- No images or graphics containing text
- Standard date formatting
- Plain text contact information

### Step 6: Write and Format Resume

Create resume using docx format:

1. **Start with selected template structure**
2. **Populate each section** with gathered information
3. **Apply industry-specific language** and priorities
4. **Ensure ATS compliance** throughout
5. **Verify all formatting** is clean and consistent
6. **Include relevant sections** only (delete inapplicable ones)

**Critical Formatting Guidelines:**
- Use standard fonts: Calibri, Arial, Helvetica, or similar (10-12pt body, 14-16pt headers)
- Consistent bullet points throughout (use • or - consistently)
- Left-aligned text for easy scanning
- Adequate white space between sections
- Bold for headers and company/role names
- Dates right-aligned or consistently placed
- No decorative elements that interfere with ATS parsing

### Step 7: Quality Check

Before delivering, verify:

**Content:**
- [ ] All bullets start with strong action verbs
- [ ] Achievements include quantifiable metrics where possible
- [ ] Verb tenses consistent (past for previous, present for current)
- [ ] No typos or grammatical errors
- [ ] Content tailored to target role (if job description provided)

**Format:**
- [ ] Appropriate length for career stage
- [ ] Consistent formatting throughout
- [ ] Professional appearance
- [ ] Standard section headings
- [ ] Contact information accurate and complete

**ATS:**
- [ ] Simple formatting without tables/columns
- [ ] Keywords from job description included (if provided)
- [ ] Text-based (not image-based)
- [ ] Standard fonts used

## Reviewing Existing Resumes

Use this workflow when reviewing and improving an existing resume.

### Step 1: Initial Assessment

Analyze the existing resume against best practices:

**Content Review:**
- Are bullets achievement-oriented or duty-oriented?
- Are results quantified with specific metrics?
- Is verb tense consistent?
- Is all content relevant to target role?
- Are there typos or grammatical errors?

**Format Review:**
- Is length appropriate for career stage?
- Is formatting consistent (fonts, bullets, spacing)?
- Is there adequate white space?
- Are section headings standard and clear?
- Is visual hierarchy effective?

**ATS Compatibility:**
- Does it use ATS-friendly formatting?
- Are there problematic elements (tables, columns, text boxes)?
- Are section headings standard?
- Would this parse correctly in an ATS?

### Step 2: Identify Improvement Opportunities

Categorize issues found:

**Critical Issues** (must fix):
- Typos and grammatical errors
- ATS-incompatible formatting
- Missing critical sections (contact info, experience, education)
- Unprofessional elements
- Inconsistent or incorrect dates

**Major Improvements** (significantly strengthen resume):
- Transform duty-based bullets to achievement-based
- Add quantifiable results and metrics
- Improve keyword integration for ATS
- Restructure sections for better impact
- Add missing relevant information

**Minor Enhancements** (polish and refine):
- Strengthen action verbs
- Improve consistency in formatting
- Optimize white space
- Refine professional summary
- Reorder bullets for impact

### Step 3: Reference Guidance

Consult relevant reference materials based on issues identified:

**For content improvements:** `references/best-practices.md`
- Achievement-oriented language
- STAR method for accomplishments
- Section-specific guidance
- Common mistakes to avoid

**For ATS issues:** `references/ats-optimization.md`
- Formatting requirements
- Keyword optimization
- Common ATS pitfalls
- Testing approaches

**For industry/stage alignment:** `references/industry-career-guidance.md`
- Career stage strategies
- Industry-specific guidance
- Appropriate emphasis and language

### Step 4: Provide Structured Feedback

Organize feedback clearly:

**Summary Assessment:**
- Overall strengths of current resume
- Key areas for improvement
- Priority of changes (critical, major, minor)

**Specific Recommendations:**
For each section, provide:
- What works well
- What needs improvement
- Specific suggestions with examples
- Revised versions of weak bullets

**Example Feedback Structure:**

```
**Professional Summary:**
Current: [Show current text]
Issue: Generic and lacks specific value proposition
Revised: [Provide improved version with explanation]

**Experience Section:**
Bullet Analysis:
❌ Current: "Responsible for managing social media accounts"
Issue: Duty-oriented, not achievement-focused, lacks metrics
✅ Revised: "Grew Instagram following from 2K to 45K in 8 months through targeted content strategy and influencer partnerships, increasing engagement rate by 300%"
```

### Step 5: Create Revised Version

If requested, create a fully revised resume:

1. Maintain user's core information and experiences
2. Apply all recommended improvements
3. Ensure ATS compliance
4. Optimize for target role (if specified)
5. Use appropriate template format
6. Deliver in professional docx format

## Tailoring Resumes for Specific Jobs

Use this workflow when customizing a resume for a particular job application.

### Step 1: Analyze Job Description

Extract key information from job description:

**Required Qualifications:**
- Must-have skills and experience
- Required certifications or education
- Years of experience specified
- Technical requirements

**Preferred Qualifications:**
- Nice-to-have skills
- Additional certifications
- Preferred background

**Keywords and Terminology:**
- Technical terms and tools
- Industry-specific language
- Action verbs used
- Acronyms and spelled-out versions
- Job title variations

**Company Culture and Values:**
- Language used in description
- Emphasized qualities
- Company information

### Step 2: Reference ATS Optimization

Consult `references/ats-optimization.md` for:

**Keyword Extraction Strategies:**
- How to identify priority keywords
- Where to place keywords strategically
- How to use variations (acronyms + full terms)
- Natural integration techniques

**Customization Approach:**
- Updating professional summary
- Reordering experience bullets
- Adjusting skills section
- Adding relevant context

### Step 3: Create Tailored Version

Customize the resume strategically:

**Professional Summary:**
- Mirror language from job description
- Highlight 2-3 top matching qualifications
- Include years of experience if specified in JD
- Use job title or aspirational variation

**Skills Section:**
- Lead with most relevant skills for position
- Include all mentioned technologies/tools from JD
- Use exact phrasing from job description
- Include both acronyms and spelled-out versions

**Experience Section:**
- Reorder bullets to emphasize relevant achievements
- Add context where needed to show skill matches
- Integrate job description keywords naturally
- Quantify achievements that align with role requirements

**Additional Sections:**
- Emphasize certifications mentioned in JD
- Highlight relevant projects
- Include any specified requirements

### Step 4: Verify Keyword Coverage

Ensure comprehensive alignment:

- [ ] All major required skills appear in resume
- [ ] Keywords used multiple times naturally
- [ ] Both technical and soft skills addressed (if in JD)
- [ ] Industry-specific terminology included
- [ ] Job title variations incorporated
- [ ] No keyword stuffing (maintains readability)

### Step 5: Balance ATS and Human Appeal

Remember: ATS gets resume through door, humans make decisions.

**Ensure Resume:**
- Passes ATS parsing and ranking
- Reads naturally and compellingly
- Tells coherent career story
- Showcases qualifications effectively
- Maintains professional appearance
- Would impress human recruiters

## General Resume Consultation

For general questions or guidance:

**Consult Reference Materials:**
- `references/best-practices.md` - Comprehensive guidance on content and format
- `references/ats-optimization.md` - ATS compliance and optimization
- `references/industry-career-guidance.md` - Industry and career stage specifics

**Provide Specific, Actionable Advice:**
- Reference relevant sections from documentation
- Give concrete examples
- Explain reasoning behind recommendations
- Offer alternatives when applicable

## Resources

### References

**best-practices.md**
Comprehensive resume writing guidance covering core principles, format standards, section-specific guidance, common mistakes, tailoring strategies, and proofreading checklist.

**ats-optimization.md**
Complete ATS optimization guide including how ATS works, formatting requirements, keyword optimization, common pitfalls, testing approaches, and industry-specific considerations.

**industry-career-guidance.md**
Specialized guidance for different career stages, industries, global considerations, and remote work experience presentation.

### Templates

**template-chronological.md**
Standard chronological format for traditional career progression.

**template-functional.md**
Skills-based format for career changers and non-traditional paths.

**template-combination.md**
Hybrid format balancing skills and chronological experience.

**template-entry-level.md**
Specialized format for recent graduates and early-career professionals.

## Best Practices for Using This Skill

**Always:**
- Read relevant reference documentation before writing
- Choose appropriate template for user's situation
- Apply ATS optimization principles
- Quantify achievements with metrics
- Use strong action verbs
- Maintain consistent formatting
- Proofread thoroughly

**Never:**
- Use generic, template-like language
- Include obvious soft skills without context
- Create overly long resumes (>2 pages without strong justification)
- Use complex formatting that breaks ATS parsing
- Ignore job description when provided
- Include personal information inappropriate for region (photos in US, age, marital status)

**Remember:**
- Every resume should be tailored to the target role
- Quality over quantity in bullet points
- ATS compliance and human readability both matter
- Industry and career stage significantly impact approach
- Specific, measurable achievements are most compelling
- Professional appearance matters

## Output Format

Always deliver resumes as professional docx files:

1. Use standard business formatting
2. Ensure consistent styling throughout
3. Apply appropriate fonts (Calibri, Arial, or similar)
4. Include proper spacing and margins
5. Save as .docx format
6. Provide clear file naming: FirstName_LastName_Resume.docx

When providing feedback or examples, use clear formatting with:
- ❌ to indicate weak examples or current issues
- ✅ to indicate strong examples or improvements
- Bold for emphasis on key changes
- Bullet points for organized feedback
