# Terminology Standards

Standard vocabulary and style guidelines for skill documentation.

## Proper Nouns

### Claude
- **Correct**: Claude (always capitalized)
- **Incorrect**: claude, CLAUDE
- **Usage**: "Claude can use this script to..." ✅

### File Names
- **SKILL.md**: Always all caps when referring to the filename
- **README.md**: All caps
- **Other files**: Use exact casing (e.g., `analyze_skill.py`, `REFERENCE.md`)

## Writing Style

### Imperative Form
Documentation should use imperative/infinitive verb forms:

**Examples:**
- ✅ "Use this tool to analyze PDFs"
- ✅ "Run the script with these arguments"
- ✅ "Read the reference file for details"
- ❌ "You should use this tool"
- ❌ "Users can run the script"
- ❌ "This allows you to analyze"

### Active Voice
Prefer active over passive voice:
- ✅ "The script generates reports"
- ❌ "Reports are generated by the script"

### Direct Instructions
Be clear and direct:
- ✅ "Install dependencies: `pip install pandas`"
- ❌ "You might want to consider installing dependencies"

## Common Terms

### Skill Components

**Skill**: The complete package
- "This skill provides PDF manipulation tools"

**SKILL.md**: The main documentation file
- "See SKILL.md for complete instructions"

**Resources**: Bundled files (scripts/references/assets)
- "The skill includes resources for common tasks"

**Script**: Executable code in scripts/
- "Run the analyze.py script"

**Reference**: Documentation in references/
- "Consult the API reference for details"

**Asset**: Templates, images, etc. in assets/
- "Use the template asset as a starting point"

### Actions

| Preferred | Avoid |
|-----------|-------|
| Use | Utilize |
| Run | Execute |
| Create | Generate (when making from scratch) |
| Read | Consult, Review |
| Install | Set up |
| Configure | Set up |

### Tool References

**Scripts**:
- "Run `script_name.py`" (with backticks)
- "Execute the analysis script"

**Commands**:
- Use code formatting: `python script.py`
- Include full command when helpful: `python analyze.py input.pdf`

**File paths**:
- Use relative paths from skill root
- Format with backticks: `scripts/analyze.py`
- Or as code: `./scripts/analyze.py`

## Technical Terms

### File Formats
- Use standard extensions with dot: `.pdf`, `.docx`, `.md`
- Pluralize appropriately: "PDFs", "Excel files", "documents"

### Programming
- **Function**: lowercase when referring to concept
- **Method**: lowercase
- **Class**: capitalize when specific: "Use the `Document` class"
- **Module**: lowercase: "the pandas module"

### Skill-Specific Terms

**Workflow**: A multi-step process
- "Follow the redlining workflow"

**Pattern**: A reusable approach
- "Use the template pattern"

**Tool**: A script or utility
- "This tool extracts metadata"

**Example**: Code demonstration
- "See Example 1 for basic usage"

## Phrases to Avoid

### Uncertain Language
- ❌ "might", "maybe", "possibly"
- ✅ Be definitive or provide alternatives

### Redundancy
- ❌ "In order to" → ✅ "To"
- ❌ "It is recommended that you" → ✅ "Use" / "Recommend"
- ❌ "This allows you to" → ✅ "Use this to"

### Second Person
- ❌ "You should"
- ❌ "You can"
- ❌ "You will"
- ❌ "You need to"
- ✅ "Use", "Run", "Create", "Read"

### Passive Voice
- ❌ "The file is processed by"
- ✅ "The script processes"

### Vague Terms
- ❌ "various", "multiple", "different", "some"
- ✅ Be specific: "three methods", "PDF and DOCX formats"

## Documentation Sections

Standard section names to use:

- **Overview**: High-level introduction
- **Quick Start**: Minimal example to get started
- **Usage**: Detailed instructions
- **Examples**: Concrete demonstrations
- **Reference**: Detailed specifications
- **Workflow**: Step-by-step processes
- **API**: Programming interface
- **Configuration**: Setup options

## Formatting Conventions

### Headers
Use title case for headers:
- ✅ "Creating New Documents"
- ❌ "creating new documents"

### Lists
- Use bullets for unordered items
- Use numbers for sequential steps
- Keep items parallel in structure

### Code Blocks
Always specify language:
```python
# ✅ Good - language specified
code here
```

```
# ❌ Avoid - no language tag
code here
```

### Emphasis
- **Bold** for UI elements, important terms, file names
- *Italic* for emphasis (use sparingly)
- `Code formatting` for code, commands, file paths

## Consistency Checklist

When writing skill documentation:

- [ ] Use imperative verb forms
- [ ] Capitalize "Claude" properly
- [ ] Format file names correctly (SKILL.md, README.md)
- [ ] Use active voice
- [ ] Be specific, not vague
- [ ] Include code language tags
- [ ] Use relative file paths
- [ ] Follow standard section names
- [ ] Avoid second person ("you")
- [ ] Maintain consistent terminology
