# 使用示例 (Example Usage)

## 示例 1: 复杂需求（使用并行探索和并行深度审查）

**用户**: "我需要一个用户活动跟踪功能来记录用户操作，支持多租户隔离和实时分析"

**使用本技能的助手**：

1. **阶段 1 - 需求理解**：判断为复杂需求（涉及多租户、实时分析），**使用 ultrathink** 分析需求

2. **阶段 2 - 代码库探索（并行模式）**：
   - **并行启动 3 个 Explore agent**（在一个message中）：
     - Agent 1: 探索数据模型和多租户架构
     - Agent 2: 探索服务层的日志/审计功能实现
     - Agent 3: 探索API控制器和实时通信机制
   - 汇总3个agent的探索结果

3. **阶段 2.5 - 外部资源研究**：
   - 使用 context7 查询实时分析库（如 Redis、InfluxDB）的最新文档
   - 使用网页搜索查找多租户活动跟踪的最佳实践和代码示例

4. **阶段 3 - 澄清问题**："应该跟踪哪些类型的操作？数据保留策略是什么？"

5. **阶段 4 - 深度分析**：**使用 ultrathink** 设计架构和实施方案（遵循 CLAUDE.md 规范）

6. **阶段 5 - 展示计划**：显示完整计划，包括实体设计、API 端点、实施步骤

7. **等待确认**：在开始编码之前获得用户确认

8. **阶段 6 - 实施开发**：按照计划逐步实施功能（修改了 8 个文件）

9. **阶段 7 - 代码审查（并行深度审查模式）**：
   - **并行启动 5 个审查任务**（在一个message中）：
     - Reviewer 1: 聚焦于功能正确性
     - Reviewer 2: 聚焦于代码风格和质量
     - Reviewer 3: 聚焦于简洁性/DRY/优雅性
     - Reviewer 4: 聚焦于项目规范遵循
     - Reviewer 5: 聚焦于项目约定和抽象
   - 汇总所有审查结果，向用户展示报告
   - 使用 **AskUserQuestion** 询问用户如何处理发现的问题
   - 根据用户选择进行修复

---

## 示例 2: 简单需求（使用单一模式）

**用户**: "给用户表添加一个手机号字段"

**使用本技能的助手**：

1. **阶段 1 - 需求理解**：判断为简单需求（单一字段添加），**跳过此阶段的 ultrathink**

2. **阶段 2 - 代码库探索（基础模式）**：
   - 使用单个 Explore agent 查找用户实体定义和相关迁移文件

3. **阶段 2.5 - 外部资源研究**：跳过（不需要外部资源）

4. **阶段 3 - 澄清问题**："手机号是否需要验证？是否允许为空？"

5. **阶段 4 - 深度分析**：**使用 ultrathink** 考虑字段类型、验证规则、索引等（遵循 CLAUDE.md 规范）

6. **阶段 5 - 展示计划**：显示完整计划

7. **等待确认**：获得确认

8. **阶段 6 - 实施开发**：添加字段、迁移和验证逻辑（修改了 2-3 个文件）

9. **阶段 7 - 代码审查（单一审查模式）**：
   - 使用单个 code-reviewer agent 进行全面审查
   - 向用户展示审查报告
   - 使用 **AskUserQuestion** 询问用户如何处理发现的问题
   - 根据用户选择进行修复（如需）

---

## 示例 3: 使用第三方库的需求（重点使用 context7）

**用户**: "使用 Socket.io 实现实时通知功能"

**使用本技能的助手**：

1. **阶段 1 - 需求理解**：识别需要使用 Socket.io 库

2. **阶段 2 - 代码库探索**：查找项目中是否已有 WebSocket 或实时通信相关代码

3. **阶段 2.5 - 外部资源研究**：
   - 使用 context7 查询 Socket.io 最新文档：
     - resolve-library-id: libraryName="socket.io", query="使用 Socket.io 实现实时通知功能"
     - query-docs: libraryId="/socket.io/socket.io", query="server setup and events handling"
   - 如果 context7 不可用，降级到 WebSearch 搜索官方文档

4. **阶段 3 - 澄清问题**："需要支持哪些类型的通知？是否需要通知历史记录？"

5. **阶段 4 - 深度分析**：基于 Socket.io 最新 API 设计实现方案

6. **阶段 5 - 展示计划**：展示集成 Socket.io 的完整计划

7. **等待确认**：获得确认

8. **阶段 6 - 实施开发**：按计划实施

9. **阶段 7 - 代码审查**：确保正确使用 Socket.io API 和最佳实践
