# 输出格式模板 (Output Format Template)

## 阶段 1-5: 分析和计划阶段

```markdown
## 🎯 需求理解
- [我理解的要点列表]

## 🔍 代码库探索结果
- **CLAUDE.md 规范**: [项目规范的关键要点 - 命名约定、架构模式、编码规范等]
- **发现**: [相关的现有代码]
- **模式**: [要遵循的约定]

## 🌐 外部资源研究（如适用）

### 网页搜索结果
- **搜索主题**: [搜索的具体问题或技术]
- **关键发现**: [从搜索结果中提取的有价值信息]
- **代码示例**: [相关的代码片段或实现方案]
- **最佳实践**: [行业标准做法或推荐模式]

### 库文档查询结果
- **查询的库**: [库名称和版本]
- **相关 API**: [查询到的 API 和方法]
- **官方示例**: [官方文档中的代码示例]
- **注意事项**: [使用限制、已知问题等]

## ❓ 需要澄清的问题
[AskUserQuestion 工具结果 或 "无疑问 - 需求很清楚"]

## 🧠 深度分析 (使用 ultrathink)
[Sequential Thinking 顺序思考结果 - 技术设计决策，必须体现如何遵循 CLAUDE.md 规范]

## 📋 实施计划

### 数据库设计
[实体定义 - 遵循 CLAUDE.md 中的命名和字段规范]

### API 端点
[带方法和路径的端点列表 - 遵循 CLAUDE.md 中的 API 设计规范]

### Service 层
[服务方法签名和逻辑流程 - 遵循 CLAUDE.md 中的架构模式]

### 实施步骤
[编号的步骤列表 - 确保每步符合项目规范]

### 风险和注意事项
[需要注意的潜在问题]

### 规范遵循检查
- [ ] 数据库设计符合 CLAUDE.md 规范
- [ ] API 端点符合 CLAUDE.md 规范
- [ ] 代码结构符合 CLAUDE.md 规范
- [ ] 命名约定符合 CLAUDE.md 规范

## ✅ 准备好继续了吗？
这个计划看起来如何？我可以开始实施了吗？
```

---

## 阶段 7: 代码审查阶段

```markdown
## 🔍 代码审查结果

### 审查模式
- 使用模式: [单一审查 / 并行深度审查]
- 审查文件数: [数量]
- 审查时间: [时间]

### 审查概要
- **高严重性问题**: [数量] 个 🔴
- **中严重性问题**: [数量] 个 🟡
- **低严重性问题**: [数量] 个 🟢
- **整体评价**: [优秀 / 良好 / 需要改进 / 存在严重问题]

### 详细审查结果

#### 1. 功能正确性 ✅/⚠️/❌
[来自 Reviewer 1 的详细发现]
- 发现的问题（如有）
- 具体位置和描述
- 严重性评级

#### 2. 代码风格和质量 ✅/⚠️/❌
[来自 Reviewer 2 的详细发现]
- 发现的问题（如有）
- 具体位置和描述
- 改进建议

#### 3. 简洁性/DRY/优雅性 ✅/⚠️/❌
[来自 Reviewer 3 的详细发现]
- 重复代码位置（如有）
- 过度/不足抽象（如有）
- 重构建议

#### 4. 项目规范遵循 ✅/⚠️/❌
[来自 Reviewer 4 的详细发现]
- 规范违反项（如有）
- 不符合 CLAUDE.md 的地方
- 需要调整的部分

#### 5. 项目约定和抽象 ✅/⚠️/❌
[来自 Reviewer 5 的详细发现]
- 未使用已有工具/模式的地方（如有）
- 不合理的新抽象（如有）
- 改进建议

### 高严重性问题清单（需优先修复）
1. [问题1 - 文件:行号 - 描述]
2. [问题2 - 文件:行号 - 描述]
...

### 中严重性问题清单
1. [问题1]
2. [问题2]
...

### 低严重性问题和优化建议
1. [建议1]
2. [建议2]
...
```

**重要提醒**：
- ⚠️ 如果发现**严重Bug**、**安全漏洞**或**数据丢失风险**，必须在报告中明确标注为"关键问题"
- ⚠️ 关键问题必须强烈建议用户立即修复
- ✅ 对于代码风格、优化建议等低优先级问题，说明这些是可选的改进
