# 并行模式指南 (Parallel Patterns Guide)

## 核心技术要求

> ⚠️ **关键规则**：必须在单个 message 中发起所有并行任务。不能发送一个message调用Task，等待结果，再发送另一个message调用另一个Task。必须在同一个response中同时调用多个Task工具。

---

## 阶段 2: 并行探索模式

### 何时使用并行探索

满足以下任一条件时使用：
- ✅ 需求涉及**多个架构层次**（数据层、服务层、API层等）
- ✅ 需求涉及**多个模块或子系统**
- ✅ 探索任务可以**清晰分解为独立的子任务**
- ✅ 需要**节省时间**，提高探索效率

### 策略 1：按架构层次分解

同时启动 3 个 Explore agent（在一个 message 中）：

```
Agent 1 - 数据层探索：
- subagent_type: Explore
- prompt: "探索 [需求相关] 的数据模型、实体定义、数据库表结构和迁移文件"

Agent 2 - 服务层探索：
- subagent_type: Explore
- prompt: "探索 [需求相关] 的业务逻辑、服务类、验证规则和错误处理"

Agent 3 - API层探索：
- subagent_type: Explore
- prompt: "探索 [需求相关] 的控制器、路由定义、请求/响应结构和中间件"
```

### 策略 2：按功能模块分解

同时启动 2-3 个 Explore agent（在一个 message 中）：

```
Agent 1 - 核心功能模块：
- subagent_type: Explore
- prompt: "探索 [核心模块名] 的完整实现，包括所有层次"

Agent 2 - 关联功能模块：
- subagent_type: Explore
- prompt: "探索与 [核心模块] 集成的 [关联模块] 的实现方式"

Agent 3 - 通用工具和模式：
- subagent_type: Explore
- prompt: "探索项目中可复用的工具类、辅助函数和通用模式"
```

### 策略 3：按关注点分解

同时启动 2-4 个 Explore agent（在一个 message 中）：

```
Agent 1 - 现有实现：
- prompt: "查找 [功能] 的现有实现和类似功能"

Agent 2 - 错误处理模式：
- prompt: "探索项目中的错误处理、异常捕获和日志记录模式"

Agent 3 - 测试用例：
- prompt: "查找相关功能的测试文件和测试模式"

Agent 4 - 配置和常量：
- prompt: "探索项目的配置文件、环境变量和常量定义"
```

### 并行数量建议

- 简单需求：1 个 agent（使用基础探索模式）
- 中等需求：2-3 个 agent
- 复杂需求：3-5 个 agent
- ⚠️ 不建议超过 5 个并行任务，避免过度复杂化

### 结果汇总

- 等待所有并行 agent 完成
- 整合各个 agent 的发现
- 识别重复信息并去重
- 组织成结构化的探索报告
- 重点标注需要遵循的模式和约定

---

## 阶段 7: 并行深度审查模式

### 何时使用并行深度审查

满足以下任一条件时使用：
- ✅ 复杂需求，修改文件多（4+ 个文件）
- ✅ 涉及多个架构层次或模块
- ✅ 需要**深度审查**，确保高质量
- ✅ 代码改动较大或引入新的抽象

### 并行审查策略

同时启动 **5 个并行审查任务**（在一个 message 中），每个聚焦于特定维度：

```
Reviewer 1 - 功能正确性审查：
- subagent_type: feat-dev:code-reviewer
- prompt: "聚焦于功能正确性，审查 [文件列表]：
  - 检查逻辑错误和潜在 Bug
  - 验证边缘情况处理
  - 检查错误处理是否完善
  - 验证数据验证是否充分
  只关注功能正确性，提供详细分析。"

Reviewer 2 - 代码风格和质量审查：
- subagent_type: feat-dev:code-reviewer
- prompt: "聚焦于代码风格和质量，审查 [文件列表]：
  - 检查命名是否清晰一致
  - 验证注释是否适当
  - 评估代码可读性
  - 检查函数和类的职责是否单一
  只关注代码风格和质量，提供详细建议。"

Reviewer 3 - 简洁性/DRY/优雅性审查：
- subagent_type: feat-dev:code-reviewer
- prompt: "聚焦于简洁性/DRY/优雅性，审查 [文件列表]：
  - 识别重复代码（DRY 原则）
  - 评估抽象是否恰当
  - 检查是否有不必要的复杂性
  - 评估代码是否优雅简洁
  只关注简洁性和优雅性，提供重构建议。"

Reviewer 4 - 项目规范遵循审查：
- subagent_type: feat-dev:code-reviewer
- prompt: "聚焦于项目规范遵循，审查 [文件列表]：
  - 验证是否符合 CLAUDE.md 编码规范
  - 检查文件结构是否符合项目约定
  - 验证 API 设计是否符合项目标准
  - 检查数据库设计是否符合命名约定
  只关注规范遵循，列出所有违规项。"

Reviewer 5 - 项目约定和抽象审查：
- subagent_type: feat-dev:code-reviewer
- prompt: "聚焦于项目约定和抽象，审查 [文件列表]：
  - 检查是否使用了项目已有工具和模式
  - 验证是否遵循项目架构模式
  - 检查是否复用了现有抽象和组件
  - 评估新增抽象是否合理且必要
  只关注约定和抽象使用，提供改进建议。"
```

### 结果汇总和报告

1. 等待所有 5 个并行审查完成
2. 整合所有审查结果
3. 按严重性分类问题（高、中、低）
4. 组织成结构化的审查报告
5. 准备向用户展示
