# CLI Development Best Practices Checklist

## 設計段階

### コマンド設計
- [ ] Do One Thing Well の原則に従う
- [ ] コマンド名は動詞ベース（create, list, delete）
- [ ] サブコマンドは適切に分割
- [ ] 一貫性のあるコマンド構造

### 引数とオプション
- [ ] 必須引数は位置引数として定義
- [ ] オプション引数にはデフォルト値を提供
- [ ] 短縮形（-v）と長形式（--verbose）の両方を提供
- [ ] --help と --version オプションを実装
- [ ] 排他的オプションの適切な処理

### 出力設計
- [ ] 成功時は静か（Silent Success）
- [ ] stdout にデータ、stderr にメッセージ
- [ ] --format オプションで機械可読形式（JSON/CSV）をサポート
- [ ] TTY 判定でカラー出力を制御
- [ ] --no-color オプションを提供

## 実装段階

### アーキテクチャ
- [ ] レイヤード構造（CLI / Core / Infrastructure）
- [ ] 依存性注入を使用
- [ ] ビジネスロジックを CLI レイヤーから分離
- [ ] テスト可能な設計

### エラーハンドリング
- [ ] 適切なエラーメッセージ（What, Why, How）
- [ ] 適切な終了コード（0: 成功、1: ユーザーエラー、2: システムエラー）
- [ ] グローバルエラーハンドラーの実装
- [ ] エラーからのリカバリー機構

### 設定管理
- [ ] 設定ファイルのサポート（.config.json, pyproject.toml など）
- [ ] 環境変数のサポート
- [ ] 設定の優先順位を明確化（CLI > 環境変数 > 設定ファイル > デフォルト）
- [ ] --config オプションで設定ファイルパスを指定可能

### ユーザビリティ
- [ ] プログレスバー/スピナーで進捗表示
- [ ] インタラクティブプロンプトの実装
- [ ] 破壊的操作には確認プロンプト
- [ ] --force フラグで確認スキップ可能
- [ ] --dry-run オプションの提供

### パフォーマンス
- [ ] 起動時間が 1 秒以内
- [ ] 不要な依存関係の削除
- [ ] 遅延読み込みの活用
- [ ] 並列処理の活用

## テスト段階

### テストカバレッジ
- [ ] ユニットテストのカバレッジ 80% 以上
- [ ] 統合テストの実装
- [ ] E2E テストの実装（重要な機能）
- [ ] エラーケースのテスト

### テストの種類
- [ ] コマンド引数のバリデーションテスト
- [ ] 各コマンドの正常系テスト
- [ ] エラーハンドリングのテスト
- [ ] ヘルプ出力のスナップショットテスト
- [ ] インタラクティブプロンプトのテスト

## 配布段階

### パッケージング
- [ ] package.json / pyproject.toml / go.mod の適切な設定
- [ ] bin / console_scripts の設定
- [ ] README.md の作成（使用例、インストール方法）
- [ ] LICENSE ファイルの追加
- [ ] CHANGELOG.md の作成

### ドキュメント
- [ ] --help の充実したヘルプメッセージ
- [ ] 使用例の提供
- [ ] エラーメッセージにサジェスト機能
- [ ] オンラインドキュメントの作成

### バージョン管理
- [ ] Semantic Versioning の遵守
- [ ] Conventional Commits の使用
- [ ] CHANGELOG の自動生成
- [ ] Git タグの適切な使用

### 配布方法
- [ ] npm / PyPI への公開
- [ ] GitHub Releases の作成
- [ ] バイナリ配布（必要に応じて）
- [ ] Homebrew Formula の作成（必要に応じて）

### CI/CD
- [ ] 自動テストの実行
- [ ] 自動ビルド
- [ ] 自動公開（タグプッシュ時）
- [ ] クロスプラットフォームビルド

## 保守段階

### 更新機構
- [ ] 自動更新チェック機能
- [ ] セルフアップデート機能（オプション）
- [ ] 破壊的変更の適切な告知

### ログとデバッグ
- [ ] --verbose フラグでデバッグログ
- [ ] --debug フラグの提供
- [ ] ログレベルの制御
- [ ] エラー時のスタックトレース

### セキュリティ
- [ ] 依存関係の定期的な更新
- [ ] セキュリティ脆弱性のスキャン
- [ ] 機密情報の適切な取り扱い
- [ ] .env ファイルの .gitignore への追加

## プラットフォーム別チェックリスト

### Node.js
- [ ] package.json の bin フィールド
- [ ] Shebang (`#!/usr/bin/env node`)
- [ ] 適切な Node.js バージョン指定（engines）
- [ ] TypeScript の使用（推奨）

### Python
- [ ] entry_points の設定
- [ ] python_requires の指定
- [ ] 仮想環境の使用
- [ ] 型ヒントの使用（推奨）

### Go
- [ ] go.mod の適切な設定
- [ ] クロスコンパイル対応
- [ ] バイナリサイズの最適化
- [ ] Go modules の使用

## アクセシビリティ

- [ ] カラーブラインド対応（カラーだけに依存しない）
- [ ] 音声読み上げソフトウェア対応
- [ ] キーボードのみで操作可能
- [ ] 多言語対応（必要に応じて）

## 品質メトリクス

### コード品質
- [ ] リンターのエラーゼロ
- [ ] 型チェックのエラーゼロ
- [ ] 循環的複雑度が低い
- [ ] 適切なコメント

### ユーザビリティメトリクス
- [ ] インストール時間 < 30秒
- [ ] 起動時間 < 1秒
- [ ] ヘルプメッセージの理解しやすさ
- [ ] エラーメッセージの明確さ

### パフォーマンスメトリクス
- [ ] メモリ使用量の最適化
- [ ] CPU 使用率の最適化
- [ ] ネットワークリクエストの最小化
- [ ] キャッシュの活用

---

## 使用方法

このチェックリストを使って、CLI 開発の各段階で必要な項目を確認してください。

### 段階別の使用

1. **設計段階**: コマンド設計、引数設計を確認
2. **実装段階**: アーキテクチャ、エラーハンドリングを確認
3. **テスト段階**: テストカバレッジ、テストの種類を確認
4. **配布段階**: パッケージング、ドキュメント、配布方法を確認
5. **保守段階**: 更新機構、ログ、セキュリティを確認

### プロジェクトテンプレートとの連携

各テンプレート（Python Typer、Node.js Commander、Go Cobra）は、このチェックリストの項目の多くを既に実装しています。

---

*このチェックリストを使って、プロフェッショナルな CLI ツールを構築しましょう。*
