# Pull Request Template

## 概要
<!-- このPRで何を達成するか（1-2文で簡潔に） -->



## 変更の背景
<!-- なぜこの変更が必要か -->

### 問題
<!-- 現在の問題点 -->

### 解決策
<!-- このPRでどのように解決するか -->



## 変更内容
<!-- 主な変更点をリスト形式で記載 -->

- ✨ 新機能:
- 🐛 バグ修正:
- ♻️  リファクタリング:
- ⚡ パフォーマンス改善:
- 📝 ドキュメント:
- ✅ テスト:



## 種類
<!-- 該当するものにチェック -->

- [ ] 新機能 (feature)
- [ ] バグ修正 (bugfix)
- [ ] リファクタリング (refactor)
- [ ] パフォーマンス改善 (performance)
- [ ] ドキュメント更新 (docs)
- [ ] テスト追加/更新 (test)
- [ ] ビルド/CI設定 (build/ci)
- [ ] その他:



## テスト

### ユニットテスト
- [ ] 新規テスト追加
- [ ] 既存テスト更新
- [ ] カバレッジ維持/向上（現在: __%）

### 統合テスト
- [ ] 統合テスト追加
- [ ] エンドツーエンドテスト追加

### 手動テスト
- [ ] 正常系動作確認
- [ ] エラーケース確認
- [ ] 境界値テスト
- [ ] 後方互換性確認

### テスト環境
- OS:
- ブラウザ:
- デバイス:



## スクリーンショット/動画
<!-- UI変更がある場合、Before/Afterを添付 -->

### Before


### After




## パフォーマンス影響
<!-- パフォーマンスに影響がある場合 -->

| 指標 | Before | After | 改善率 |
|------|--------|-------|-------|
|      |        |       |       |



## Breaking Changes
<!-- 破壊的変更の有無 -->

- [ ] **なし**
- [ ] **あり** - 詳細を以下に記載:

<!-- Breaking Changesがある場合の詳細 -->




## マイグレーション
<!-- データベース変更がある場合 -->

- [ ] マイグレーションファイル追加
- [ ] ロールバック手順確認
- [ ] マイグレーション手順ドキュメント更新

### マイグレーションコマンド
```bash
# マイグレーション実行
npm run migrate:up

# ロールバック
npm run migrate:down
```



## デプロイメント
<!-- 特別なデプロイ手順がある場合 -->

- [ ] 通常デプロイ
- [ ] 環境変数追加/変更
- [ ] 設定ファイル変更
- [ ] インフラ変更
- [ ] サードパーティサービス設定

### 環境変数
```bash
# 追加する環境変数
NEW_ENV_VAR=value
```

### デプロイ順序
<!-- 特別な順序が必要な場合 -->
1.
2.
3.



## 関連
<!-- 関連Issue、PR、ドキュメント -->

- Closes #
- Fixes #
- Related to #
- Depends on #
- Blocks #
- Documentation:



## レビュー観点
<!-- レビュワーに特に見てほしいポイント -->

- [ ]
- [ ]
- [ ]



## セキュリティ
<!-- セキュリティに関する考慮事項 -->

- [ ] 入力バリデーション実装
- [ ] SQLインジェクション対策
- [ ] XSS対策
- [ ] CSRF対策
- [ ] 認証・認可チェック
- [ ] 機密情報の適切な扱い
- [ ] セキュリティスキャン実施



## アクセシビリティ
<!-- アクセシビリティへの配慮 -->

- [ ] セマンティックHTML使用
- [ ] ARIA属性適切に設定
- [ ] キーボード操作可能
- [ ] スクリーンリーダー対応
- [ ] カラーコントラスト比確保



## パフォーマンス考慮
<!-- パフォーマンスへの配慮 -->

- [ ] N+1クエリ回避
- [ ] キャッシュ活用
- [ ] 不要な計算削減
- [ ] 遅延ロード実装
- [ ] バンドルサイズ影響確認



## ドキュメント
<!-- ドキュメント更新 -->

- [ ] README更新
- [ ] APIドキュメント更新
- [ ] CHANGELOG更新
- [ ] インラインコメント追加
- [ ] アーキテクチャ図更新



## セルフレビューチェックリスト
<!-- PR作成前に自分で確認 -->

### コード品質
- [ ] コードを自分でレビューした
- [ ] 命名が適切
- [ ] デバッグコード削除（console.log等）
- [ ] TODOコメント整理
- [ ] コメントが適切
- [ ] 重複コード削除

### テスト
- [ ] テストを追加した
- [ ] 全てのテストが通過
- [ ] エッジケースをテスト
- [ ] カバレッジ低下なし

### ドキュメント
- [ ] ドキュメントを更新した
- [ ] Breaking changesを明記
- [ ] マイグレーション手順を記載

### CI/CD
- [ ] Lintエラーなし
- [ ] 型エラーなし
- [ ] ビルドが通る
- [ ] CI/CDが全て成功



## レビュワーへのメッセージ
<!-- レビュワーへの追加情報やお願い -->



---

## チェックリスト（レビュワー用）
<!-- レビュワーがチェックする項目 -->

### 機能性
- [ ] 要件を満たしている
- [ ] エッジケースが考慮されている
- [ ] エラーハンドリングが適切

### コード品質
- [ ] 可読性が高い
- [ ] 適切な設計パターン
- [ ] SOLID原則に従っている

### セキュリティ
- [ ] セキュリティ脆弱性がない
- [ ] 入力バリデーション実装
- [ ] 認証・認可が適切

### パフォーマンス
- [ ] パフォーマンス問題がない
- [ ] N+1クエリがない
- [ ] 適切なキャッシュ戦略

### テスト
- [ ] テストが十分
- [ ] カバレッジが適切
- [ ] テストが失敗していない

### ドキュメント
- [ ] ドキュメントが更新されている
- [ ] コメントが適切
- [ ] APIドキュメント更新
