# Git Workflow Skill - 使い方

## このSkillについて

`git-workflow` Skillは、Git運用に関する全ての知識、手順、判断基準を集約したものです。

## 構成

```
git-workflow/
├── SKILL.md              # メインドキュメント（目次・概要）
├── README.md             # このファイル
├── guides/               # 詳細ガイド（10ファイル）
├── checklists/           # チェックリスト（4ファイル）
├── templates/            # テンプレート（3ファイル）
├── references/           # リファレンス（6ファイル）
├── incidents/            # 過去の問題事例
└── scripts/              # 自動化スクリプト
```

## Claudeはいつこのスキルを使うか

Claude Codeは以下の状況で自動的にこのSkillを参照します：

1. **ブランチ操作時**
   - 新しいブランチを作成する必要がある
   - ブランチ名の妥当性を判断する必要がある

2. **コミット作成時**
   - コミットメッセージのフォーマットを確認する
   - 適切なtypeを選択する

3. **PR管理時**
   - PRを作成する
   - PRレビューを実施する
   - マージ判断をする

4. **問題発生時**
   - コンフリクトが発生した
   - Gitコマンドでエラーが発生した
   - 操作を取り消したい

## 手動で使う場合

以下のような質問・依頼をすると、このSkillが活用されます：

```
「このプロジェクトに最適なブランチ戦略は？」
「コンフリクトを解決する方法を教えて」
「間違ったコミットを取り消したい」
「PRレビューのポイントは？」
```

## Agentとの連携

このSkillは以下のAgentsと連携して動作します：

### 自動実行されるAgent

- **commit-validator-agent**: コミット前に自動実行
- **pr-reviewer-agent**: PR作成時に自動実行

### 手動で呼び出すAgent

```
「pr-reviewer-agentを使ってこのPRをレビューして」
「conflict-resolver-agentでコンフリクト解決方法を提案して」
```

## ファイルの読み方

### SKILL.md（最初に読む）

- 全体の目次と概要
- クイックリファレンス
- 各ドキュメントへのリンク

### guides/（詳細を知りたいとき）

- 特定トピックの完全なガイド
- 例: `guides/07-conflict-resolution.md` でコンフリクト解決の全手順

### checklists/（実行前の確認）

- 作業前・作業後のチェック項目
- 例: `checklists/pre-commit.md` でコミット前の確認

### templates/（新規作成時）

- PR、コミットメッセージなどのテンプレート
- コピーして使用

### references/（困ったとき）

- ベストプラクティス、アンチパターン
- トラブルシューティング

### incidents/（過去の教訓）

- 実際に発生した問題と解決方法
- 同じ失敗を繰り返さないため

## カスタマイズ

このSkillをプロジェクト固有にカスタマイズする場合：

1. プロジェクトルートに `.claude/skills/git-workflow/` をコピー
2. プロジェクト固有のルールを追記
3. インシデント事例を追加していく

## 更新方法

新しい知見や失敗事例が発生したら：

1. 該当するガイドやリファレンスを更新
2. 必要に応じて `incidents/` に事例を追加
3. `SKILL.md` の更新履歴に記録

## 質問・改善提案

このSkillの改善提案は：

1. `incidents/` に「Skill自体の改善が必要だった事例」として記録
2. 定期的にレビューして Skill を進化させる
