# PR作成前チェックリスト

## 基本確認

### ブランチ状態
- [ ] ブランチ名が命名規則に従っている（`<type>/<ticket-id>-<description>`）
- [ ] mainブランチの最新変更を取り込んでいる
- [ ] コンフリクトが発生していない
- [ ] 不要なマージコミットがない

### コミット履歴
- [ ] 全てのコミットがConventional Commitsに準拠
- [ ] コミットが論理的に分割されている
- [ ] WIPコミットがない（または適切にsquash済み）
- [ ] コミットメッセージが明確

### CI/CD
- [ ] 全テストが通っている
- [ ] Lintエラーがない
- [ ] ビルドが成功している
- [ ] カバレッジが低下していない

## PR説明準備

### タイトル
- [ ] Conventional Commits形式（`feat(auth): add Google OAuth login`）
- [ ] 変更内容が一目でわかる
- [ ] 50文字以内

### 説明文
- [ ] 概要セクションを記載
- [ ] 変更理由（なぜ）を説明
- [ ] 変更内容（何を）をリストアップ
- [ ] テスト方法を記載
- [ ] スクリーンショット追加（UI変更の場合）
- [ ] 関連Issue番号を記載（Closes #123）

### レビュー観点
- [ ] レビュワーに確認してほしい点を明記
- [ ] 特に注意すべき変更をハイライト
- [ ] 技術的な判断の背景を説明

## コード品質

### 実装
- [ ] コードが読みやすい
- [ ] 変数・関数名が明確
- [ ] 適切にコメントが追加されている
- [ ] マジックナンバーが定数化されている
- [ ] エラーハンドリングが適切
- [ ] ログ出力が適切

### 設計
- [ ] アーキテクチャに従っている
- [ ] 責務が適切に分離されている
- [ ] 重複コードがない
- [ ] SOLID原則に違反していない
- [ ] 既存のパターンに従っている

### パフォーマンス
- [ ] 不要な計算の繰り返しがない
- [ ] メモリリークの可能性がない
- [ ] 非同期処理が適切
- [ ] N+1問題がない

## テスト

### テストカバレッジ
- [ ] 新機能にユニットテストを追加
- [ ] バグ修正に再現テストを追加
- [ ] エッジケースのテストを追加
- [ ] 統合テストを追加（必要に応じて）

### テスト品質
- [ ] テストが意味のあるテスト
- [ ] テストが独立している
- [ ] テストが高速
- [ ] テストが安定している（flaky testでない）

## セキュリティ

### コードセキュリティ
- [ ] 機密情報がハードコードされていない
- [ ] 入力値の検証がある
- [ ] SQLインジェクション対策がされている
- [ ] XSS対策がされている
- [ ] CSRF対策がされている（Web）

### 依存関係
- [ ] 脆弱性のある依存関係がない
- [ ] 不要な依存関係がない
- [ ] ライセンスが適切

## ドキュメント

### コードドキュメント
- [ ] 複雑なロジックにコメント追加
- [ ] 公開APIにドキュメントコメント追加
- [ ] TODOコメントが適切に管理されている

### プロジェクトドキュメント
- [ ] README更新（必要な場合）
- [ ] CHANGELOG更新（必要な場合）
- [ ] API仕様書更新（API変更の場合）
- [ ] アーキテクチャ図更新（設計変更の場合）

## 動作確認

### 機能確認
- [ ] ローカル環境で動作確認
- [ ] 正常系の動作確認
- [ ] 異常系の動作確認
- [ ] エラーメッセージが適切

### 環境別確認
- [ ] 開発環境で確認
- [ ] ステージング環境で確認（可能な場合）
- [ ] 複数のブラウザで確認（Web）
- [ ] 複数のデバイスで確認（モバイル）

## 破壊的変更

### Breaking Changes確認
- [ ] Breaking Changeがない、またはドキュメント化済み
- [ ] マイグレーションガイド作成（Breaking Changeの場合）
- [ ] 影響範囲を明確化
- [ ] チームに事前通知

## レビュー体制

### レビュワー
- [ ] 適切なレビュワーをアサイン
- [ ] 必要に応じて複数人をアサイン
- [ ] ドメインエキスパートを含める

### ラベル
- [ ] 適切なラベルを付与（feature/bugfix/enhancement等）
- [ ] 優先度ラベルを付与
- [ ] サイズラベルを付与（自動または手動）

## 規模確認

### PRサイズ
- [ ] 変更行数が400行以下（推奨）
- [ ] 変更ファイル数が20以下（推奨）
- [ ] 大きすぎる場合は分割を検討

## プロジェクト固有

### iOS
- [ ] Xcodeビルドが通る
- [ ] UIテストが通る（該当する場合）
- [ ] App Storeガイドラインに準拠
- [ ] プライバシーポリシー更新（必要な場合）

### React/TypeScript
- [ ] TypeScriptエラーがない
- [ ] ESLintエラーがない
- [ ] バンドルサイズが増えすぎていない
- [ ] アクセシビリティチェック

### Python
- [ ] mypyエラーがない
- [ ] flake8エラーがない
- [ ] requirements.txt更新（依存追加時）
- [ ] Dockerイメージビルド成功（該当する場合）

## 最終確認

- [ ] セルフレビュー完了（全ての変更を自分で確認）
- [ ] チェックリストの全項目を確認
- [ ] PR説明文が完成
- [ ] レビュー準備完了

---

## PR作成コマンド

```bash
# GitHubでPR作成（Web UI）
# または

# GitHub CLI
gh pr create --title "feat(auth): add Google OAuth" --body "$(cat PR_TEMPLATE.md)"

# 下書きPR作成
gh pr create --draft --title "WIP: feature implementation"

# Ready for Review に変更
gh pr ready

# 自動マージ設定
gh pr merge --auto --squash
```

---

## PR説明テンプレート

```markdown
## 概要
<!-- 変更内容を簡潔に（1-2行） -->

## 変更理由
<!-- なぜこの変更が必要か -->

## 変更内容
<!-- 具体的な変更点 -->
-
-

## 動作確認
- [ ] ローカル環境で動作確認
- [ ] テスト実行
- [ ] ビルド確認

## スクリーンショット
<!-- UI変更がある場合 -->

## レビュー観点
<!-- レビュワーに特に確認してほしい点 -->

## 関連Issue
Closes #XXX
```

---

**このチェックリストで高品質なPRを作成しましょう！**
