# Pull Request Template

## 📝 概要
<!-- 変更内容を簡潔に説明（1-2行） -->


## 🎯 変更理由
<!-- なぜこの変更が必要か -->


## 🔄 変更内容
<!-- 具体的な変更点を箇条書き -->
-
-
-

## 🧪 動作確認
<!-- どのようにテストしたか -->
- [ ] ローカル環境で動作確認
- [ ] 単体テスト実行（カバレッジ: XX%）
- [ ] 統合テスト実行
- [ ] E2Eテスト実行
- [ ] 実機での動作確認（iOS/Android）

## 📸 スクリーンショット
<!-- UI変更がある場合 -->
### Before
<!-- 変更前のスクリーンショット -->

### After
<!-- 変更後のスクリーンショット -->

## 🔍 レビュー観点
<!-- レビュワーに特に確認してほしい点 -->
-
-

## 📚 関連ドキュメント
<!-- 関連するドキュメント、仕様書等 -->
-

## ⚠️ 注意事項
<!-- デプロイ時の注意点、Breaking Changes等 -->
-

## 🔗 関連Issue
<!-- 関連するIssue番号 -->
Closes #XXX
Refs #YYY

---

## チェックリスト

### コード品質
- [ ] コードレビュー準備完了
- [ ] 全テスト通過
- [ ] Lint/Format適用済み
- [ ] デバッグコード削除
- [ ] コメントアウトコード削除

### テスト
- [ ] 新機能にユニットテスト追加
- [ ] エッジケースのテスト追加
- [ ] カバレッジ低下なし

### ドキュメント
- [ ] PR説明文完成
- [ ] コードコメント追加（必要に応じて）
- [ ] README更新（必要に応じて）

### セキュリティ
- [ ] 機密情報なし
- [ ] 入力値検証実装
- [ ] 認証・認可適切

### Breaking Changes
- [ ] Breaking Changeなし、またはドキュメント化済み
- [ ] マイグレーションガイド作成（該当する場合）
