---
name: incident-logger
description: 開発中に発生した問題・エラー・失敗を即座に記録し、体系的に管理するシステム。再発防止、ナレッジ蓄積、チーム学習を実現する問題管理の中核Skill。
---

# Incident Logger Skill

## 📋 目次

1. [概要](#概要)
2. [いつ使うか](#いつ使うか)
3. [記録の種類](#記録の種類)
4. [記録テンプレート](#記録テンプレート)
5. [分類・タグ付け](#分類タグ付け)
6. [ワークフロー](#ワークフロー)
7. [検索・活用](#検索活用)
8. [Agent連携](#agent連携)

---

## 概要

このSkillは、問題記録とナレッジ蓄積の全てをカバーします：

- ✅ 即座に問題を記録する仕組み
- ✅ 構造化された記録フォーマット
- ✅ 分類・タグ付けシステム
- ✅ 検索・参照の容易化
- ✅ 各Skillへの自動フィードバック
- ✅ 再発防止策の体系化
- ✅ チーム学習の促進

## 📚 公式ドキュメント・参考リソース

**このガイドで学べること**: インシデント記録方法、分類・タグ付け、検索・分析、再発防止策の策定
**公式で確認すべきこと**: インシデント管理ツールの最新機能、業界標準のプロセス

### 主要な公式ドキュメント

- **[ITIL Incident Management](https://www.axelos.com/certifications/itil-service-management)** - ITサービス管理のベストプラクティス

- **[PagerDuty Incident Response](https://response.pagerduty.com/)** - インシデント対応ガイド
  - [Best Practices](https://response.pagerduty.com/)

- **[Atlassian Incident Management](https://www.atlassian.com/incident-management)** - インシデント管理フレームワーク
  - [Playbooks](https://www.atlassian.com/incident-management)

- **[Google SRE Book - Incident Response](https://sre.google/sre-book/managing-incidents/)** - Googleのインシデント管理

### 関連リソース

- **[Incident.io Blog](https://incident.io/blog)** - インシデント管理のベストプラクティス
- **[Post-Mortem Culture](https://landing.google.com/sre/sre-book/chapters/postmortem-culture/)** - ポストモーテム文化
- **[Blameless Post-Mortems](https://sre.google/sre-book/postmortem-culture/)** - 非難のないポストモーテム

---

## いつ使うか

### 即座に記録すべきケース

- ❗ ビルド・テスト失敗
- ❗ クラッシュ・エラー発生
- ❗ デプロイ失敗
- ❗ 予期しない動作
- ❗ パフォーマンス劣化
- ❗ セキュリティ問題発見
- ❗ 設定ミス・人的エラー

### 記録推奨ケース

- 💡 長時間かかった調査
- 💡 ハマりポイント
- 💡 ワークアラウンド発見
- 💡 ベストプラクティス発見
- 💡 効率化アイデア

---

## 記録の種類

### 1. Critical（重大）- 即座に対応必要

```
- 本番環境のクラッシュ
- セキュリティ脆弱性
- データ損失
- サービス停止
```

詳細: [guides/01-critical-incidents.md](guides/01-critical-incidents.md)

### 2. High（高）- 早急に対応

```
- 主要機能の不具合
- パフォーマンス劣化
- ビルド・デプロイ失敗
```

詳細: [guides/02-high-priority-incidents.md](guides/02-high-priority-incidents.md)

### 3. Medium（中）- 計画的に対応

```
- 副次的機能の問題
- UI/UX問題
- 軽微なバグ
```

詳細: [guides/03-medium-priority-incidents.md](guides/03-medium-priority-incidents.md)

### 4. Low（低）- 余裕がある時に対応

```
- 改善提案
- リファクタリング候補
- ドキュメント不備
```

詳細: [guides/04-low-priority-incidents.md](guides/04-low-priority-incidents.md)

### 5. Knowledge（知識）- 学び・発見

```
- ベストプラクティス発見
- 効率化手法
- ツール活用法
```

詳細: [guides/05-knowledge-capture.md](guides/05-knowledge-capture.md)

---

## 記録テンプレート

### 基本テンプレート

```markdown
# [分類] 問題のタイトル

## 📅 発生日時
YYYY-MM-DD HH:MM

## 🎯 重要度
Critical / High / Medium / Low / Knowledge

## 📝 概要
問題の簡潔な説明（1-2文）

## 🔍 症状
- 何が起きたか
- エラーメッセージ
- 再現率
- 影響範囲

## 🔬 原因
根本原因の分析

## ✅ 解決方法
実際に問題を解決した手順

1. ステップ1
2. ステップ2
3. ...

## 🛡️ 予防策
同じ問題を防ぐために

- チェックリストに追加
- 自動化
- ドキュメント更新

## ⏱️ 所要時間
- 発見〜原因特定: X時間
- 解決: Y時間
- 合計: Z時間

## 📚 参考資料
- URL1
- URL2

## 🏷️ タグ
#カテゴリ #技術 #環境

## 📊 影響範囲
- 影響を受けたコンポーネント
- 影響を受けたユーザー
```

テンプレートファイル: [templates/incident-template.md](templates/incident-template.md)

### クイック記録テンプレート（緊急時）

```markdown
# [緊急] タイトル

**発生**: YYYY-MM-DD HH:MM
**状況**: 簡潔な説明
**対応**: 実施した対応
**次のアクション**:

※後で詳細を追記
```

テンプレート: [templates/quick-incident.md](templates/quick-incident.md)

---

## 分類・タグ付け

### カテゴリ

```
build       - ビルド関連
test        - テスト関連
deploy      - デプロイ関連
crash       - クラッシュ
memory      - メモリ関連
performance - パフォーマンス
network     - ネットワーク
ui          - UI関連
security    - セキュリティ
config      - 設定・環境
dependency  - 依存関係
human-error - 人的ミス
```

### 技術タグ

```
#swift #swiftui #uikit #combine #coredata
#xcode #github-actions #fastlane
#ios15 #ios16 #ios17
```

### 環境タグ

```
#local #ci #testflight #production
#simulator #device
```

詳細: [guides/06-tagging-system.md](guides/06-tagging-system.md)

---

## ワークフロー

### 1. 問題発生 → 即座に記録

```bash
# 新しいインシデント作成
cd ~/.claude/skills/incident-logger/incidents/
mkdir 2024/
touch 2024/001-build-failure-xcode15.md

# テンプレートからコピー
cp ../templates/incident-template.md 2024/001-build-failure-xcode15.md

# 編集
vim 2024/001-build-failure-xcode15.md
```

### 2. 調査・解決

調査しながら記録を更新：

```markdown
## 🔬 原因（更新中）
- 仮説1: Xcodeバージョン問題 → ❌ 違った
- 仮説2: キャッシュ問題 → ❌ 違った
- 仮説3: SPM依存関係 → ✅ これだった！
```

### 3. 解決後 → 詳細記録

完全な解決方法、予防策を記録

### 4. フィードバック → 各Skillへ反映

```
該当するSkillに追加:
- チェックリストに項目追加
- ガイドに注意事項追加
- incidents/にリンク
```

### 5. インデックス更新

```markdown
# incidents/2024/index.md に追加

| ID | 日付 | タイトル | 重要度 | 所要時間 |
|----|------|---------|--------|---------|
| 001 | 2024-12-24 | Xcode15ビルド失敗 | High | 3h |
```

詳細: [guides/07-workflow.md](guides/07-workflow.md)

---

## 検索・活用

### インシデント検索

```bash
# タグで検索
grep -r "#build" incidents/

# カテゴリで検索
grep -r "build" incidents/*/index.md

# キーワード検索
grep -r "Xcode" incidents/
```

### 類似問題の発見

問題発生時、まず過去事例を検索：

```
「Xcodeビルド失敗」
→ incidents/2024/001-build-failure-xcode15.md
→ 同じ問題！解決方法あり！
→ 5分で解決（調査不要）
```

### 統計・分析

```bash
# 月別インシデント数
ls incidents/2024/ | wc -l

# カテゴリ別集計
grep -r "^#" incidents/ | cut -d'#' -f2 | sort | uniq -c

# 平均解決時間
grep "所要時間" incidents/**/*.md
```

詳細: [guides/08-searching-analyzing.md](guides/08-searching-analyzing.md)

---

## Agent連携

### このSkillを使用するAgents

1. **incident-recorder-agent**
   - 問題発生時に即座に記録支援
   - テンプレート適用、タグ提案
   - Thoroughness: `quick`

2. **incident-analyzer-agent**
   - 過去の類似インシデント検索
   - パターン分析
   - Thoroughness: `thorough`

3. **prevention-agent**
   - 予防策提案
   - チェックリスト更新提案
   - Thoroughness: `medium`

4. **knowledge-extractor-agent**
   - インシデントから学習事項抽出
   - 各Skillへのフィードバック提案
   - Thoroughness: `thorough`

### 推奨Agentワークフロー

#### 問題発生時（順次実行）

```
incident-analyzer-agent (類似事例検索)
→ 過去の解決方法があれば即適用
→ なければ調査開始
→ incident-recorder-agent (記録支援)
```

#### 解決後（並行実行）

```
knowledge-extractor-agent (学習抽出) +
prevention-agent (予防策提案)
→ 各Skillへフィードバック
```

---

## クイックリファレンス

### 新規インシデント作成コマンド

```bash
# スクリプト使用（推奨）
./scripts/create-incident.sh "Build failure on Xcode 15"

# 手動作成
INCIDENT_ID=$(printf "%03d" $(($(ls incidents/2024/ | wc -l) + 1)))
cp templates/incident-template.md incidents/2024/${INCIDENT_ID}-title.md
```

### インデックス更新

```bash
./scripts/update-index.sh
```

### 統計表示

```bash
./scripts/incident-stats.sh
```

---

## 詳細ドキュメント

### Guides（詳細ガイド）

1. [Criticalインシデント対応](guides/01-critical-incidents.md)
2. [Highインシデント対応](guides/02-high-priority-incidents.md)
3. [Mediumインシデント対応](guides/03-medium-priority-incidents.md)
4. [Lowインシデント対応](guides/04-low-priority-incidents.md)
5. [ナレッジキャプチャ](guides/05-knowledge-capture.md)
6. [タグ付けシステム](guides/06-tagging-system.md)
7. [ワークフロー](guides/07-workflow.md)
8. [検索・分析](guides/08-searching-analyzing.md)

### Checklists（チェックリスト）

- [インシデント記録時](checklists/recording.md)
- [解決時確認事項](checklists/resolution.md)
- [フィードバック時](checklists/feedback.md)

### Templates（テンプレート）

- [インシデントテンプレート](templates/incident-template.md)
- [クイック記録](templates/quick-incident.md)
- [知識記録](templates/knowledge-template.md)
- [インデックス](templates/index-template.md)

### Scripts（自動化スクリプト）

- [インシデント作成](scripts/create-incident.sh)
- [インデックス更新](scripts/update-index.sh)
- [統計表示](scripts/incident-stats.sh)
- [タグ検索](scripts/search-by-tag.sh)

### Incidents（実際の記録）

- [2024年](incidents/2024/)
- [インデックス](incidents/index.md)

---

## 成功の指標

### 目標

- ✅ 全インシデントの記録率: 100%
- ✅ 同じ問題の再発率: <10%
- ✅ 類似問題の解決時間短縮: 80%減
- ✅ 月次レトロスペクティブでの活用: 100%

### 効果測定

```
記録開始前:
  問題解決平均時間: 4時間

記録開始後（3ヶ月）:
  初回問題: 4時間
  類似問題: 30分
  全体平均: 1.5時間

効果: 62.5%の時間短縮
```

---

## 関連Skills

- `lessons-learned` - 教訓データベース（インシデントから抽出）
- `quality-assurance` - 品質改善
- 全てのSkills - incidents/フォルダで参照

---

## 更新履歴

このSkill自体の変更履歴は [CHANGELOG.md](CHANGELOG.md) を参照
