# 🔍 Post-Mortem Process - ポストモーテム実施ガイド

> **目的**: インシデントから最大限の学びを引き出し、再発防止と組織の継続的改善を実現するための体系的なポストモーテムプロセス

## 📚 目次

1. [ポストモーテムとは](#ポストモーテムとは)
2. [Blameless Culture（非難なき文化）](#blameless-culture非難なき文化)
3. [ポストモーテムの実施タイミング](#ポストモーテムの実施タイミング)
4. [実施プロセス](#実施プロセス)
5. [5 Whys 分析](#5-whys-分析)
6. [Root Cause Analysis（根本原因分析）](#root-cause-analysis根本原因分析)
7. [タイムライン再構築](#タイムライン再構築)
8. [アクションアイテム抽出](#アクションアイテム抽出)
9. [コミュニケーション戦略](#コミュニケーション戦略)
10. [実際のポストモーテム例](#実際のポストモーテム例)

---

## ポストモーテムとは

### 定義

**ポストモーテム（Post-Mortem）**:
インシデント発生後に実施する、非難なき振り返りプロセス。何が起きたか、なぜ起きたか、どう防ぐかを体系的に分析し、組織の学びに変換する。

```
インシデント発生
     ↓
初動対応・解決
     ↓
ポストモーテム実施 ← ここ！
     ↓
教訓抽出・共有
     ↓
再発防止策実装
     ↓
組織の成長 ✨
```

### ポストモーテムの価値

**短期的な価値**:
```markdown
✅ 同じ問題の再発防止
✅ 隠れた問題の発見
✅ チームの理解深化
✅ 対応プロセスの改善
```

**長期的な価値**:
```markdown
✅ 組織の学習能力向上
✅ システムの信頼性向上
✅ チーム文化の成熟
✅ 知識の蓄積と共有
```

### ポストモーテム vs インシデント記録

| 観点 | インシデント記録 | ポストモーテム |
|------|----------------|---------------|
| **目的** | 事実の記録 | 深い学びの抽出 |
| **タイミング** | 即座 | 解決後（1-3日以内） |
| **深さ** | 表面的 | 根本原因まで |
| **参加者** | 対応者のみ | 関係者全員 |
| **時間** | 5-10分 | 60-120分 |
| **成果物** | 記録ドキュメント | 教訓+アクション |

---

## Blameless Culture（非難なき文化）

### 基本原則

ポストモーテムの最も重要な原則は **Blameless（非難なき）** であること。

```markdown
## Blameless Culture の3原則

### 1. 人ではなくシステムに焦点を当てる

❌ 「誰がミスしたのか？」
✅ 「なぜシステムがこのミスを防げなかったのか？」

❌ 「Aさんがテストを書かなかったから」
✅ 「テストを書くことを強制する仕組みがなかったから」

### 2. 合理的な判断を前提とする

すべての行動は、その時点では合理的だったと仮定する。

「なぜそうしたのか？」ではなく
「その時、どんな情報・判断でそうしたのか？」

### 3. 学びと改善にフォーカスする

過去を責めるのではなく、未来をより良くする。

「誰が悪いのか」ではなく
「何をどう改善すれば、次は防げるか」
```

### Blameless な質問例

**❌ 非難的な質問**:
```
「なぜテストを書かなかったのですか？」
「なぜデプロイ前にチェックしなかったのですか？」
「なぜそんな判断をしたのですか？」
```

**✅ Blameless な質問**:
```
「当時、どんな情報をもとに判断しましたか？」
「テストを書く時間がなかった背景は何ですか？」
「デプロイ前のチェックリストは存在していましたか？」
「その判断をサポートする情報はありましたか？」
```

### 心理的安全性の確保

**ポストモーテムのルール**:
```markdown
## Ground Rules

1. **非難禁止**: 個人を責める発言は一切禁止
2. **オープン**: 全ての情報を正直に共有
3. **建設的**: 批判ではなく改善提案
4. **平等**: 役職・経験に関わらず全員が発言
5. **機密保持**: ポストモーテムの内容は信頼の範囲で共有

## ファシリテーターの役割

- 非難的な発言を即座に制止
- 全員が発言できる環境を作る
- システムの問題に誘導する質問
- タイムキープ
```

---

## ポストモーテムの実施タイミング

### 必須実施ケース

**1. Critical/High インシデント**:
```markdown
- サービス停止
- データ損失
- セキュリティ侵害
- 大規模なパフォーマンス劣化
- 顧客への重大な影響
```

**2. 複数回発生した問題**:
```markdown
- 同じ種類の問題が3回以上
- パターンが見える問題
```

**3. 新しいタイプの問題**:
```markdown
- これまで経験のない問題
- 予期しなかった振る舞い
```

### 推奨実施ケース

**4. 学びが大きい問題**:
```markdown
- 興味深い技術的発見
- プロセス改善の機会
- チームで共有すべき知見
```

**5. ニアミス**:
```markdown
- 本番影響は出なかったが、危なかった
- 偶然防げただけの問題
```

### 実施タイミング

```
インシデント解決
     ↓
24時間以内: 記憶が新鮮なうちに
     ↓
72時間以内: ポストモーテム実施 ← 推奨
     ↓
1週間以内: 遅くともここまでに
```

**理由**:
- 記憶が新鮮
- 当事者が揃いやすい
- 緊急度が保たれる

---

## 実施プロセス

### Step 0: 準備（30分）

**ファシリテーター決定**:
```markdown
## ファシリテーターの選び方

✅ インシデント対応者ではない人（客観性）
✅ ポストモーテム経験がある人
✅ チームから信頼されている人
✅ 非難なき文化を理解している人

## 準備タスク
- [ ] 参加者の招集
- [ ] 会議室/ビデオ会議の予約
- [ ] インシデント記録の確認
- [ ] タイムライン作成（ドラフト）
- [ ] テンプレート準備
```

**参加者**:
```markdown
## 必須参加者
- インシデント対応者（全員）
- システムオーナー
- 関連チームの代表

## オプション参加者
- 影響を受けたユーザーの声を代弁できる人
- 類似システムの担当者
- 上級エンジニア（アドバイザー）

## 目安: 5-10名
多すぎると発言しにくい
少なすぎると視点が限定される
```

### Step 1: イントロダクション（5分）

**ファシリテーター**:
```markdown
## オープニング

「今日のポストモーテムの目的は、[インシデント名]から学び、
再発を防ぐことです。Blameless なので、誰も責めません。
システムの問題を一緒に見つけましょう。」

## Ground Rules の確認
1. 非難禁止
2. オープンな共有
3. 建設的な議論
4. 全員が発言
5. 機密保持

## アジェンダ
1. タイムライン確認（15分）
2. 影響の確認（10分）
3. 根本原因分析（30分）
4. アクションアイテム抽出（20分）
5. まとめ（5分）

合計: 80分
```

### Step 2: タイムライン確認（15分）

**目的**: 何が起きたかを時系列で整理

```markdown
## タイムラインのフォーマット

| 時刻 | イベント | 誰が | 何をした | 結果 |
|------|---------|------|---------|------|
| 14:23 | アラート発生 | Monitoring | CPU 100% 検知 | Slack 通知 |
| 14:25 | 確認開始 | @alice | ダッシュボード確認 | サーバー応答なし |
| 14:28 | 原因特定 | @bob | ログ確認 | メモリリーク発見 |
| 14:30 | 対応開始 | @alice | サーバー再起動 | 一時的に復旧 |
| 14:45 | 根本対応 | @bob | コード修正・デプロイ | 完全復旧 |
| 15:00 | 検証完了 | @charlie | 動作確認 | 正常動作確認 |

## 確認ポイント
- 時系列は正確か？
- 重要なイベントが漏れていないか？
- 各アクションの理由は？
```

**ディスカッション**:
```markdown
## 質問例

「14:23のアラートは、問題発生からどれくらい後？」
→ 検知の遅延を把握

「14:25の時点で、他にどんな情報があれば早く特定できた？」
→ モニタリング改善のヒント

「14:30の再起動は、その時点で最適な判断だった？」
→ 判断プロセスの妥当性確認
```

### Step 3: 影響の確認（10分）

**影響範囲の定量化**:

```markdown
## 影響メトリクス

### ユーザーへの影響
- 影響ユーザー数: 1,234名
- 完全に使えなかった: 15分
- 部分的に使えなかった: 30分
- エラー率: 23% → 正常

### ビジネスへの影響
- 機会損失: 推定 $X
- サポート問い合わせ: 45件
- レビュー評価の低下: 4.5 → 4.2

### システムへの影響
- データ損失: なし
- データ不整合: 12件（修正済み）
- 他システムへの影響: なし

### チームへの影響
- 対応時間: 3時間（3名）= 9人時
- 夜間対応: なし
- 他タスクの遅延: あり（リリース1日遅れ）
```

### Step 4: 根本原因分析（30分）

**5 Whys を使った分析** （詳細は後述）:

```markdown
## 問題: サーバーがクラッシュした

Why 1: なぜクラッシュした？
→ メモリ不足

Why 2: なぜメモリ不足になった？
→ メモリリークがあった

Why 3: なぜメモリリークが発生した？
→ WebSocket の removeListener 漏れ

Why 4: なぜ removeListener 漏れがあった？
→ コードレビューで見落とした

Why 5: なぜコードレビューで見落とした？
→ メモリリークのチェック項目がなかった

## 根本原因
コードレビューのチェックリストにメモリ管理の項目がない
```

**複数の原因を探る**:

```markdown
## 根本原因は1つではない

### 直接原因（Technical）
- メモリリーク（コードの問題）

### 寄与因子（Process）
- コードレビューのチェック漏れ
- メモリプロファイリングの未実施

### システム的要因（System）
- メモリ監視アラートがなかった
- 自動テストでメモリリークを検出していない

### 組織的要因（Organizational）
- メモリ管理の教育不足
- リリース前のチェックリストが不十分
```

### Step 5: アクションアイテム抽出（20分）

**SMART なアクション**:

```markdown
## 根本原因 → アクションアイテム

### 原因1: メモリリーク
→ Action 1: メモリプロファイリングを CI に追加
  - 担当: @charlie
  - 期限: 1週間以内
  - 成果物: GitHub Actions ワークフロー

### 原因2: コードレビュー漏れ
→ Action 2: チェックリストに「メモリ管理」項目追加
  - 担当: @diana
  - 期限: 3日以内
  - 成果物: 更新されたチェックリスト

### 原因3: 監視不足
→ Action 3: メモリ使用率アラート設定
  - 担当: @alice
  - 期限: 2週間以内
  - 成果物: Datadog アラート設定

### 原因4: 教育不足
→ Action 4: メモリ管理の社内勉強会
  - 担当: @bob
  - 期限: 1ヶ月以内
  - 成果物: 勉強会資料 + 録画
```

**優先度付け**:

```markdown
## アクションの優先度

### P0（即座に実施）
- [ ] 緊急パッチ適用
- [ ] 監視強化

### P1（1週間以内）
- [ ] CI にメモリチェック追加
- [ ] チェックリスト更新

### P2（1ヶ月以内）
- [ ] 勉強会実施
- [ ] ドキュメント整備

### P3（3ヶ月以内）
- [ ] 自動テスト拡充
- [ ] 類似コードの監査
```

### Step 6: まとめ（5分）

**振り返りと次のステップ**:

```markdown
## まとめ

### 今日の学び
1. メモリリークは Instruments で検出できる
2. コードレビューのチェックリストが重要
3. 監視アラートで早期発見が可能

### アクションアイテム（再確認）
- 計7件のアクション
- 担当者と期限を明確化
- 次回レビューは2週間後

### 次のステップ
1. このポストモーテムをドキュメント化（ファシリテーター）
2. アクションアイテムを GitHub Issues に登録
3. 2週間後にフォローアップミーティング
4. 教訓を lessons-learned に追加

### 参加者へ
「ご参加ありがとうございました。今日の学びを次に活かしましょう！」
```

---

## 5 Whys 分析

### 5 Whys とは

トヨタ生産方式で開発された、根本原因を見つける手法。
「なぜ？」を5回繰り返すことで、表面的な原因から真の根本原因に到達する。

### 実施方法

**ステップ**:
```markdown
1. 問題を明確に定義する
2. 「なぜそうなったか？」を問う
3. 答えに対して「なぜ？」を繰り返す
4. 5回目で根本原因に到達（目安）
5. 対策が明確になったら終了
```

### 例1: API エラー

```markdown
## 問題: API が 500 エラーを返した

Why 1: なぜ 500 エラーが返った？
→ データベースクエリが失敗した

Why 2: なぜクエリが失敗した？
→ テーブルにカラムが存在しない

Why 3: なぜカラムが存在しない？
→ マイグレーションが実行されていなかった

Why 4: なぜマイグレーションが実行されていなかった？
→ デプロイスクリプトに含まれていなかった

Why 5: なぜスクリプトに含まれていなかった？
→ デプロイ手順書が更新されていなかった

## 根本原因
デプロイ手順書の更新プロセスがない

## 対策
- デプロイ手順書を自動生成
- マイグレーション実行を CI で必須化
```

### 例2: 本番環境でのクラッシュ

```markdown
## 問題: 本番環境でアプリがクラッシュ

Why 1: なぜクラッシュした？
→ nil を force unwrap した

Why 2: なぜ nil になった？
→ API レスポンスに該当フィールドがなかった

Why 3: なぜフィールドがなかった？
→ API の仕様変更があった

Why 4: なぜ仕様変更に気づかなかった？
→ API の変更通知を受け取っていなかった

Why 5: なぜ通知を受け取っていなかった？
→ API チームとのコミュニケーションチャネルがなかった

## 根本原因
チーム間のコミュニケーションプロセスがない

## 対策
- API 変更の通知 Slack チャネル作成
- API スキーマのバージョン管理
- Optional 処理の徹底（SwiftLint）
```

### 5 Whys の注意点

**❌ やってはいけないこと**:

```markdown
## 1. 人を責める
Why: なぜバグが出た？
→ ❌ 「Aさんがテストを書かなかったから」
→ ✅ 「テストが書かれていなかったから」

## 2. 5回で止める必要はない
3回で根本原因に到達することも、7回必要なこともある

## 3. 単一の原因に絞る
複数の根本原因が存在することもある

## 4. 答えが推測になる
事実に基づいた分析を
```

**✅ ベストプラクティス**:

```markdown
## 1. 事実ベース
ログ、データ、証拠に基づく

## 2. 複数の視点
技術的・プロセス的・組織的要因を探る

## 3. システムに焦点
人の問題→システムの問題に変換

## 4. アクションにつなげる
根本原因→具体的な対策
```

---

## Root Cause Analysis（根本原因分析）

### RCA のフレームワーク

**Ishikawa Diagram（魚骨図）**:

```
                           問題
                             ▲
                             │
        ┌────────────────────┼────────────────────┐
        │                    │                    │
    人（People）         プロセス            技術（Technology）
        │                    │                    │
    ・スキル不足          ・手順書なし          ・監視不足
    ・教育不足            ・レビュー漏れ        ・テスト不足
        │                    │                    │
        └────────────────────┴────────────────────┘
                             │
                        根本原因
```

**具体例**:

```markdown
## 問題: デプロイ失敗

### 人（People）
- デプロイ担当者の経験不足
- オンボーディング不十分

### プロセス（Process）
- デプロイ前チェックリストがない
- ロールバック手順が不明確

### 技術（Technology）
- CI/CD パイプラインが未整備
- 自動テストが不十分

### 環境（Environment）
- ステージング環境が本番と異なる
- 環境変数の管理が曖昧

### 管理（Management）
- デプロイの責任が不明確
- リリース承認プロセスがない

## 根本原因の特定
複数の要因が組み合わさっている
→ プロセスと技術の両面から対策
```

### Contributing Factors（寄与因子）

根本原因だけでなく、問題を悪化させた要因も特定:

```markdown
## 問題: サーバーダウンの長期化

### 直接原因
メモリリーク

### 寄与因子1: 検知の遅れ
- アラート設定なし
- モニタリング不足

### 寄与因子2: 対応の遅れ
- 担当者が不在（休暇中）
- オンコール体制なし

### 寄与因子3: 復旧の遅れ
- ロールバック手順が不明
- バックアップがなかった

## 対策
直接原因 + すべての寄与因子に対処
```

---

## タイムライン再構築

### タイムラインの重要性

```markdown
## なぜタイムラインが重要か

1. **事実の整理**: 何が起きたかを正確に把握
2. **因果関係の理解**: イベント間の関係を可視化
3. **検知の遅延**: 問題発生から検知までの時間
4. **対応の流れ**: 誰が何をしたかの記録
5. **改善ポイント**: どこで時間がかかったか
```

### タイムライン作成手順

**Step 1: 情報収集**:

```markdown
## 収集すべき情報

### ログ
- アプリケーションログ
- サーバーログ
- データベースログ
- ネットワークログ

### モニタリングデータ
- CPU/メモリ使用率
- エラー率
- レスポンスタイム
- リクエスト数

### コミュニケーション
- Slack の会話
- GitHub のコミット
- Jira のチケット

### 人の記憶
- 対応者へのヒアリング
```

**Step 2: イベントの抽出**:

```markdown
## イベントの種類

### システムイベント
- エラー発生
- アラート発火
- リソース枯渇

### 人のアクション
- 調査開始
- 原因特定
- 対応実施

### 外部イベント
- デプロイ
- トラフィック急増
- 外部サービスの障害
```

**Step 3: 時系列整理**:

```markdown
## タイムラインフォーマット

| 時刻 | イベント | ソース | 詳細 | アクション |
|------|---------|--------|------|-----------|
| 14:20:03 | メモリ使用率 90% | Datadog | threshold: 80% | アラート発火 |
| 14:20:05 | Slack 通知 | Alerting | #oncall | @alice 確認開始 |
| 14:22:15 | ダッシュボード確認 | @alice | メモリ増加傾向 | ログ調査開始 |
| 14:25:30 | エラーログ発見 | @alice | OutOfMemoryError | @bob に連絡 |
| 14:28:00 | コードレビュー | @bob | メモリリーク発見 | 修正開始 |
| 14:35:00 | 緊急パッチ作成 | @bob | removeListener 追加 | デプロイ準備 |
| 14:40:00 | デプロイ実行 | @alice | staging → production | 監視開始 |
| 14:45:00 | メモリ使用率正常化 | Datadog | 65% に低下 | 継続監視 |
| 15:00:00 | 完全復旧確認 | @charlie | 正常動作確認 | インシデント終了 |

## メトリクス
- 問題発生: 14:20:03
- 検知: 14:20:05（2秒後）
- 原因特定: 14:28:00（8分後）
- 修正完了: 14:35:00（15分後）
- 復旧: 14:45:00（25分後）

## MTTR (Mean Time To Repair)
25分
```

**Step 4: 可視化**:

```markdown
## ガントチャート形式

14:20 ■■ 問題発生
14:20 ■■■ 検知（2分）
14:22 ■■■■■■ 調査（6分）
14:28 ■■■■■■■ 修正作成（7分）
14:35 ■■■■■ デプロイ（5分）
14:40 ■■■■■ 監視・確認（5分）
14:45 ■ 完全復旧

## Critical Path
検知 → 調査 → 修正 が最も時間がかかった
→ 改善ポイント
```

---

## アクションアイテム抽出

### 良いアクションアイテムの条件

**SMART 原則**:

```markdown
## SMART

### S - Specific（具体的）
❌ 「監視を強化する」
✅ 「Datadog にメモリ使用率 80% でアラート設定」

### M - Measurable（測定可能）
❌ 「テストを増やす」
✅ 「カバレッジを 68% から 80% に向上」

### A - Achievable（達成可能）
❌ 「全バグをゼロにする」
✅ 「Critical バグを月5件から1件に削減」

### R - Relevant（関連性）
根本原因に対応したアクション

### T - Time-bound（期限）
❌ 「いつか実施」
✅ 「2週間以内に完了」
```

### アクション種別

**1. 即効性のある対策（Short-term）**:

```markdown
## 即座に実施（1週間以内）

### パッチ適用
- [ ] メモリリーク修正のデプロイ
- 担当: @bob
- 期限: 明日

### 監視強化
- [ ] メモリアラート設定
- 担当: @alice
- 期限: 3日以内

### チェックリスト更新
- [ ] コードレビューにメモリ管理追加
- 担当: @diana
- 期限: 1週間以内
```

**2. 根本的な対策（Long-term）**:

```markdown
## 中長期的に実施（1-3ヶ月）

### プロセス改善
- [ ] CI にメモリプロファイリング追加
- 担当: @charlie
- 期限: 2週間以内

### 教育・啓蒙
- [ ] メモリ管理の社内勉強会
- 担当: @bob
- 期限: 1ヶ月以内

### ツール導入
- [ ] 自動メモリリーク検出ツール
- 担当: @eve
- 期限: 2ヶ月以内
```

**3. 予防的な対策（Preventive）**:

```markdown
## 同様の問題を防ぐ

### コードレベル
- [ ] SwiftLint に deinit チェック追加
- [ ] メモリ管理のベストプラクティス文書化

### テストレベル
- [ ] メモリリークの自動テスト
- [ ] パフォーマンステストの追加

### 運用レベル
- [ ] 定期的なメモリプロファイリング
- [ ] リリース前の必須チェック項目
```

### アクション追跡

**GitHub Issues での管理**:

```markdown
## Issue テンプレート

---
タイトル: [PM-042] メモリアラート設定

**関連ポストモーテム**: #042 - サーバーメモリ不足
**優先度**: P1
**担当**: @alice
**期限**: 2025-01-10

**タスク**:
- [ ] Datadog でメモリ使用率メトリクス確認
- [ ] 80% でアラート設定
- [ ] #oncall に通知設定
- [ ] テストアラート発火確認
- [ ] ドキュメント更新

**完了条件**:
- メモリ 80% で Slack 通知が来る
- アラート設定がドキュメント化されている

**進捗**:
- 2025-01-05: 設定完了
- 2025-01-06: テスト OK
- 2025-01-07: ドキュメント更新完了 ✅
---
```

---

## コミュニケーション戦略

### 社内への共有

**共有範囲と内容**:

```markdown
## 共有レベル

### Level 1: チーム全体（必須）
- ポストモーテム全文
- すべての詳細

### Level 2: 関連チーム
- サマリー版
- 影響と対策の概要

### Level 3: 全社
- エグゼクティブサマリー
- 重大インシデントのみ

### Level 4: 外部（顧客）
- インシデントレポート
- 影響と復旧時間のみ
```

**チーム全体への共有例**:

```markdown
## Slack #engineering

---
📋 **ポストモーテム完了: PM-042 サーバーメモリ不足**

**インシデント**: 2025-01-05 14:20-14:45（25分）
**影響**: 1,234ユーザー、API エラー率 23%

**根本原因**:
- WebSocket の removeListener 漏れ → メモリリーク
- コードレビューのチェック項目不足
- メモリ監視アラートなし

**学び**:
1. Instruments でメモリリークは検出できる
2. コードレビューのチェックリストが重要
3. 監視アラートで早期発見が可能

**アクション（7件）**:
- メモリアラート設定（@alice, 3日以内）✅ 完了
- チェックリスト更新（@diana, 1週間）進行中
- CI にメモリチェック（@charlie, 2週間）
- 勉強会実施（@bob, 1ヶ月）

**詳細**: [ポストモーテムドキュメント](link)

**教訓化**: lessons/best-practices/memory-management.md
---
```

### 顧客への報告

**インシデントレポート例**:

```markdown
# インシデントレポート

**日時**: 2025年1月5日 14:20 - 14:45 JST（25分間）

**概要**:
2025年1月5日、一部のユーザー様において、当社サービスが一時的に利用できない、または応答が遅い状態が発生いたしました。

**影響範囲**:
- 影響を受けたユーザー数: 約1,200名
- 完全に利用できなかった時間: 約15分
- 部分的に影響があった時間: 約10分

**原因**:
サーバーのメモリ管理に問題があり、メモリ不足に陥ったため。

**対応**:
14:20 - 問題を検知
14:28 - 原因を特定
14:35 - 修正プログラムを作成
14:40 - 修正をデプロイ
14:45 - 完全復旧を確認

**再発防止策**:
1. サーバー監視体制の強化
2. 自動テストの拡充
3. デプロイ前のチェック強化

**お詫び**:
ご利用のお客様には大変ご迷惑をおかけし、誠に申し訳ございませんでした。
今後このような事態が発生しないよう、再発防止に努めてまいります。
```

### 定期報告

**月次インシデントレポート**:

```markdown
# 2025年1月 インシデントレポート

## サマリー
- 総インシデント数: 8件（先月: 12件、▼33%）
- Critical: 0件
- High: 2件
- Medium: 4件
- Low: 2件

## 主要インシデント

### PM-042: サーバーメモリ不足（High）
- 影響: 1,234ユーザー、25分
- 原因: メモリリーク
- 対策: 監視強化、CI 改善

### PM-045: API レート制限超過（High）
- 影響: 500ユーザー、10分
- 原因: トラフィック急増
- 対策: オートスケーリング設定

## 傾向分析
- メモリ関連: 2件（前月3件）
- API関連: 3件（前月4件）
- デプロイ関連: 1件（前月2件）

## 学び
今月は8件の教訓を lessons-learned に追加
- memory-management.md
- rate-limiting.md
- ...

## 改善効果
- MTTR: 32分 → 18分（▼44%）
- 再発率: 25% → 12%（▼52%）
```

---

## 実際のポストモーテム例

### 例1: iOS 15 で画面真っ白

```markdown
# Post-Mortem: iOS 15 で NavigationStack 未対応

**日時**: 2025-01-10 09:00 - 10:30
**重大度**: High
**影響**: iOS 15 ユーザー約500名、完全に使用不可

---

## 📊 サマリー

2025年1月10日、iOS 15 ユーザーにおいて、ログイン後の画面が真っ白になり、
アプリが使用できない問題が発生しました。iOS 16 以降のユーザーには影響なし。

---

## 📅 タイムライン

| 時刻 | イベント | 担当 | 詳細 |
|------|---------|------|------|
| 09:00 | リリース | @alice | v2.3.0 を App Store に公開 |
| 09:15 | 問い合わせ | Support | iOS 15 で画面真っ白の報告 |
| 09:20 | 確認開始 | @bob | iOS 15 シミュレータで再現 |
| 09:25 | 原因特定 | @bob | NavigationStack が iOS 16+ のみ |
| 09:35 | Hotfix 作成 | @bob | iOS 15 は NavigationView に分岐 |
| 09:50 | 緊急リリース | @alice | v2.3.1 を申請 |
| 10:30 | 承認・公開 | App Store | 問題解決 |

**MTTR**: 1時間30分（検知から修正版公開まで）

---

## 🔍 根本原因分析

### 5 Whys

**Why 1**: なぜ画面が真っ白になった？
→ NavigationStack が iOS 15 で動作しない

**Why 2**: なぜ iOS 15 で動作しないコードをリリースした？
→ iOS 15 でのテストを実施していなかった

**Why 3**: なぜ iOS 15 でテストしなかった？
→ CI に iOS 15 のテストがなかった

**Why 4**: なぜ CI に iOS 15 テストがなかった？
→ 最小サポートバージョンのテストが必須化されていなかった

**Why 5**: なぜ必須化されていなかった？
→ 新 API 使用時のチェックプロセスがなかった

### 根本原因

**Primary**: 最小サポートバージョンでのテストプロセスがない

**Contributing Factors**:
- コードレビューで iOS バージョン依存を確認していない
- `#available` チェックの自動検証がない
- QA テスト計画に iOS バージョン網羅性がない

---

## 📈 影響

### ユーザーへの影響
- 影響ユーザー数: 約500名（全体の5%）
- 完全に使用不可: 1時間30分
- App Store レビュー: 1つ星 3件

### ビジネスへの影響
- サポート問い合わせ: 12件
- レビュー評価: 4.6 → 4.5

### チームへの影響
- 緊急対応: 3名 × 2時間 = 6人時
- 他タスクの遅延: 新機能開発が半日遅れ

---

## ✅ アクションアイテム

### 即座（1週間以内）

#### 1. CI に iOS 15 実機テストを追加
- **担当**: @alice
- **期限**: 2025-01-17
- **優先度**: P0
- **詳細**: GitHub Actions に iOS 15 シミュレータテストを追加
- **完了条件**: すべての PR で iOS 15 テストが実行される

#### 2. コードレビューチェックリストに iOS バージョン確認を追加
- **担当**: @diana
- **期限**: 2025-01-15
- **優先度**: P0
- **詳細**: 新 API 使用時は `#available` チェック必須
- **完了条件**: チェックリストが更新され、チームに共有される

#### 3. SwiftLint に iOS バージョンチェックルールを追加
- **担当**: @charlie
- **期限**: 2025-01-20
- **優先度**: P1
- **詳細**: iOS 16+ API を `#available` なしで使用したら警告
- **完了条件**: カスタムルールが機能している

### 中期（1ヶ月以内）

#### 4. QA テスト計画にバージョン網羅性を追加
- **担当**: @eve（QA）
- **期限**: 2025-02-10
- **優先度**: P1
- **詳細**: 各リリースで最小〜最新バージョンをテスト
- **完了条件**: テスト計画テンプレートが更新される

#### 5. Preview の iOS バージョンを最小に設定
- **担当**: @bob
- **期限**: 2025-02-10
- **優先度**: P2
- **詳細**: SwiftUI Preview のデフォルトを iOS 15 に
- **完了条件**: Xcode プロジェクト設定が更新される

---

## 📚 学び

### やってよかったこと ✅
1. **迅速な対応**: 検知から1.5時間で修正版リリース
2. **シンプルな修正**: 分岐処理で即座に対応
3. **透明なコミュニケーション**: ユーザーへの状況共有

### 改善すべきこと ❌
1. **リリース前テスト**: 最小バージョンでのテストが漏れた
2. **コードレビュー**: iOS バージョン依存を見落とした
3. **CI**: 自動テストが不十分だった

### 予期しなかった発見 💡
- iOS 15 ユーザーが思ったより多い（5%）
- App Store のレビュー承認が緊急時は早い（40分）

---

## 🔄 フォローアップ

### 2週間後レビュー（2025-01-24）
- [ ] すべてのアクションアイテム完了確認
- [ ] iOS 15 での安定性確認
- [ ] 再発防止策の効果測定

### 教訓化
- [ ] lessons/best-practices/ios-version-support.md に追加
- [ ] ios-development/checklists/code-review.md に反映

---

## 👥 参加者

- @alice（iOS Lead）
- @bob（iOS Engineer）
- @charlie（DevOps）
- @diana（Engineering Manager）
- @eve（QA Lead）

**ファシリテーター**: @diana
**記録者**: @bob

---

## 📎 関連リンク

- [インシデント記録](incidents/2025/002-ios15-crash.md)
- [Hotfix PR](https://github.com/org/repo/pull/1234)
- [GitHub Issue](https://github.com/org/repo/issues/456)
- [App Store レビュー](link)
```

### 例2: データベースマイグレーション失敗

```markdown
# Post-Mortem: 本番DBマイグレーション失敗によるサービス停止

**日時**: 2025-01-15 22:00 - 23:45
**重大度**: Critical
**影響**: 全ユーザー、1時間45分の完全停止

---

## 📊 サマリー

2025年1月15日夜、定期メンテナンスでのデータベースマイグレーション中に
エラーが発生し、サービスが1時間45分停止しました。

---

## 📅 タイムライン

| 時刻 | イベント | 担当 | 詳細 |
|------|---------|------|------|
| 22:00 | メンテ開始 | @alice | 告知通りメンテナンス開始 |
| 22:05 | DB停止 | @alice | マイグレーション準備 |
| 22:10 | マイグレーション実行 | @alice | Rails db:migrate |
| 22:15 | **エラー発生** | System | PG::DependentObjectsStillExist |
| 22:17 | 調査開始 | @alice, @bob | エラーログ確認 |
| 22:30 | 原因特定 | @bob | 外部キー制約の順序問題 |
| 22:45 | ロールバック試行 | @alice | db:rollback 実行 |
| 22:50 | **ロールバック失敗** | System | 中途半端な状態 |
| 23:00 | DBA召集 | @charlie | 緊急対応 |
| 23:15 | 手動修正開始 | @charlie | SQL で直接修正 |
| 23:30 | データ整合性確認 | @charlie | 全テーブルチェック |
| 23:40 | サービス再開 | @alice | アプリケーション起動 |
| 23:45 | 完全復旧確認 | @bob | 動作確認完了 |

**MTTR**: 1時間45分

---

## 🔍 根本原因分析

### 5 Whys

**Why 1**: なぜマイグレーションが失敗した？
→ テーブル削除で外部キー制約エラー

**Why 2**: なぜ外部キー制約エラーが出た？
→ 依存関係の順序を考慮していなかった

**Why 3**: なぜ順序を考慮しなかった？
→ ステージング環境での事前テストが不十分

**Why 4**: なぜ事前テストが不十分だった？
→ ステージング環境が本番と異なる（データ量が少ない）

**Why 5**: なぜロールバックも失敗した？
→ ロールバック手順がテストされていなかった

### 根本原因

**Primary**:
- マイグレーションの本番環境での事前テストがない
- ロールバック手順が確立されていない

**Contributing Factors**:
- ステージング環境と本番環境の差異
- データベース変更のレビュープロセスが不十分
- DBA の即時対応体制がない（オンコールなし）

---

## 📈 影響

### ユーザーへの影響
- **全ユーザー**: 約50,000名
- **完全停止**: 1時間45分
- **データ損失**: なし
- **顧客からの問い合わせ**: 230件

### ビジネスへの影響
- **機会損失**: 推定 $15,000
- **サポートコスト**: 緊急対応 + 問い合わせ対応
- **評判**: Twitter で不満の声多数

### チームへの影響
- **夜間緊急対応**: 4名 × 2時間 = 8人時
- **週末対応**: サポートチーム総動員
- **他プロジェクト**: 次週のリリースを延期

---

## ✅ アクションアイテム

### 即座（1週間以内）

#### 1. マイグレーションのドライラン手順確立
- **担当**: @bob
- **期限**: 2025-01-22
- **優先度**: P0
- **詳細**:
  - 本番DBのコピーでマイグレーションテスト
  - ロールバックも含めてテスト
  - 手順書を作成
- **完了条件**: ドライラン手順書が完成し、次回から適用

#### 2. DBA オンコール体制の確立
- **担当**: @charlie
- **期限**: 2025-01-25
- **優先度**: P0
- **詳細**:
  - 週次でDBAオンコール担当を割り当て
  - 緊急連絡フローを確立
  - 対応マニュアル作成
- **完了条件**: オンコール表が作成され運用開始

#### 3. マイグレーションチェックリスト作成
- **担当**: @alice
- **期限**: 2025-01-20
- **優先度**: P0
- **詳細**:
  - 外部キー制約の確認
  - 依存関係の順序確認
  - ロールバック手順の確認
  - データ量の考慮
- **完了条件**: チェックリストが作成され、チームに共有

### 中期（1ヶ月以内）

#### 4. ステージング環境を本番相当に
- **担当**: @charlie
- **期限**: 2025-02-15
- **優先度**: P1
- **詳細**:
  - 本番DBの定期的なコピー
  - データ量を本番と同等に
  - 環境差異のドキュメント化
- **完了条件**: ステージング環境が本番とほぼ同等

#### 5. マイグレーション自動化ツール導入
- **担当**: @bob
- **期限**: 2025-02-28
- **優先度**: P1
- **詳細**:
  - マイグレーションのCI/CD統合
  - 自動ロールバック機能
  - アラート通知
- **完了条件**: ツールが導入され、次回から使用

#### 6. データベース変更のレビュープロセス強化
- **担当**: @diana
- **期限**: 2025-02-28
- **優先度**: P2
- **詳細**:
  - DBA レビュー必須化
  - SQL の静的解析
  - インデックス影響の評価
- **完了条件**: レビュープロセスが確立

### 長期（3ヶ月以内）

#### 7. ブルーグリーンデプロイメント導入
- **担当**: @charlie
- **期限**: 2025-04-30
- **優先度**: P2
- **詳細**:
  - ダウンタイムゼロのデプロイ
  - 即座のロールバック可能に
- **完了条件**: ブルーグリーンデプロイが実現

---

## 📚 学び

### やってよかったこと ✅
1. **迅速なエスカレーション**: DBA を早期に召集
2. **透明なコミュニケーション**: ユーザーへの状況共有
3. **手動復旧**: SQL での直接修正で復旧

### 改善すべきこと ❌
1. **事前テスト不足**: ドライランを実施すべきだった
2. **ロールバック計画なし**: ロールバック手順が未確立
3. **オンコール体制なし**: DBA の緊急召集に時間がかかった

### 驚いた発見 💡
- ステージングと本番のデータ量の差が影響
- 外部キー制約の順序が重要
- ユーザーの反応が Twitter で即座に現れる

---

## 📝 顧客への報告

```
【重要】サービス一時停止のお詫び

2025年1月15日 22:00から23:45まで、
定期メンテナンス中のトラブルにより、
サービスが一時的に停止いたしました。

ご利用のお客様には多大なご迷惑をおかけし、
誠に申し訳ございませんでした。

現在は完全に復旧しており、データの損失もございません。

今後このような事態を防ぐため、
事前テストの強化およびバックアップ体制の整備を
進めてまいります。

引き続きよろしくお願いいたします。
```

---

## 🔄 フォローアップ

### 1週間後レビュー（2025-01-22）
- [ ] P0 アクション完了確認
- [ ] ドライラン手順の試運転
- [ ] オンコール体制の動作確認

### 1ヶ月後レビュー（2025-02-15）
- [ ] すべてのアクション完了確認
- [ ] 新プロセスの効果測定
- [ ] 次回メンテナンスでの適用

### 教訓化
- [ ] lessons/best-practices/database-migration.md
- [ ] backend-development/guides/migration-guide.md

---

## 👥 参加者

- @alice（Backend Lead）
- @bob（Backend Engineer）
- @charlie（DBA）
- @diana（Engineering Manager）
- @eve（Product Manager）

**ファシリテーター**: @diana
**記録者**: @alice

---
```

---

## まとめ

### ポストモーテム成功の鍵

```markdown
## 1. Blameless であること
人を責めず、システムの改善に焦点

## 2. 事実に基づく分析
推測ではなく、ログ・データに基づく

## 3. 深い掘り下げ
表面的な原因で終わらず、根本原因まで

## 4. 具体的なアクション
SMART な改善策を抽出

## 5. 継続的なフォロー
アクションを確実に実行

## 6. 組織の学びに
教訓を lessons-learned に蓄積
```

### チェックリスト

**実施前**:
- [ ] ファシリテーター決定
- [ ] 参加者招集
- [ ] インシデント記録確認
- [ ] テンプレート準備

**実施中**:
- [ ] Ground Rules の確認
- [ ] タイムライン作成
- [ ] 根本原因分析（5 Whys / RCA）
- [ ] アクションアイテム抽出
- [ ] 担当者・期限の明確化

**実施後**:
- [ ] ドキュメント化
- [ ] チームへの共有
- [ ] アクション追跡（GitHub Issues）
- [ ] 教訓化（lessons-learned）
- [ ] フォローアップミーティング設定

---

## 次のステップ

**関連ガイド**:
- [01-knowledge-base.md](01-knowledge-base.md): 教訓の記録方法
- [02-team-learning.md](02-team-learning.md): チームでの学習プロセス
- [05-knowledge-management.md](05-knowledge-management.md): 知識管理の実践

**テンプレート**:
- [templates/postmortem-template.md](../templates/postmortem-template.md)
- [templates/5whys-template.md](../templates/5whys-template.md)
- [templates/rca-template.md](../templates/rca-template.md)

---

*失敗は学びの機会。ポストモーテムで組織を成長させましょう。*
