---
title: "[教訓のタイトル]"
category: [best-practices / anti-patterns / patterns / optimizations / tools]
subcategory: [coding / architecture / testing / deployment / etc]
tags: [tag1, tag2, tag3, tag4]
difficulty: [beginner / intermediate / advanced]
impact: [high / medium / low]
date_created: YYYY-MM-DD
date_updated: YYYY-MM-DD
author: @username
reviewers: [@reviewer1, @reviewer2]
related_incidents: [042, 089]
related_lessons: [lesson1, lesson2]
status: [draft / active / deprecated]
version: 1.0
---

# [教訓のタイトル]

## 📝 TL;DR（要約）

[教訓を1文で要約する]

---

## 🎯 問題・背景

### なぜこの教訓が必要か

[この教訓が必要になった背景や問題を説明]

### よくある状況

[この教訓が適用される典型的な状況]

---

## 💡 教訓

### 何を学んだか

[学んだことを明確に記述]

### 基本原則

[適用すべき原則やルール]

---

## ❌ Bad（悪い例）

### アンチパターン

```[language]
// ❌ Bad: [なぜ悪いかの説明]
[悪いコード例]
```

### 問題点

1. **[問題1]**: [詳細]
2. **[問題2]**: [詳細]
3. **[問題3]**: [詳細]

### 影響

- [影響1]
- [影響2]

---

## ✅ Good（良い例）

### ベストプラクティス

```[language]
// ✅ Good: [なぜ良いかの説明]
[良いコード例]
```

### 解決方法

[どのように問題を解決するか]

---

## 📊 効果・メリット

### 定量的効果

| 指標 | Before | After | 改善 |
|------|--------|-------|------|
| [指標1] | [値] | [値] | [改善率] |
| [指標2] | [値] | [値] | [改善率] |
| [指標3] | [値] | [値] | [改善率] |

### 定性的メリット

- **[メリット1]**: [詳細]
- **[メリット2]**: [詳細]
- **[メリット3]**: [詳細]

---

## ✅ いつ使うか

### 適用すべき状況

- [状況1]
- [状況2]
- [状況3]

### 判断基準

[この教訓を適用すべきかの判断基準]

---

## ⚠️ いつ使わないか

### 適用すべきでない状況

- [状況1]
- [状況2]

### 例外ケース

[例外的に異なるアプローチを取るべきケース]

---

## 💻 実装例

### 基本的な実装

```[language]
[より詳細なコード例]
```

### 応用例

```[language]
[応用的な使い方]
```

### プロジェクトでの使用例

[実際のプロジェクトでどう使われているか]

---

## ⚠️ 注意点

### 落とし穴

1. **[落とし穴1]**: [詳細と回避方法]
2. **[落とし穴2]**: [詳細と回避方法]

### 制限事項

- [制限1]
- [制限2]

### パフォーマンスへの影響

[パフォーマンスへの影響があれば記載]

---

## 🔍 根拠・事例

### インシデント事例

#### インシデント#042
- **問題**: [何が起きたか]
- **原因**: [この教訓に関連する原因]
- **結果**: [この教訓を適用してどうなったか]

#### インシデント#089
- **問題**: [何が起きたか]
- **原因**: [この教訓に関連する原因]
- **結果**: [この教訓を適用してどうなったか]

### 成功事例

#### プロジェクトA
- **適用**: [どう適用したか]
- **効果**: [どんな効果があったか]

### 参考文献

- [Apple Developer Documentation](link)
- [WWDC Session](link)
- [技術記事](link)

---

## 🔗 関連

### 関連する教訓

- [関連教訓1](../category/related-lesson1.md) - [関連性の説明]
- [関連教訓2](../category/related-lesson2.md) - [関連性の説明]

### 関連するスキル

- [ios-development](../../ios-development/) - [関連性]
- [testing-strategy](../../testing-strategy/) - [関連性]

### 関連するチェックリスト

- [コードレビュー](../../ios-development/checklists/code-review.md)
- [デプロイ前チェック](../../ci-cd-automation/checklists/deploy.md)

---

## 🛠️ ツール・リソース

### 使用するツール

- **[ツール1]**: [用途]
- **[ツール2]**: [用途]

### 設定例

```[language]
[ツールの設定例]
```

### 自動化

[この教訓に関連する自動化の方法]

---

## 📚 さらに学ぶ

### 深掘りトピック

- [トピック1]
- [トピック2]

### 推奨リソース

- [書籍・記事のタイトル](link)
- [ビデオチュートリアル](link)
- [公式ドキュメント](link)

---

## ✅ チェックリスト

この教訓を適用する際のチェックリスト:

- [ ] [チェック項目1]
- [ ] [チェック項目2]
- [ ] [チェック項目3]
- [ ] [チェック項目4]
- [ ] [チェック項目5]

---

## 📝 更新履歴

- **YYYY-MM-DD**: v1.1 - [更新内容]
- **YYYY-MM-DD**: v1.0 - 初版作成

---

## 👥 貢献者

- @author（初版作成）
- @contributor1（[貢献内容]）
- @contributor2（[貢献内容]）

---

## 💬 フィードバック

この教訓に関する質問・フィードバックは:
- Slack: #engineering
- GitHub Issue: [質問テンプレート](.github/ISSUE_TEMPLATE/question.md)

---

**最終更新**: YYYY-MM-DD
**次回レビュー予定**: YYYY-MM-DD
