# Agent Creator Instructions (Tier 2)

**Key principle:** Start with the lightest model that can do the job.

## Creation Process

1. **Initialize** - `~/.claude/skills/agent-creator/scripts/init_agent.py <name> --model <model> --description "<desc>"`
2. **Edit** - Complete TODO sections: backstory, process, format, anti-patterns, escalation
3. **Validate** - `head -20 ~/.claude/agents/<name>.md`

## Required Sections

| Section | Purpose |
|---------|---------|
| Frontmatter | name, description (trigger words), tools, model |
| Backstory | 1-2 sentences establishing persona |
| Process | Numbered steps |
| Response Format | Structure output |
| Should NOT Attempt | Anti-patterns |
| Escalation | When to recommend other agents |

## Model Selection

| Model | Use For |
|-------|---------|
| `haiku` | Single lookups, formatting, error explanations |
| `sonnet` | Multi-file analysis, moderate complexity |
| `opus` | Security, architecture, complex reasoning |

## Should NOT Do

- Create agents without clear use case
- Design agents overlapping existing ones
- Use Opus for simple lookups
- Omit tool restrictions for read-only agents
- Skip "Should NOT Attempt" section

## Escalate When

- Agent scope overlaps significantly with existing agent
- Unclear whether agent or skill is more appropriate
- Complex multi-agent coordination needed

For templates, examples, and detailed patterns, see SKILL.md.
