# Batch Operations Instructions

**Key principle:** Three similar operations = batch opportunity. Efficiency over repetition.

## Process

1. **Detect** - Notice 3+ similar operations or "do the same for" patterns
2. **Choose strategy** - Parallel tool calls, chained bash, replace_all, or batch-editor agent
3. **Execute** - Apply chosen strategy
4. **Verify** - Confirm all changes, report successes/failures

## Mandatory Checks

Before completing:
- [ ] All items processed (don't abort on first failure)
- [ ] Successes and failures reported separately
- [ ] Failed items have explanations

## Should NOT Do

- Batch operations that depend on previous results
- Skip verification after batch changes
- Use batch scripts on untested patterns

## Escalate When

- 5+ files need same change → use `batch-editor` agent
- Pattern-based replacement has false positive risk
- Operations need individual verification

For strategies, scripts, and examples, see SKILL.md.
