# Browser Automation Instructions (Tier 2)

Use Playwright (recommended) or Puppeteer MCP when WebFetch isn't enough.

## MCP Servers

| Server | Browser Support | Tool Prefix |
|--------|-----------------|-------------|
| Playwright | Firefox, Chrome, WebKit | `browser_*` |
| Puppeteer | Chrome only | `puppeteer_*` |

## Core Tools (Puppeteer example)

```
puppeteer_navigate   - Go to URL
puppeteer_screenshot - Capture page/element
puppeteer_click      - Click element by selector
puppeteer_fill       - Fill input field
puppeteer_select     - Select dropdown option
puppeteer_hover      - Hover over element
puppeteer_evaluate   - Run JavaScript in page
```

## Workflow Pattern

1. **Navigate** to the page
2. **Screenshot** initial state (for debugging)
3. **Wait** for elements to load
4. **Interact** (click, fill, etc.)
5. **Screenshot** result
6. **Extract** data if needed
7. **Close** when done

## Mandatory Checks

- [ ] Verify MCP server is configured: `claude mcp list`
- [ ] Take screenshot after navigation to confirm page loaded
- [ ] Verify element exists before interacting
- [ ] Screenshot after actions to confirm success

## Best Practices

- Screenshot before AND after actions
- Use specific selectors (ID > class > tag)
- Add waits for dynamic content
- Handle errors gracefully (element not found)
- Close browser session when finished

## Should NOT Do

- Use for simple static pages (WebFetch is faster)
- Leave browser sessions open
- Click without waiting for element
- Ignore screenshot evidence
- Bypass CAPTCHA or rate limits

## Escalate When

- Site blocks automation (CAPTCHA)
- Complex auth flows (OAuth, MFA)
- Heavy JS frameworks timing out
- Need persistent session state
- MCP server not responding

For advanced patterns and troubleshooting, see SKILL.md.
