# Command Creator Instructions (Tier 2)

**Key principle:** Discoverability, predictable behavior, safe defaults.

## Command vs Skill vs Agent

| Type | Trigger | Purpose |
|------|---------|---------|
| Command | `/name` explicit | User-initiated workflows |
| Skill | Auto or explicit | Procedural knowledge |
| Agent | `Task(subagent_type)` | Subagent execution |

## Creation Process

1. **Initialize** - `~/.claude/skills/command-creator/scripts/init_command.py <name> --description "<desc>" [--global]`
2. **Edit** - Complete workflow steps with bash examples
3. **Test** - Invoke with `/command-name`

## Frontmatter Fields

```yaml
---
description: Short description for /commands list
allowed-tools: Bash, Read, Edit
argument-hint: [file-path]
context: fork  # Optional: run in isolated context
---
```

## Required Sections

| Section | Purpose |
|---------|---------|
| Workflow | Numbered steps with bash examples |
| Example Output | What success looks like |
| Should NOT Attempt | Anti-patterns |
| Escalation | When to stop or ask |

## Should NOT Do

- Create commands that overlap built-in (/help, /clear, /compact)
- Commands without clear workflow steps
- Commands that should be skills (auto-triggered)
- Overly broad commands (split them)

## Escalate When

- Command scope overlaps existing command
- Would benefit from auto-triggering (→ skill instead)
- Needs subagent execution (→ agent instead)

For templates, examples, and detailed patterns, see SKILL.md.
