# Git Workflow Instructions

**Key principle:** Systematic setup + safety verification + structured completion = reliable workflow.

## Process

### Setup Phase
1. **Check directories** - Look for `.worktrees/` or `worktrees/`
2. **Verify .gitignore** - Must include worktree directory before creating
3. **Create worktree** - `git worktree add <path> -b <branch>`
4. **Run setup** - Install deps, run baseline tests
5. **Report ready** - Confirm path and test status

### Completion Phase
1. **Verify tests** - Must pass before proceeding
2. **Present 4 options** - Merge locally, Create PR, Keep as-is, Discard
3. **Execute choice** - Follow option-specific steps
4. **Cleanup** - Remove worktree for options 1 and 4 only

## Mandatory Checks

- [ ] Tests pass at setup AND completion
- [ ] .gitignore verified before creating local worktree
- [ ] Typed confirmation for discard option

## Should NOT Do

- Proceed with failing tests
- Delete work without typed "discard" confirmation
- Cleanup worktree when keeping branch (options 2, 3)

## Escalate When

- Tests fail during baseline → ask proceed or investigate
- Complex merge needed → `git-expert` agent
- .gitignore modification rejected → ask user

For directory selection, completion options, and failure handling, see SKILL.md.
